/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.plaf.nimbus;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.border.CompoundBorder;
import net.yura.mobile.gui.border.EmptyBorder;
import net.yura.mobile.gui.border.LineBorder;
import net.yura.mobile.gui.border.MatteBorder;
import net.yura.mobile.gui.plaf.MetalScrollBar;
import net.yura.mobile.gui.plaf.Style;
import net.yura.mobile.gui.plaf.SynthLookAndFeel;
import net.yura.mobile.gui.plaf.nimbus.NimbusBorder;
import net.yura.mobile.gui.plaf.nimbus.NimbusBorderSetting;
import net.yura.mobile.gui.plaf.nimbus.NimbusIcon;

public class NimbusLookAndFeel
extends SynthLookAndFeel {
    private Hashtable uiSettings = new Hashtable();

    public NimbusLookAndFeel() {
        this(0);
    }

    public NimbusLookAndFeel(int size) {
        this(size, null);
    }

    public NimbusLookAndFeel(int size, Hashtable styles) {
        String componentName;
        if (styles != null) {
            this.uiSettings = styles;
        }
        Integer noColor = new Integer(0);
        this.setUIDefault("control", new Integer(-2696737));
        this.setUIDefault("info", new Integer(-855363));
        this.setUIDefault("nimbusAlertYellow", new Integer(-9181));
        this.setUIDefault("nimbusBase", new Integer(-13409652));
        this.setUIDefault("nimbusDisabledText", new Integer(-7434351));
        this.setUIDefault("nimbusFocus", new Integer(-9198383));
        this.setUIDefault("nimbusGreen", new Integer(-5197006));
        this.setUIDefault("nimbusInfoBlue", new Integer(-13673292));
        this.setUIDefault("nimbusLightBackground", new Integer(-1));
        this.setUIDefault("nimbusOrange", new Integer(-4234748));
        this.setUIDefault("nimbusRed", new Integer(-5689822));
        this.setUIDefault("nimbusSelectedText", new Integer(-1));
        this.setUIDefault("nimbusSelectionBackground", new Integer(-13014646));
        this.setUIDefault("text", new Integer(-16777216));
        this.setUIDefault("info", new Integer(NimbusBorder.getRGB(242, 242, 189)));
        this.setUIDefault("nimbusBlueGrey", this.getDerivedColor("nimbusBase", 0.032459438f, -0.48f, 0.19607842f, 0.0f));
        this.setUIDefault("background", this.uiSettings.get("control"));
        this.setUIDefault("infoText", this.getDerivedColor("text", 0.0f, 0.0f, 0.0f, 0.0f));
        this.setUIDefault("menuText", this.getDerivedColor("text", 0.0f, 0.0f, 0.0f, 0.0f));
        this.setUIDefault("menu", this.getDerivedColor("nimbusBase", 0.021348298f, -0.6150531f, 0.39999998f, 0.0f));
        this.setUIDefault("scrollbar", this.getDerivedColor("nimbusBlueGrey", -0.006944418f, -0.07296763f, 0.09019607f, 0.0f));
        this.setUIDefault("controlText", this.getDerivedColor("text", 0.0f, 0.0f, 0.0f, 0.0f));
        this.setUIDefault("controlHighlight", this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.07333623f, 0.20392156f, 0.0f));
        this.setUIDefault("controlLHighlight", this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.098526314f, 0.2352941f, 0.0f));
        this.setUIDefault("controlShadow", this.getDerivedColor("nimbusBlueGrey", -0.0027777553f, -0.0212406f, 0.13333333f, 0.0f));
        this.setUIDefault("controlDkShadow", this.getDerivedColor("nimbusBlueGrey", -0.0027777553f, -0.0018306673f, -0.02352941f, 0.0f));
        this.setUIDefault("textHighlight", this.getDerivedColor("nimbusSelectionBackground", 0.0f, 0.0f, 0.0f, 0.0f));
        this.setUIDefault("textHighlightText", this.getDerivedColor("nimbusSelectedText", 0.0f, 0.0f, 0.0f, 0.0f));
        this.setUIDefault("textInactiveText", this.getDerivedColor("nimbusDisabledText", 0.0f, 0.0f, 0.0f, 0.0f));
        this.setUIDefault("desktop", this.getDerivedColor("nimbusBase", -0.009207249f, -0.13984653f, -0.07450983f, 0.0f));
        this.setUIDefault("activeCaption", this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.049920253f, 0.031372547f, 0.0f));
        this.setUIDefault("inactiveCaption", this.getDerivedColor("nimbusBlueGrey", -0.00505054f, -0.055526316f, 0.039215684f, 0.0f));
        this.setUIDefault("nimbusBorder", this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.017358616f, -0.11372548f, 0.0f));
        this.setUIDefault("nimbusSelection", this.getDerivedColor("nimbusBase", -0.010750473f, -0.04875779f, -0.007843137f, 0.0f));
        this.setUIDefault("font", new Font(64, 0, size));
        int color2 = this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.01f, -0.38f, 0.0f);
        int color3 = this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.07f, 0.21f, 0.0f);
        int color4 = this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.07f, 0.12f, 0.0f);
        int color24 = this.getDerivedColor("nimbusBlueGrey", 0.0f, 0.11f, -0.54f, 0.0f);
        int color25 = this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.1f, 0.26f, 0.0f);
        int color26 = this.getDerivedColor("nimbusBlueGrey", 0.0f, -0.07f, 0.17f, 0.0f);
        int color5 = this.getDerivedColor("nimbusBase", 0.0f, -0.35f, 0.01f, 0.0f);
        int color6 = this.getDerivedColor("nimbusBase", 0.0f, -0.1f, -0.26f, 0.0f);
        int color7 = this.getDerivedColor("nimbusBase", 0.0f, -0.58f, 0.38f, 0.0f);
        int color8 = this.getDerivedColor("nimbusBase", 0.0f, -0.44f, 0.3f, 0.0f);
        int color10 = this.getDerivedColor("nimbusBase", 0.0f, -0.18f, -0.12f, 0.0f);
        int color11 = this.getDerivedColor("nimbusBase", 0.0f, -0.62f, 0.44f, 0.0f);
        int color12 = this.getDerivedColor("nimbusBase", 0.0f, -0.46f, 0.32f, 0.0f);
        int color13 = this.getDerivedColor("nimbusBase", -1.0f, -1.0f, -1.0f, 0.0f);
        int color14 = this.getDerivedColor("nimbusBase", 0.0f, 0.1f, -0.23f, 0.0f);
        int color15 = this.getDerivedColor("nimbusBase", 0.0f, -0.3f, 0.15f, 0.0f);
        int color16 = this.getDerivedColor("nimbusBase", 0.0f, -0.0f, 0.0f, 0.0f);
        int color18 = this.getDerivedColor("nimbusBase", 0.05f, -0.5f, 0.26f, 0.0f);
        int color19 = this.getDerivedColor("nimbusBase", 0.03f, -0.59f, 0.34f, 0.0f);
        int color20 = this.getDerivedColor("nimbusBase", 0.03f, -0.57f, 0.31f, 0.0f);
        this.setUIDefault("foreground", this.uiSettings.get("text"));
        LineBorder windowBorder = new LineBorder(this.decodeColor("desktop"), 0, 1, true, 1);
        this.setUIDefault("Frame.border", windowBorder);
        this.setUIDefault("Dialog.background", this.uiSettings.get("controlHighlight"));
        this.setUIDefault("Dialog.border", windowBorder);
        int[] bottomBorderOnly = new int[]{0, 0, 1, 0};
        Vector<NimbusBorderSetting> titleSettings = new Vector<NimbusBorderSetting>();
        titleSettings.addElement(new NimbusBorderSetting(this.decodeColor("controlDkShadow"), this.decodeColor("controlDkShadow"), bottomBorderOnly, 0, 1.0));
        titleSettings.addElement(new NimbusBorderSetting(this.decodeColor("controlHighlight"), this.decodeColor("controlShadow"), 1, 0, 1.0));
        NimbusBorder title = new NimbusBorder(titleSettings);
        this.setUIDefault("TitleBar.border", title);
        this.setUIDefault("TitleBar.background", noColor);
        Vector<NimbusBorderSetting> menuSettings = new Vector<NimbusBorderSetting>();
        int menuBarBorderColor = this.getDerivedColor("background", 0.0f, 0.0f, -0.1f, 0.0f);
        int menuBarShadow = this.getDerivedColor("background", 0.0f, 0.0f, -0.05f, 0.0f);
        menuSettings.addElement(new NimbusBorderSetting(menuBarBorderColor, menuBarBorderColor, bottomBorderOnly, 0, 1.0));
        menuSettings.addElement(new NimbusBorderSetting(this.decodeColor("background"), menuBarShadow, 1, 0, 1.0));
        NimbusBorder menubar = new NimbusBorder(menuSettings);
        this.setUIDefault("MenuBar.border", menubar);
        this.setUIDefault("MenuBar.background", noColor);
        this.setUIDefault("Label.background", noColor);
        this.setUIDefault("TitleBarLabel.background", noColor);
        Vector<NimbusBorderSetting> defaultBorderSettings = new Vector<NimbusBorderSetting>();
        defaultBorderSettings.addElement(new NimbusBorderSetting(color5, color5, 1, 3, 1.0));
        defaultBorderSettings.addElement(new NimbusBorderSetting(color7, color8, 1, 2, 0.65));
        Vector<NimbusBorderSetting> focusedBorderSettings = new Vector<NimbusBorderSetting>();
        focusedBorderSettings.addElement(new NimbusBorderSetting(color24, color24, 1, 3, 1.0));
        focusedBorderSettings.addElement(new NimbusBorderSetting(color25, color26, 1, 2, 0.65));
        Vector<NimbusBorderSetting> selectedBorderSettings = new Vector<NimbusBorderSetting>();
        selectedBorderSettings.addElement(new NimbusBorderSetting(color14, color14, 1, 3, 1.0));
        selectedBorderSettings.addElement(new NimbusBorderSetting(color15, color16, 1, 2, 0.65));
        Vector<NimbusBorderSetting> disabledBorderSettings = new Vector<NimbusBorderSetting>();
        disabledBorderSettings.addElement(new NimbusBorderSetting(color18, color18, 1, 3, 1.0));
        disabledBorderSettings.addElement(new NimbusBorderSetting(color19, color20, 1, 2, 0.65));
        this.setUIDefault("Button.border", new NimbusBorder(defaultBorderSettings));
        this.setUIDefault("Button.background", noColor);
        this.setUIDefault("Button[focused].border", new NimbusBorder(focusedBorderSettings));
        this.setUIDefault("Button[selected].border", new NimbusBorder(selectedBorderSettings));
        this.setUIDefault("Button[selected].foreground", this.uiSettings.get("nimbusSelectedText"));
        this.setUIDefault("Button[focused+selected].foreground", this.uiSettings.get("nimbusSelectedText"));
        this.setUIDefault("Button[disabled].border", new NimbusBorder(disabledBorderSettings));
        this.setUIDefault("Button[disabled].foreground", this.uiSettings.get("inactiveCaption"));
        int[] leftCorners = new int[]{3, 0, 3, 0};
        int[] leftInnerCorners = new int[]{2, 0, 2, 0};
        Vector<NimbusBorderSetting> buttonLeftSettings = new Vector<NimbusBorderSetting>();
        buttonLeftSettings.addElement(new NimbusBorderSetting(0, 0, 1, leftCorners, 1.0));
        buttonLeftSettings.addElement(new NimbusBorderSetting(color5, color5, new int[]{0, 1, 0, 0}, leftCorners, 1.0));
        buttonLeftSettings.addElement(new NimbusBorderSetting(color7, color8, 1, leftInnerCorners, 0.65));
        Vector<NimbusBorderSetting> buttonLeftSelectedSettings = new Vector<NimbusBorderSetting>();
        buttonLeftSelectedSettings.addElement(new NimbusBorderSetting(0, 0, 1, leftCorners, 1.0));
        buttonLeftSelectedSettings.addElement(new NimbusBorderSetting(color13, color13, new int[]{0, 1, 0, 0}, leftCorners, 1.0));
        buttonLeftSelectedSettings.addElement(new NimbusBorderSetting(color15, color16, 1, leftInnerCorners, 0.65));
        int[] rightCorners = new int[]{0, 3, 0, 3};
        int[] rightInnerCorners = new int[]{0, 2, 0, 2};
        Vector<NimbusBorderSetting> buttonRightSettings = new Vector<NimbusBorderSetting>();
        buttonRightSettings.addElement(new NimbusBorderSetting(0, 0, 1, rightCorners, 1.0));
        buttonRightSettings.addElement(new NimbusBorderSetting(color5, color5, new int[]{0, 0, 0, 1}, rightCorners, 1.0));
        buttonRightSettings.addElement(new NimbusBorderSetting(color7, color8, 1, rightInnerCorners, 0.65));
        Vector<NimbusBorderSetting> buttonRightSelectedSettings = new Vector<NimbusBorderSetting>();
        buttonRightSelectedSettings.addElement(new NimbusBorderSetting(color14, color14, 1, rightCorners, 1.0));
        buttonRightSelectedSettings.addElement(new NimbusBorderSetting(color15, color16, 1, rightInnerCorners, 0.65));
        Font font = (Font)this.uiSettings.get("font");
        Vector<NimbusBorderSetting> textareaBorderSettings = new Vector<NimbusBorderSetting>();
        int colorLightYellow = this.getDerivedColor("nimbusAlertYellow", 0.02f, -0.59f, 0.0f, 0.0f);
        textareaBorderSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusBorder"), this.decodeColor("nimbusBorder"), 1, 0, 1.0));
        textareaBorderSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusLightBackground"), this.decodeColor("nimbusLightBackground"), 1, 0, 1.0));
        Vector<NimbusBorderSetting> textareaFocusedSettings = new Vector<NimbusBorderSetting>();
        this.copyBorders(textareaBorderSettings, textareaFocusedSettings);
        textareaFocusedSettings.setElementAt(new NimbusBorderSetting(this.decodeColor("nimbusLightBackground"), colorLightYellow, 1, 0, 1.0), 1);
        Vector textareaDisabledSettings = new Vector();
        this.copyBorders(textareaBorderSettings, textareaDisabledSettings);
        this.setUIDefault("TextField.background", noColor);
        this.setUIDefault("TextField.border", new NimbusBorder(textareaBorderSettings));
        this.setUIDefault("TextField[focused].border", new NimbusBorder(textareaFocusedSettings));
        this.setUIDefault("TextField[disabled].border", new NimbusBorder(textareaDisabledSettings));
        this.setUIDefault("TextArea.background", this.uiSettings.get("nimbusLightBackground"));
        this.setUIDefault("TextArea[disabled].background", noColor);
        Vector listSettings = new Vector();
        Vector<NimbusBorderSetting> listItemSettings = new Vector<NimbusBorderSetting>();
        Vector<NimbusBorderSetting> listItemFocusedSettings = new Vector<NimbusBorderSetting>();
        Vector<NimbusBorderSetting> listItemSelectedSettings = new Vector<NimbusBorderSetting>();
        Vector<NimbusBorderSetting> listItemFocusedSelectedSettings = new Vector<NimbusBorderSetting>();
        int[] topBorderOnly = new int[]{1, 0, 0, 0};
        int[] topAndBottomBorders = new int[]{1, 0, 1, 0};
        this.copyBorders(textareaBorderSettings, listSettings);
        this.setUIDefault("Popup.border", new NimbusBorder(listSettings));
        this.setUIDefault("Menu.border", new NimbusBorder(listSettings));
        int seperatorBackground = this.getDerivedColor("nimbusLightBackground", 0.0f, 0.0f, -0.05f, 0.0f);
        int seperatorSelectedBackground = this.getDerivedColor("nimbusSelection", 0.0f, 0.0f, -0.05f, 0.0f);
        int darkerBackground = this.getDerivedColor("nimbusLightBackground", 0.0f, 0.0f, -0.15f, 0.0f);
        int darkerSelection = this.getDerivedColor("nimbusSelection", 0.0f, 0.0f, -0.1f, 0.0f);
        int lighterSelection = this.getDerivedColor("nimbusSelection", 0.0f, -0.1f, 0.2f, 0.0f);
        listItemSettings.addElement(new NimbusBorderSetting(seperatorBackground, seperatorBackground, bottomBorderOnly, 0, 1.0));
        listItemSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusLightBackground"), this.decodeColor("nimbusLightBackground"), topBorderOnly, 0, 1.0));
        listItemSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusLightBackground"), this.decodeColor("nimbusLightBackground"), 0, 0, 1.0));
        listItemFocusedSettings.addElement(new NimbusBorderSetting(darkerBackground, darkerBackground, topAndBottomBorders, 0, 1.0));
        listItemFocusedSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusLightBackground"), darkerBackground, 1, 0, 0.65));
        listItemSelectedSettings.addElement(new NimbusBorderSetting(seperatorSelectedBackground, seperatorSelectedBackground, bottomBorderOnly, 0, 1.0));
        listItemSelectedSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusSelection"), this.decodeColor("nimbusSelection"), topBorderOnly, 0, 1.0));
        listItemSelectedSettings.addElement(new NimbusBorderSetting(this.decodeColor("nimbusSelection"), this.decodeColor("nimbusSelection"), 0, 0, 1.0));
        listItemFocusedSelectedSettings.addElement(new NimbusBorderSetting(darkerSelection, darkerSelection, topAndBottomBorders, 0, 1.0));
        listItemFocusedSelectedSettings.addElement(new NimbusBorderSetting(lighterSelection, this.decodeColor("nimbusSelection"), 1, 0, 0.65));
        NimbusBorder tmp1 = new NimbusBorder(listItemSettings);
        NimbusBorder tmp2 = new NimbusBorder(listItemSelectedSettings);
        NimbusBorder tmp3 = new NimbusBorder(listItemFocusedSettings);
        NimbusBorder tmp4 = new NimbusBorder(listItemFocusedSelectedSettings);
        String[] components = new String[]{"ListRenderer", "PopupListRenderer", "CheckBoxRenderer", "ListRendererCollapsed"};
        for (int c = 0; c < components.length; ++c) {
            componentName = components[c];
            this.setUIDefault(componentName + ".background", noColor);
            this.setUIDefault(componentName + ".border", tmp1);
            this.setUIDefault(componentName + "[selected].border", tmp2);
            this.setUIDefault(componentName + "[selected].foreground", this.uiSettings.get("nimbusSelectedText"));
            this.setUIDefault(componentName + "[disabled].foreground", this.uiSettings.get("nimbusDisabledText"));
            this.setUIDefault(componentName + "[focused].border", tmp3);
            this.setUIDefault(componentName + "[focused+selected].border", tmp4);
        }
        this.setUIDefault("List.background", this.uiSettings.get("nimbusLightBackground"));
        componentName = "MenuRenderer";
        this.setUIDefault(componentName + ".background", noColor);
        this.setUIDefault(componentName + ".border", new EmptyBorder(tmp2.getTop(), tmp2.getLeft(), tmp2.getBottom(), tmp2.getRight()));
        this.setUIDefault(componentName + "[selected].border", tmp2);
        this.setUIDefault(componentName + "[selected].foreground", this.uiSettings.get("nimbusSelectedText"));
        this.setUIDefault(componentName + "[disabled].foreground", this.uiSettings.get("nimbusDisabledText"));
        Vector<NimbusBorderSetting> comboBorderSettings = new Vector<NimbusBorderSetting>();
        comboBorderSettings.addElement(new NimbusBorderSetting(color2, color2, 1, 3, 1.0));
        comboBorderSettings.addElement(new NimbusBorderSetting(color3, color4, 1, 2, 0.65));
        Vector<NimbusBorderSetting> comboSelectedSettings = new Vector<NimbusBorderSetting>();
        comboSelectedSettings.addElement(new NimbusBorderSetting(color24, color24, 1, 3, 1.0));
        comboSelectedSettings.addElement(new NimbusBorderSetting(color25, color26, 1, 2, 0.65));
        Vector<NimbusBorderSetting> comboDisabledSettings = new Vector<NimbusBorderSetting>();
        comboDisabledSettings.addElement(new NimbusBorderSetting(color18, color18, 1, 3, 1.0));
        comboDisabledSettings.addElement(new NimbusBorderSetting(color19, color20, 1, 2, 0.65));
        NimbusIcon comboBoxIcon = new NimbusIcon(font.getHeight() + 6, 2, buttonRightSettings, this.decodeColor("text"));
        NimbusIcon comboBoxSelectedIcon = new NimbusIcon(font.getHeight() + 6, 2, buttonRightSelectedSettings, this.decodeColor("nimbusSelectedText"));
        NimbusIcon comboBoxDisabledIcon = new NimbusIcon(font.getHeight() + 6, 2, disabledBorderSettings, this.decodeColor("nimbusDisabledText"));
        this.setUIDefault("ComboBox.border", new NimbusBorder(comboBorderSettings));
        this.setUIDefault("ComboBox.background", noColor);
        this.setUIDefault("ComboBox.property[arrow]", comboBoxIcon);
        this.setUIDefault("ComboBox[focused].border", new NimbusBorder(comboSelectedSettings));
        this.setUIDefault("ComboBox[selected].border", new NimbusBorder(comboSelectedSettings));
        this.setUIDefault("ComboBox[selected].property[arrow]", comboBoxSelectedIcon);
        this.setUIDefault("ComboBox[disabled].border", new NimbusBorder(comboDisabledSettings));
        this.setUIDefault("ComboBox[disabled].foreground", this.uiSettings.get("nimbusDisabledText"));
        this.setUIDefault("ComboBox[disabled].property[arrow]", comboBoxDisabledIcon);
        Vector<NimbusBorderSetting> checkboxSettings = new Vector<NimbusBorderSetting>();
        checkboxSettings.addElement(new NimbusBorderSetting());
        checkboxSettings.addElement(new NimbusBorderSetting(color2, color2, 1, 1, 1.0));
        checkboxSettings.addElement(new NimbusBorderSetting(color3, color4, 1, 1, 1.0));
        NimbusIcon checkboxIcon = new NimbusIcon(font.getHeight(), 1, checkboxSettings, this.decodeColor("text"));
        NimbusIcon checkboxSelectedIcon = new NimbusIcon(font.getHeight(), 1, checkboxSettings, this.decodeColor("text"));
        LineBorder nullBorder = new LineBorder(this.decodeColor("background"));
        this.setUIDefault("CheckBox.border", nullBorder);
        this.setUIDefault("CheckBox[focused].border", new LineBorder(this.decodeColor("nimbusBorder"), 0, 1, false, 1));
        this.setUIDefault("CheckBox.property[icon]", checkboxIcon);
        this.setUIDefault("CheckBox[selected].property[icon]", checkboxSelectedIcon);
        this.setUIDefault("CheckBox[disabled].foreground", this.uiSettings.get("nimbusDisabledText"));
        this.setUIDefault("CheckBoxRenderer.property[icon]", checkboxIcon);
        this.setUIDefault("CheckBoxRenderer[selected].property[icon]", checkboxSelectedIcon);
        Vector<NimbusBorderSetting> radioSettings = new Vector<NimbusBorderSetting>();
        radioSettings.addElement(new NimbusBorderSetting());
        radioSettings.addElement(new NimbusBorderSetting(color2, color2, 1, 3, 1.0));
        radioSettings.addElement(new NimbusBorderSetting(color3, color4, 1, 3, 1.0));
        Vector<NimbusBorderSetting> radioSelectedSettings = new Vector<NimbusBorderSetting>();
        radioSelectedSettings.addElement(new NimbusBorderSetting());
        radioSelectedSettings.addElement(new NimbusBorderSetting(color10, color10, 1, 3, 1.0));
        radioSelectedSettings.addElement(new NimbusBorderSetting(color11, color12, 1, 3, 1.0));
        NimbusIcon radioIcon = new NimbusIcon(font.getHeight(), 0, radioSettings, this.decodeColor("text"));
        NimbusIcon radioFocusedIcon = new NimbusIcon(font.getHeight(), 0, radioSelectedSettings, this.decodeColor("text"));
        this.setUIDefault("RadioButton.border", nullBorder);
        this.setUIDefault("RadioButton[focused].border", new LineBorder(this.decodeColor("nimbusBorder"), 0, 1, false, 1));
        this.setUIDefault("RadioButton.property[icon]", radioIcon);
        this.setUIDefault("RadioButton[selected].property[icon]", radioIcon);
        this.setUIDefault("RadioButton[disabled].foreground", this.uiSettings.get("nimbusDisabledText"));
        NimbusIcon spinnerLeftIcon = new NimbusIcon(font.getHeight() + 6, 3, buttonLeftSettings, this.decodeColor("text"));
        NimbusIcon spinnerLeftSelectedIcon = new NimbusIcon(font.getHeight() + 6, 3, buttonLeftSelectedSettings, this.decodeColor("nimbusSelectedText"));
        NimbusIcon spinnerRightIcon = new NimbusIcon(font.getHeight() + 6, 4, buttonRightSettings, this.decodeColor("text"));
        NimbusIcon spinnerRightSelectedIcon = new NimbusIcon(font.getHeight() + 6, 4, buttonRightSelectedSettings, this.decodeColor("nimbusSelectedText"));
        Vector spinnerBorderSettings = new Vector();
        Vector spinnerSelectedSettings = new Vector();
        Vector spinnerDisabledSettings = new Vector();
        this.copyBorders(comboBorderSettings, spinnerBorderSettings);
        this.copyBorders(comboSelectedSettings, spinnerSelectedSettings);
        this.copyBorders(comboDisabledSettings, spinnerDisabledSettings);
        this.setUIDefault("Spinner.background", noColor);
        this.setUIDefault("Spinner.border", new NimbusBorder(spinnerBorderSettings, 0, 0, 20, 0));
        this.setUIDefault("Spinner[focused].border", new NimbusBorder(spinnerSelectedSettings, 0, 0, 20, 0));
        this.setUIDefault("Spinner.property[iconLeft]", spinnerLeftIcon);
        this.setUIDefault("Spinner[selected].property[iconLeft]", spinnerLeftSelectedIcon);
        this.setUIDefault("Spinner.property[iconRight]", spinnerRightIcon);
        this.setUIDefault("Spinner[selected].property[iconRight]", spinnerRightSelectedIcon);
        int[] topTabRendererBorders = new int[]{1, 1, 0, 1};
        int[] topCorners = new int[]{3, 3, 0, 0};
        int[] topInnerCorners = new int[]{2, 2, 0, 0};
        Vector<NimbusBorderSetting> tabRendererTopSettings = new Vector<NimbusBorderSetting>();
        tabRendererTopSettings.addElement(new NimbusBorderSetting(color24, color24, topTabRendererBorders, topCorners, 1.0));
        tabRendererTopSettings.addElement(new NimbusBorderSetting(color25, color26, topTabRendererBorders, topInnerCorners, 1.0));
        NimbusBorder tabRendererTop = new NimbusBorder(tabRendererTopSettings, 1, 2, 2, 2);
        Vector<NimbusBorderSetting> tabRendererTopFocusedSettings = new Vector<NimbusBorderSetting>();
        tabRendererTopFocusedSettings.addElement(new NimbusBorderSetting(color13, color2, topTabRendererBorders, topCorners, 1.0));
        tabRendererTopFocusedSettings.addElement(new NimbusBorderSetting(color15, color8, topTabRendererBorders, topInnerCorners, 1.0));
        NimbusBorder tabRendererTopFocused = new NimbusBorder(tabRendererTopFocusedSettings, 1, 1, 2, 2);
        Vector<NimbusBorderSetting> tabRendererTopSelectedSettings = new Vector<NimbusBorderSetting>();
        tabRendererTopSelectedSettings.addElement(new NimbusBorderSetting(color6, color6, topTabRendererBorders, topCorners, 1.0));
        tabRendererTopSelectedSettings.addElement(new NimbusBorderSetting(color7, color8, topTabRendererBorders, topInnerCorners, 1.0));
        NimbusBorder tabRendererTopSelected = new NimbusBorder(tabRendererTopSelectedSettings, 1, 1, 2, 2);
        this.setUIDefault("TabRendererTop.background", noColor);
        this.setUIDefault("TabRendererTop.border", tabRendererTop);
        this.setUIDefault("TabRendererTop[focused+selected].border", tabRendererTopFocused);
        this.setUIDefault("TabRendererTop[selected].border", tabRendererTopSelected);
        int[] bottomTabRendererBorders = new int[]{0, 1, 1, 1};
        int[] bottomCorners = new int[]{0, 0, 3, 3};
        int[] bottomInnerCorners = new int[]{0, 0, 2, 2};
        Vector<NimbusBorderSetting> tabRendererBottomSettings = new Vector<NimbusBorderSetting>();
        tabRendererBottomSettings.addElement(new NimbusBorderSetting(color24, color24, bottomTabRendererBorders, bottomCorners, 1.0));
        tabRendererBottomSettings.addElement(new NimbusBorderSetting(color25, color26, bottomTabRendererBorders, bottomInnerCorners, 1.0));
        NimbusBorder tabRendererBottom = new NimbusBorder(tabRendererBottomSettings, 1, 2, 2, 2);
        Vector<NimbusBorderSetting> tabRendererBottomFocusedSettings = new Vector<NimbusBorderSetting>();
        tabRendererBottomFocusedSettings.addElement(new NimbusBorderSetting(color13, color2, bottomTabRendererBorders, bottomCorners, 1.0));
        tabRendererBottomFocusedSettings.addElement(new NimbusBorderSetting(color15, color8, bottomTabRendererBorders, bottomInnerCorners, 1.0));
        NimbusBorder tabRendererBottomFocused = new NimbusBorder(tabRendererBottomFocusedSettings, 1, 1, 2, 2);
        Vector<NimbusBorderSetting> tabRendererBottomSelectedSettings = new Vector<NimbusBorderSetting>();
        tabRendererBottomSelectedSettings.addElement(new NimbusBorderSetting(color13, color5, bottomTabRendererBorders, bottomCorners, 1.0));
        tabRendererBottomSelectedSettings.addElement(new NimbusBorderSetting(color15, color7, bottomTabRendererBorders, bottomInnerCorners, 1.0));
        NimbusBorder tabRendererBottomSelected = new NimbusBorder(tabRendererBottomSelectedSettings, 1, 1, 2, 2);
        this.setUIDefault("TabRendererBottom.background", noColor);
        this.setUIDefault("TabRendererBottom.border", tabRendererBottom);
        this.setUIDefault("TabRendererBottom[focused+selected].border", tabRendererBottomFocused);
        this.setUIDefault("TabRendererBottom[selected].border", tabRendererBottomSelected);
        int[] leftTabRendererBorders = new int[]{1, 0, 1, 1};
        Vector<NimbusBorderSetting> tabRendererLeftSettings = new Vector<NimbusBorderSetting>();
        tabRendererLeftSettings.addElement(new NimbusBorderSetting(color24, color24, leftTabRendererBorders, leftCorners, 1.0, 90));
        tabRendererLeftSettings.addElement(new NimbusBorderSetting(color25, color26, leftTabRendererBorders, leftInnerCorners, 1.0, 90));
        NimbusBorder tabRendererLeft = new NimbusBorder(tabRendererLeftSettings, 2, 1, 2, 2);
        Vector<NimbusBorderSetting> tabRendererLeftFocusedSettings = new Vector<NimbusBorderSetting>();
        tabRendererLeftFocusedSettings.addElement(new NimbusBorderSetting(color13, color2, leftTabRendererBorders, leftCorners, 1.0, 90));
        tabRendererLeftFocusedSettings.addElement(new NimbusBorderSetting(color15, color8, leftTabRendererBorders, leftInnerCorners, 1.0, 90));
        NimbusBorder tabRendererLeftFocused = new NimbusBorder(tabRendererLeftFocusedSettings, 1, 1, 2, 2);
        Vector<NimbusBorderSetting> tabRendererLeftSelectedSettings = new Vector<NimbusBorderSetting>();
        tabRendererLeftSelectedSettings.addElement(new NimbusBorderSetting(color5, color2, leftTabRendererBorders, leftCorners, 1.0, 90));
        tabRendererLeftSelectedSettings.addElement(new NimbusBorderSetting(color7, color8, leftTabRendererBorders, leftInnerCorners, 1.0, 90));
        NimbusBorder tabRendererLeftSelected = new NimbusBorder(tabRendererLeftSelectedSettings, 1, 1, 2, 2);
        this.setUIDefault("TabRendererLeft.background", noColor);
        this.setUIDefault("TabRendererLeft.border", tabRendererLeft);
        this.setUIDefault("TabRendererLeft[focused+selected].border", tabRendererLeftFocused);
        this.setUIDefault("TabRendererLeft[selected].border", tabRendererLeftSelected);
        int[] rightTabRendererBorders = new int[]{1, 1, 1, 0};
        Vector<NimbusBorderSetting> tabRendererRightSettings = new Vector<NimbusBorderSetting>();
        tabRendererRightSettings.addElement(new NimbusBorderSetting(color24, color24, rightTabRendererBorders, rightCorners, 1.0, 90));
        tabRendererRightSettings.addElement(new NimbusBorderSetting(color26, color25, rightTabRendererBorders, rightInnerCorners, 1.0, 90));
        NimbusBorder tabRendererRight = new NimbusBorder(tabRendererRightSettings, 2, 1, 2, 2);
        Vector<NimbusBorderSetting> tabRendererRightFocusedSettings = new Vector<NimbusBorderSetting>();
        tabRendererRightFocusedSettings.addElement(new NimbusBorderSetting(color13, color2, rightTabRendererBorders, rightCorners, 1.0, 90));
        tabRendererRightFocusedSettings.addElement(new NimbusBorderSetting(color15, color8, rightTabRendererBorders, rightInnerCorners, 1.0, 90));
        NimbusBorder tabRendererRightFocused = new NimbusBorder(tabRendererRightFocusedSettings, 1, 1, 2, 2);
        Vector<NimbusBorderSetting> tabRendererRightSelectedSettings = new Vector<NimbusBorderSetting>();
        tabRendererRightSelectedSettings.addElement(new NimbusBorderSetting(color13, color5, rightTabRendererBorders, rightCorners, 1.0, 90));
        tabRendererRightSelectedSettings.addElement(new NimbusBorderSetting(color15, color7, rightTabRendererBorders, rightInnerCorners, 1.0, 90));
        NimbusBorder tabRendererRightSelected = new NimbusBorder(tabRendererRightSelectedSettings, 1, 1, 2, 2);
        this.setUIDefault("TabRendererRight.background", noColor);
        this.setUIDefault("TabRendererRight.border", tabRendererRight);
        this.setUIDefault("TabRendererRight[focused+selected].border", tabRendererRightFocused);
        this.setUIDefault("TabRendererRight[selected].border", tabRendererRightSelected);
        CompoundBorder tabTop = new CompoundBorder(new MatteBorder(0, 0, 1, 0, color2), new MatteBorder(0, 0, 2, 0, color8));
        tabTop = new CompoundBorder(tabTop, new MatteBorder(0, 0, 1, 0, color2));
        this.setUIDefault("TabTop.background", noColor);
        this.setUIDefault("TabTop.border", new CompoundBorder(tabTop, new EmptyBorder(0, 0, -2, 0)));
        CompoundBorder tabBottom = new CompoundBorder(new MatteBorder(1, 0, 0, 0, color2), new MatteBorder(2, 0, 0, 0, color15));
        tabBottom = new CompoundBorder(tabBottom, new MatteBorder(1, 0, 0, 0, color2));
        this.setUIDefault("TabBottom.background", noColor);
        this.setUIDefault("TabBottom.border", new CompoundBorder(tabBottom, new EmptyBorder(-2, 0, 0, 0)));
        CompoundBorder tabRight = new CompoundBorder(new MatteBorder(0, 1, 0, 0, color2), new MatteBorder(0, 2, 0, 0, color15));
        tabRight = new CompoundBorder(tabRight, new MatteBorder(0, 1, 0, 0, color2));
        this.setUIDefault("TabRight.background", noColor);
        this.setUIDefault("TabRight.border", new CompoundBorder(tabRight, new EmptyBorder(0, -2, 0, 0)));
        CompoundBorder tabLeft = new CompoundBorder(new MatteBorder(0, 0, 0, 1, color2), new MatteBorder(0, 0, 0, 2, color8));
        tabLeft = new CompoundBorder(tabLeft, new MatteBorder(0, 0, 0, 1, color2));
        this.setUIDefault("TabLeft.background", noColor);
        this.setUIDefault("TabLeft.border", new CompoundBorder(tabLeft, new EmptyBorder(0, 0, 0, -2)));
        this.setUIDefault("ToolTip.background", this.uiSettings.get("nimbusAlertYellow"));
        this.setUIDefault("ToolTip.border", new LineBorder(this.decodeColor("nimbusOrange")));
        this.setUIDefault("Panel.background", noColor);
        this.setUIDefault("ScrollPane.background", noColor);
        NimbusIcon arrowUp = new NimbusIcon(font.getHeight(), 11, null, this.decodeColor("text"));
        NimbusIcon arrowDown = new NimbusIcon(font.getHeight(), 12, null, this.decodeColor("text"));
        NimbusIcon arrowLeft = new NimbusIcon(font.getHeight(), 14, null, this.decodeColor("text"));
        NimbusIcon arrowRight = new NimbusIcon(font.getHeight(), 13, null, this.decodeColor("text"));
        this.setUIDefault("ScrollPane.property[upArrow]", arrowUp);
        this.setUIDefault("ScrollPane.property[downArrow]", arrowDown);
        this.setUIDefault("ScrollPane.property[leftArrow]", arrowLeft);
        this.setUIDefault("ScrollPane.property[rightArrow]", arrowRight);
        int evensize = font.getHeight() / 2 * 2;
        Vector<NimbusBorderSetting> thumbFillSettings = new Vector<NimbusBorderSetting>();
        thumbFillSettings.addElement(new NimbusBorderSetting(color6, color6, 1, 0, 1.0));
        thumbFillSettings.addElement(new NimbusBorderSetting(color7, color8, 1, 0, 1.0));
        CompoundBorder thumb = new CompoundBorder(new NimbusBorder(thumbFillSettings), new EmptyBorder(font.getHeight() / 2 - 1, 1, font.getHeight() / 2 - 1, 1));
        this.setUIDefault("ScrollBarThumb.border", thumb);
        int[] singleBorder = new int[]{1, 1, 1, 1};
        Vector<NimbusBorderSetting> trackTopSettings = new Vector<NimbusBorderSetting>();
        trackTopSettings.addElement(new NimbusBorderSetting(color6, color6, singleBorder, leftCorners, 1.0));
        trackTopSettings.addElement(new NimbusBorderSetting(color7, color8, singleBorder, leftInnerCorners, 1.0));
        Vector<NimbusBorderSetting> trackBottomSettings = new Vector<NimbusBorderSetting>();
        trackBottomSettings.addElement(new NimbusBorderSetting(color6, color6, singleBorder, rightCorners, 1.0));
        trackBottomSettings.addElement(new NimbusBorderSetting(color7, color8, singleBorder, rightInnerCorners, 1.0));
        Vector<NimbusBorderSetting> trackFillSettings = new Vector<NimbusBorderSetting>();
        trackFillSettings.addElement(new NimbusBorderSetting(color4, color4, 1, 0, 1.0));
        NimbusIcon trackTop = new NimbusIcon(evensize, 14, trackTopSettings, this.decodeColor("text"));
        NimbusIcon trackBottom = new NimbusIcon(evensize, 13, trackBottomSettings, this.decodeColor("text"));
        CompoundBorder track = new CompoundBorder(new MetalScrollBar(trackTop, trackBottom), new CompoundBorder(new NimbusBorder(trackFillSettings), new EmptyBorder(font.getHeight() / 2, 0, font.getHeight() / 2, 0)));
        this.setUIDefault("ScrollBarTrack.border", track);
        int h = font.getHeight();
        Vector<NimbusBorderSetting> sliderSettings = new Vector<NimbusBorderSetting>();
        sliderSettings.addElement(new NimbusBorderSetting());
        sliderSettings.addElement(new NimbusBorderSetting(color5, color5, 1, 3, 1.0));
        sliderSettings.addElement(new NimbusBorderSetting(color7, color8, 1, 3, 1.0));
        this.setUIDefault("SliderThumb.border", new CompoundBorder(new NimbusBorder(sliderSettings), new EmptyBorder(h / 3, h / 3, h / 3, h / 3)));
        Vector<NimbusBorderSetting> sliderBorderSettings = new Vector<NimbusBorderSetting>();
        sliderBorderSettings.addElement(new NimbusBorderSetting(color2, color2, 1, 3, 1.0));
        sliderBorderSettings.addElement(new NimbusBorderSetting(color3, color4, 1, 2, 0.65));
        CompoundBorder strack = new CompoundBorder(new EmptyBorder(h / 4, 0, h / 4, 0), new CompoundBorder(new NimbusBorder(sliderBorderSettings), new EmptyBorder(h / 4, 0, h / 4, 0)));
        this.setUIDefault("SliderTrack.border", strack);
    }

    private void setUIDefault(String key, Object value) {
        if (!this.uiSettings.containsKey(key)) {
            this.uiSettings.put(key, value);
        } else {
            System.out.println("[NimbusLookAndFeel] UIDefault already set: " + key + " " + value);
        }
    }

    public int decodeColor(String name) {
        if (this.uiSettings.containsKey(name)) {
            return (Integer)this.uiSettings.get(name);
        }
        return 0;
    }

    private void copyBorders(Vector from, Vector too) {
        too.removeAllElements();
        for (int i = 0; i < from.size(); ++i) {
            too.insertElementAt(from.elementAt(i), i);
        }
    }

    public Style getStyle(String name) {
        Style style = super.getStyle(name);
        if (style != null) {
            return style;
        }
        Style defaultStyle = new Style();
        if (!name.equals("")) {
            defaultStyle = this.getStyle("");
        }
        style = new Style(defaultStyle);
        Hashtable<String, Integer> states = new Hashtable<String, Integer>();
        states.put("all", new Integer(0));
        states.put("focused", new Integer(4));
        states.put("selected", new Integer(8));
        states.put("disabled", new Integer(2));
        Enumeration settings = this.uiSettings.keys();
        Enumeration values = this.uiSettings.elements();
        boolean somethingSet = false;
        while (settings.hasMoreElements()) {
            String key = (String)settings.nextElement();
            Object value = values.nextElement();
            String setting = null;
            String component = null;
            String property = null;
            int styleState = 0;
            if (name.equals("")) {
                if (key.indexOf(".") == -1) {
                    setting = key;
                }
            } else if (key.startsWith(name + ".") || key.startsWith(name + "[")) {
                component = key.substring(0, key.indexOf("."));
                setting = key.substring(key.indexOf(".") + 1);
                if (component.indexOf("[") > -1) {
                    String state = component.substring(component.indexOf("["), component.indexOf("]"));
                    Enumeration stateNames = states.keys();
                    Enumeration stateValues = states.elements();
                    while (stateNames.hasMoreElements()) {
                        String stateName = (String)stateNames.nextElement();
                        Integer stateValue = (Integer)stateValues.nextElement();
                        if (state.indexOf(stateName) <= -1) continue;
                        styleState |= stateValue.intValue();
                    }
                }
            }
            if (setting == null) continue;
            somethingSet = true;
            if (setting.indexOf("[") > -1) {
                property = setting.substring(setting.indexOf("[") + 1, setting.indexOf("]"));
            }
            if (setting.equals("foreground")) {
                style.addForeground((Integer)value, styleState);
            }
            if (setting.equals("background")) {
                style.addBackground((Integer)value, styleState);
            }
            if (setting.equals("border")) {
                style.addBorder((Border)value, styleState);
            }
            if (setting.equals("font")) {
                style.addFont((Font)value, styleState);
            }
            if (property == null || setting.indexOf("property") != 0) continue;
            style.addProperty(value, property, styleState);
        }
        if (!somethingSet) {
            return null;
        }
        this.setStyleFor(name, style);
        return style;
    }

    public Integer getDerivedColor(String color, float hOffset, float sOffset, float bOffset, float aOffset) {
        int c = this.decodeColor(color);
        float[] tmp = NimbusLookAndFeel.RGBtoHSB(NimbusBorder.getRed(c), NimbusBorder.getGreen(c), NimbusBorder.getBlue(c), null);
        tmp[0] = this.clamp(tmp[0] + hOffset);
        tmp[1] = this.clamp(tmp[1] + sOffset);
        tmp[2] = this.clamp(tmp[2] + bOffset);
        int alpha = (int)(this.clamp((float)(c >> 24 & 0xFF) / 255.0f + aOffset) * 255.0f);
        int newColor = NimbusLookAndFeel.HSBtoRGB(tmp[0], tmp[1], tmp[2]) | alpha << 24;
        return new Integer(newColor);
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return value;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }
}

