/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.components.TextPane;
import net.yura.mobile.gui.layout.FlowLayout;
import net.yura.mobile.gui.layout.GridBagConstraints;
import net.yura.mobile.gui.layout.GridBagLayout;
import net.yura.mobile.gui.plaf.Style;
import net.yura.mobile.io.kxml2.KXmlParser;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Option;
import net.yura.mobile.util.StringUtil;

public class XHTMLLoader {
    Panel root;
    TagHandler currentTag;
    Component currentComponent;
    boolean newBlock;
    ActionListener al;
    private static final Hashtable htmlTextStyles = new Hashtable();
    static /* synthetic */ Class class$net$yura$mobile$gui$components$Button;
    static /* synthetic */ Class class$net$yura$mobile$gui$components$TextField;
    static /* synthetic */ Class class$net$yura$mobile$gui$components$CheckBox;
    static /* synthetic */ Class class$net$yura$mobile$gui$components$RadioButton;

    public static Component load(String text, ActionListener listener) {
        byte[] bytes;
        try {
            bytes = text.getBytes("UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
        XHTMLLoader xhtmlLoader = new XHTMLLoader();
        xhtmlLoader.gotResult(new ByteArrayInputStream(bytes), listener);
        return xhtmlLoader.getRoot();
    }

    public void gotResult(InputStream resultsStream, ActionListener actionL) {
        try {
            this.al = actionL;
            this.root = new Panel(new FlowLayout(2, 0));
            this.currentComponent = this.root;
            KXmlParser parser = new KXmlParser();
            parser.setInput(resultsStream, null);
            this.startInlineSection();
            this.read(parser);
            this.endInlineSection();
        }
        catch (Exception ex) {
            Logger.warn("cant load " + resultsStream + " " + actionL, ex);
        }
    }

    public void gotResult(TextPane pane, String string) {
        this.currentComponent = pane;
        try {
            KXmlParser parser = new KXmlParser();
            parser.setInput(new ByteArrayInputStream(string.getBytes("UTF-8")), null);
            this.read(parser);
        }
        catch (Exception ex) {
            Logger.warn("cant set " + pane + " " + string, ex);
        }
    }

    private TextPane.TextStyle getStyleForTag(String name) {
        Style skinStyle = DesktopPane.getDesktopPane().getLookAndFeel().getStyle(name);
        if (skinStyle != null) {
            TextPane.TextStyle textStyle = new TextPane.TextStyle();
            textStyle.setName(name);
            textStyle.putAll(skinStyle);
            return textStyle;
        }
        return (TextPane.TextStyle)htmlTextStyles.get(name);
    }

    protected void read(KXmlParser parser) throws Exception {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                String name = parser.getName().toLowerCase();
                TagHandler tag = new TagHandler(name);
                tag.setParant(this.currentTag);
                tag.style = this.getStyleForTag(name);
                this.currentTag = tag;
                this.currentTag.processStartElement(parser);
                if (this.currentComponent instanceof TextPane) {
                    TextPane inlineText = (TextPane)this.currentComponent;
                    this.currentTag.styleStart = inlineText.getText().length();
                }
                if (!this.isBlock(name)) continue;
                this.newBlock = true;
                continue;
            }
            if (eventType == 3) {
                if (this.currentComponent instanceof TextPane && this.currentTag.style != null) {
                    TextPane inlineText = (TextPane)this.currentComponent;
                    int styleEnd = inlineText.getText().length();
                    if (this.currentTag.style.getAlignment() == -1) {
                        inlineText.setCharacterAttributes(this.currentTag.styleStart, styleEnd - this.currentTag.styleStart, this.currentTag.style);
                    } else {
                        inlineText.setParagraphAttributes(this.currentTag.styleStart, styleEnd - this.currentTag.styleStart, this.currentTag.style);
                    }
                }
                if (this.isBlock(this.currentTag.name)) {
                    this.newBlock = true;
                }
                this.currentTag.processEndElement(parser);
                this.currentTag = this.currentTag.getParent();
                continue;
            }
            if (eventType == 4) {
                this.currentTag.processText(parser);
                continue;
            }
            if (eventType == 6) {
                this.currentTag.processRef(parser);
                continue;
            }
            if (eventType == 0) {
                Logger.debug("Start document");
                continue;
            }
            if (eventType == 1) {
                Logger.debug("End document");
                continue;
            }
            Logger.debug("unknown event: " + eventType);
        } while ((eventType = parser.nextToken()) != 1);
    }

    public Component getRoot() {
        return this.root;
    }

    public boolean isBlock(String tag) {
        return "center".equals(tag) || "p".equals(tag) || "h1".equals(tag) || "h2".equals(tag) || "h3".equals(tag);
    }

    public static void addHtmlTextStyle(TextPane.TextStyle style) {
        htmlTextStyles.put(style.getName(), style);
    }

    private void startInlineSection() {
        TextPane it = new TextPane();
        it.setActionListener(this.al);
        ((Panel)this.currentComponent).add(it);
        this.currentComponent = it;
        this.newBlock = false;
    }

    private void endInlineSection() {
        TextPane text = (TextPane)this.currentComponent;
        this.currentComponent = text.getParent();
        if ("".equals(text.getText().trim())) {
            ((Panel)this.currentComponent).remove(text);
        }
    }

    private void insertComponent(Component c) {
        this.endInlineSection();
        ((Panel)this.currentComponent).add(c);
        this.currentComponent = c;
    }

    private void endComponent() {
        this.currentComponent = this.currentComponent.getParent();
        this.startInlineSection();
    }

    private void insertPanel(Panel p, GridBagConstraints con) {
        con.weightx = 1;
        ((Panel)this.currentComponent).add((Component)p, con);
        this.currentComponent = p;
        this.startInlineSection();
    }

    private void endPanel() {
        this.endInlineSection();
        this.currentComponent = ((Panel)this.currentComponent).getParent();
    }

    static {
        TextPane.TextStyle bold = new TextPane.TextStyle();
        TextPane.TextStyle italic = new TextPane.TextStyle();
        TextPane.TextStyle underline = new TextPane.TextStyle();
        TextPane.TextStyle center = new TextPane.TextStyle();
        TextPane.TextStyle link = new TextPane.TextStyle();
        TextPane.TextStyle font = new TextPane.TextStyle();
        bold.setBold(true);
        bold.setName("b");
        italic.setItalic(true);
        italic.setName("i");
        underline.setUnderline(true);
        underline.setName("u");
        center.setAlignment(1);
        center.setName("center");
        link.setUnderline(true);
        link.setForeground(-16776961);
        link.addForeground(-65536, 4);
        link.setName("a");
        font.setName("font");
        XHTMLLoader.addHtmlTextStyle(bold);
        XHTMLLoader.addHtmlTextStyle(italic);
        XHTMLLoader.addHtmlTextStyle(underline);
        XHTMLLoader.addHtmlTextStyle(center);
        XHTMLLoader.addHtmlTextStyle(link);
        XHTMLLoader.addHtmlTextStyle(font);
    }

    class TagHandler {
        TagHandler parent;
        int row = -1;
        Vector rows;
        TextPane.TextStyle style;
        int styleStart;
        String name;

        TagHandler(String name) {
            this.name = name;
        }

        public void processStartElement(KXmlParser parser) throws Exception {
            TextPane.TextStyle linkStyle;
            String value;
            int count = parser.getAttributeCount();
            Logger.debug("START: " + this.name);
            if ("a".equals(this.name) && (value = parser.getAttributeValue(null, "href")) != null) {
                linkStyle = new TextPane.TextStyle();
                linkStyle.putAll(this.style);
                linkStyle.setAction(value);
                this.style = linkStyle;
            }
            if ("font".equals(this.name)) {
                String color = parser.getAttributeValue(null, "color");
                if (color != null) {
                    linkStyle = new TextPane.TextStyle();
                    linkStyle.putAll(this.style);
                    linkStyle.setForeground(Graphics2D.parseColor(color, 16));
                    this.style = linkStyle;
                }
            } else if ("br".equals(this.name)) {
                if (XHTMLLoader.this.currentComponent instanceof TextPane) {
                    TextPane inlineText = (TextPane)XHTMLLoader.this.currentComponent;
                    inlineText.append("\n");
                } else {
                    Logger.info("strange place for br tag, br can not go here");
                }
            } else if ("select".equals(this.name)) {
                int size = 1;
                for (int c = 0; c < count; ++c) {
                    String key = parser.getAttributeName(c).toLowerCase();
                    String value2 = parser.getAttributeValue(c);
                    if (!"size".equals(key)) continue;
                    size = Integer.parseInt(value2);
                }
                Component c = size == 1 ? new ComboBox() : new List();
                XHTMLLoader.this.insertComponent(c);
            } else if ("option".equals(this.name)) {
                boolean selected = false;
                for (int c = 0; c < count; ++c) {
                    String key = parser.getAttributeName(c).toLowerCase();
                    if (!"selected".equals(key)) continue;
                    selected = true;
                }
                if (XHTMLLoader.this.currentComponent instanceof ComboBox) {
                    ComboBox inlineText = (ComboBox)XHTMLLoader.this.currentComponent;
                    inlineText.getItems().addElement(new Option());
                    if (selected || inlineText.getItemCount() == 1) {
                        inlineText.setSelectedIndex(inlineText.getItemCount() - 1);
                    }
                } else if (XHTMLLoader.this.currentComponent instanceof List) {
                    List inlineText = (List)XHTMLLoader.this.currentComponent;
                    inlineText.addElement(new Option());
                    if (selected) {
                        Vector selectedValues = inlineText.getSelectedValues();
                        selectedValues.addElement(inlineText.getElementAt(inlineText.getSize() - 1));
                        inlineText.setSelectedValues(selectedValues);
                    }
                } else {
                    Logger.info("strange place for option, should be inside select");
                }
            } else if ("input".equals(this.name)) {
                Class theClass = null;
                String text = null;
                int constraints = 0;
                for (int c = 0; c < count; ++c) {
                    String key = parser.getAttributeName(c).toLowerCase();
                    String value3 = parser.getAttributeValue(c);
                    if ("type".equals(key)) {
                        if ("button".equals(value3 = value3.toLowerCase())) {
                            theClass = class$net$yura$mobile$gui$components$Button == null ? XHTMLLoader.class$("net.yura.mobile.gui.components.Button") : class$net$yura$mobile$gui$components$Button;
                            continue;
                        }
                        if ("text".equals(value3)) {
                            theClass = class$net$yura$mobile$gui$components$TextField == null ? XHTMLLoader.class$("net.yura.mobile.gui.components.TextField") : class$net$yura$mobile$gui$components$TextField;
                            continue;
                        }
                        if ("checkbox".equals(value3)) {
                            theClass = class$net$yura$mobile$gui$components$CheckBox == null ? XHTMLLoader.class$("net.yura.mobile.gui.components.CheckBox") : class$net$yura$mobile$gui$components$CheckBox;
                            continue;
                        }
                        if ("radio".equals(value3)) {
                            theClass = class$net$yura$mobile$gui$components$RadioButton == null ? XHTMLLoader.class$("net.yura.mobile.gui.components.RadioButton") : class$net$yura$mobile$gui$components$RadioButton;
                            continue;
                        }
                        if ("password".equals(value3)) {
                            theClass = class$net$yura$mobile$gui$components$TextField == null ? XHTMLLoader.class$("net.yura.mobile.gui.components.TextField") : class$net$yura$mobile$gui$components$TextField;
                            constraints = 65536;
                            continue;
                        }
                        theClass = class$net$yura$mobile$gui$components$TextField == null ? XHTMLLoader.class$("net.yura.mobile.gui.components.TextField") : class$net$yura$mobile$gui$components$TextField;
                        continue;
                    }
                    if ("name".equals(key) || !"value".equals(key)) continue;
                    text = value3;
                }
                if (theClass != null) {
                    Component comp = (Component)theClass.newInstance();
                    if (text != null) {
                        if (comp instanceof Label) {
                            ((Label)comp).setText(text);
                        } else if (comp instanceof TextComponent) {
                            ((TextComponent)comp).setText(text);
                            ((TextComponent)comp).setConstraints(constraints);
                        }
                    }
                    XHTMLLoader.this.insertComponent(comp);
                }
            } else if ("button".equals(this.name)) {
                XHTMLLoader.this.insertComponent(new Button());
            } else if ("textarea".equals(this.name)) {
                XHTMLLoader.this.insertComponent(new TextArea());
            } else if ("ul".equals(this.name) || "ol".equals(this.name)) {
                Panel p = new Panel(new GridBagLayout(2, 0, 0, 0, 0, 0));
                XHTMLLoader.this.insertComponent(p);
            } else if ("li".equals(this.name)) {
                Label l = new Label("ol".equals(this.parent.name) ? ((Panel)XHTMLLoader.this.currentComponent).getComponentCount() / 2 + 1 + "." : "*");
                l.setVerticalAlignment(16);
                ((Panel)XHTMLLoader.this.currentComponent).add((Component)l, new GridBagConstraints());
                XHTMLLoader.this.insertPanel(new Panel(new FlowLayout(2, 0)), new GridBagConstraints());
            } else if ("tr".equals(this.name)) {
                if (this.parent != null && this.parent.rows != null) {
                    ++this.parent.row;
                } else {
                    Logger.info("strange place for tr tag, tr can not go here");
                }
            } else if ("table".equals(this.name)) {
                this.rows = new Vector();
                XHTMLLoader.this.insertComponent(new Panel(new GridBagLayout(0, 2, 2, 2, 2, 2)));
            } else if ("th".equals(this.name) || "td".equals(this.name)) {
                int rowspani;
                String colspan = parser.getAttributeValue(null, "colspan");
                String rowspan = parser.getAttributeValue(null, "rowspan");
                int colspani = colspan == null ? 1 : Integer.parseInt(colspan);
                int n = rowspani = rowspan == null ? 1 : Integer.parseInt(rowspan);
                if (this.parent != null && this.parent.parent != null && this.parent.parent.rows != null) {
                    for (int a = 0; a < rowspani; ++a) {
                        this.parent.parent.addToRow(a, colspani);
                    }
                } else {
                    Logger.info("strange place for th/td tag, th/td can not go here");
                }
                Panel p = new Panel(new FlowLayout(2, 0));
                GridBagConstraints c = new GridBagConstraints();
                c.colSpan = colspani;
                c.rowSpan = rowspani;
                XHTMLLoader.this.insertPanel(p, c);
            } else if (!("b".equals(this.name) || "i".equals(this.name) || "u".equals(this.name) || "center".equals(this.name) || "body".equals(this.name) || "p".equals(this.name) || "title".equals(this.name) || "html".equals(this.name) || "head".equals(this.name))) {
                Logger.info("unknwon start: " + this.name);
            }
        }

        private void addTextToLastOption(Vector items, String text) {
            Option option;
            if (items.size() == 0) {
                return;
            }
            String current = (option = (Option)items.lastElement()).getValue();
            option.setValue(current == null ? text : current + text);
        }

        public void processEndElement(KXmlParser parser) {
            if ("select".equals(this.name)) {
                XHTMLLoader.this.endComponent();
            } else if ("input".equals(this.name)) {
                XHTMLLoader.this.endComponent();
            } else if ("button".equals(this.name)) {
                XHTMLLoader.this.endComponent();
            } else if ("textarea".equals(this.name)) {
                XHTMLLoader.this.endComponent();
            } else if (!"tr".equals(this.name)) {
                if ("th".equals(this.name) || "td".equals(this.name)) {
                    XHTMLLoader.this.endPanel();
                } else if ("table".equals(this.name)) {
                    int biggest = 0;
                    for (int a = 0; a < this.rows.size(); ++a) {
                        Integer row = (Integer)this.rows.elementAt(a);
                        if (row <= biggest) continue;
                        biggest = row;
                    }
                    GridBagLayout layout = (GridBagLayout)((Panel)XHTMLLoader.this.currentComponent).getLayout();
                    layout.columns = biggest;
                    Logger.debug("bigget " + this.rows + " " + biggest);
                    XHTMLLoader.this.endComponent();
                } else if ("li".equals(this.name)) {
                    XHTMLLoader.this.endPanel();
                } else if ("ul".equals(this.name) || "ol".equals(this.name)) {
                    XHTMLLoader.this.endComponent();
                } else if (!("b".equals(this.name) || "i".equals(this.name) || "u".equals(this.name) || "center".equals(this.name) || "a".equals(this.name) || "body".equals(this.name) || "p".equals(this.name) || "html".equals(this.name) || "head".equals(this.name) || "title".equals(this.name) || "option".equals(this.name) || "br".equals(this.name))) {
                    Logger.info("unknown end: " + this.name);
                }
            }
        }

        private void processText(KXmlParser parser) {
            String string = parser.getText();
            string = StringUtil.replaceAll(string, "\n", " ");
            string = StringUtil.replaceAll(string, "\t", " ");
            while (string.indexOf("  ") >= 0) {
                string = StringUtil.replaceAll(string, "  ", " ");
            }
            Logger.debug("    text: \"" + string + "\"");
            if (XHTMLLoader.this.currentComponent instanceof TextPane) {
                if (string.length() > 0) {
                    TextPane inlineText = (TextPane)XHTMLLoader.this.currentComponent;
                    if (XHTMLLoader.this.newBlock && inlineText.getText().length() != 0) {
                        inlineText.append("\n");
                    }
                    XHTMLLoader.this.newBlock = false;
                    if ((inlineText.getText().length() == 0 || inlineText.getText().endsWith(" ") || inlineText.getText().endsWith("\n")) && string.length() != 0 && string.charAt(0) == ' ') {
                        string = string.substring(1);
                    }
                    inlineText.append(string);
                }
            } else if (XHTMLLoader.this.currentComponent instanceof ComboBox) {
                ComboBox inlineText = (ComboBox)XHTMLLoader.this.currentComponent;
                this.addTextToLastOption(inlineText.getItems(), string);
            } else if (XHTMLLoader.this.currentComponent instanceof List) {
                List inlineText = (List)XHTMLLoader.this.currentComponent;
                this.addTextToLastOption(inlineText.getItems(), string);
            } else if (XHTMLLoader.this.currentComponent instanceof Button) {
                Button inlineText = (Button)XHTMLLoader.this.currentComponent;
                inlineText.setText(inlineText.getText() + string);
            } else if (XHTMLLoader.this.currentComponent instanceof TextArea) {
                TextArea inlineText = (TextArea)XHTMLLoader.this.currentComponent;
                inlineText.append(string);
            } else {
                Logger.info("strange place for text");
            }
        }

        private void processRef(KXmlParser parser) {
            Logger.debug("ref: " + parser.getName());
            if (XHTMLLoader.this.currentComponent instanceof TextPane) {
                TextPane inlineText = (TextPane)XHTMLLoader.this.currentComponent;
                inlineText.append(parser.getName());
            } else {
                Logger.info("strange place for ref");
            }
        }

        void addToRow(int a, int num) {
            int currentRow = this.row + a;
            while (this.rows.size() <= currentRow) {
                this.rows.addElement(new Integer(0));
            }
            int cols = (Integer)this.rows.elementAt(currentRow) + num;
            this.rows.setElementAt(new Integer(cols), currentRow);
        }

        private TagHandler getParent() {
            return this.parent;
        }

        private void setParant(TagHandler currentTag) {
            this.parent = currentTag;
        }
    }
}

