/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.FileInfo;
import net.rubygrapefruit.platform.file.Files;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;

public class NativePlatformBackedFileMetadataAccessor
implements FileMetadataAccessor {
    private final Files files;

    public NativePlatformBackedFileMetadataAccessor(Files files) {
        this.files = files;
    }

    @Override
    public FileMetadata stat(File f) {
        FileInfo stat;
        try {
            stat = this.files.stat(f, false);
        }
        catch (NativeException e) {
            throw new UncheckedIOException("Could not stat file " + f.getAbsolutePath(), (Throwable)e);
        }
        FileMetadata.AccessType accessType = FileMetadata.AccessType.viaSymlink((stat.getType() == FileInfo.Type.Symlink ? 1 : 0) != 0);
        if (accessType == FileMetadata.AccessType.VIA_SYMLINK) {
            try {
                stat = this.files.stat(f, true);
            }
            catch (NativeException e) {
                if (!f.exists()) {
                    return DefaultFileMetadata.missing((FileMetadata.AccessType)accessType);
                }
                throw new UncheckedIOException("Could not stat file " + f.getAbsolutePath(), (Throwable)e);
            }
        }
        switch (stat.getType()) {
            case File: {
                return DefaultFileMetadata.file((long)stat.getLastModifiedTime(), (long)stat.getSize(), (FileMetadata.AccessType)accessType);
            }
            case Directory: {
                return DefaultFileMetadata.directory((FileMetadata.AccessType)accessType);
            }
            case Missing: {
                return DefaultFileMetadata.missing((FileMetadata.AccessType)accessType);
            }
            case Other: {
                throw new UncheckedIOException("Unsupported file type for " + f.getAbsolutePath());
            }
        }
        throw new IllegalArgumentException("Unrecognised file type: " + stat.getType());
    }
}

