/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;

public class BuildDependenciesOnlyVisitedArtifactSet
implements VisitedArtifactSet {
    private final VisitedGraphResults graphResults;
    private final VisitedArtifactsResults artifactsResults;
    ArtifactVariantSelector artifactVariantSelector;

    public BuildDependenciesOnlyVisitedArtifactSet(VisitedGraphResults graphResults, VisitedArtifactsResults artifactsResults, ArtifactVariantSelector artifactVariantSelector) {
        this.graphResults = graphResults;
        this.artifactsResults = artifactsResults;
        this.artifactVariantSelector = artifactVariantSelector;
    }

    @Override
    public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec, ArtifactSelectionSpec spec) {
        ResolvedArtifactSet selectedArtifacts = this.artifactsResults.select(this.artifactVariantSelector, spec).getArtifacts();
        return new BuildDependenciesOnlySelectedArtifactSet(this.graphResults, selectedArtifacts);
    }

    private static class BuildDependenciesOnlySelectedArtifactSet
    implements SelectedArtifactSet {
        private final VisitedGraphResults graphResults;
        private final ResolvedArtifactSet selectedArtifacts;

        BuildDependenciesOnlySelectedArtifactSet(VisitedGraphResults graphResults, ResolvedArtifactSet selectedArtifacts) {
            this.graphResults = graphResults;
            this.selectedArtifacts = selectedArtifacts;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            this.graphResults.visitFailures(arg_0 -> ((TaskDependencyResolveContext)context).visitFailure(arg_0));
            context.add((Object)this.selectedArtifacts);
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
            throw new UnsupportedOperationException("Artifacts have not been resolved.");
        }
    }
}

