/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyVerifyingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DefaultKeyServers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.ChecksumEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.PgpEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.PgpKeyGrouper;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.VerificationEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.WriterSignatureVerificationResult;
import org.gradle.api.internal.artifacts.verification.exceptions.DependencyVerificationException;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlReader;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlWriter;
import org.gradle.api.internal.artifacts.verification.signatures.BuildTreeDefinedKeys;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifierBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PGPUtils;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;

public class WriteDependencyVerificationFile
implements DependencyVerificationOverride,
ArtifactVerificationOperation {
    private static final Logger LOGGER = Logging.getLogger(WriteDependencyVerificationFile.class);
    private static final Action<ArtifactView.ViewConfiguration> MODULE_COMPONENT_FILES = conf -> {
        conf.componentFilter(id -> id instanceof ModuleComponentIdentifier);
        conf.setLenient(true);
    };
    private static final String PGP = "pgp";
    private static final String MD5 = "md5";
    private static final String SHA1 = "sha1";
    private static final String SHA256 = "sha256";
    private static final String SHA512 = "sha512";
    private static final Set<String> SUPPORTED_CHECKSUMS = ImmutableSet.of((Object)"md5", (Object)"sha1", (Object)"sha256", (Object)"sha512", (Object)"pgp");
    private static final Set<String> SECURE_CHECKSUMS = ImmutableSet.of((Object)"sha256", (Object)"sha512", (Object)"pgp");
    private static final String PGP_VERIFICATION_FAILED = "PGP verification failed";
    private static final String KEY_NOT_DOWNLOADED = "Key couldn't be downloaded from any key server";
    private final DependencyVerifierBuilder verificationsBuilder = new DependencyVerifierBuilder();
    private final BuildOperationExecutor buildOperationExecutor;
    private final List<String> checksums;
    private final Set<VerificationEntry> entriesToBeWritten = Sets.newLinkedHashSetWithExpectedSize((int)512);
    private final ChecksumService checksumService;
    private final File verificationFile;
    private final SignatureVerificationServiceFactory signatureVerificationServiceFactory;
    private final boolean isDryRun;
    private final boolean generatePgpInfo;
    private final boolean isExportKeyring;
    private boolean hasMissingSignatures = false;
    private boolean hasMissingKeys = false;
    private boolean hasFailedVerification = false;

    public WriteDependencyVerificationFile(File verificationFile, BuildOperationExecutor buildOperationExecutor, List<String> checksums, ChecksumService checksumService, SignatureVerificationServiceFactory signatureVerificationServiceFactory, boolean isDryRun, boolean exportKeyRing) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.checksums = checksums;
        this.checksumService = checksumService;
        this.verificationFile = verificationFile;
        this.signatureVerificationServiceFactory = signatureVerificationServiceFactory;
        this.isDryRun = isDryRun;
        this.generatePgpInfo = checksums.contains(PGP);
        this.isExportKeyring = exportKeyRing;
    }

    private boolean isWriteVerificationFile() {
        return !this.checksums.isEmpty();
    }

    private void validateChecksums() {
        if (this.isWriteVerificationFile()) {
            this.assertSupportedChecksums();
            this.warnAboutInsecureChecksums();
        }
    }

    private void assertSupportedChecksums() {
        for (String checksum : this.checksums) {
            if (SUPPORTED_CHECKSUMS.contains(checksum)) continue;
            LOGGER.warn("Invalid checksum type: '" + checksum + "'. You must choose one or more in " + SUPPORTED_CHECKSUMS);
        }
        this.assertPgpHasChecksumFallback(this.checksums);
    }

    private void assertPgpHasChecksumFallback(List<String> kinds) {
        if (kinds.size() == 1 && PGP.equals(kinds.get(0))) {
            throw new DependencyVerificationException("Generating a file with signature verification requires at least one checksum type (sha256 or sha512) as fallback.");
        }
    }

    private void warnAboutInsecureChecksums() {
        if (this.checksums.stream().noneMatch(SECURE_CHECKSUMS::contains)) {
            LOGGER.warn("You chose to generate " + String.join((CharSequence)" and ", this.checksums) + " checksums but they are all considered insecure. You should consider adding at least one of " + String.join((CharSequence)" or ", SECURE_CHECKSUMS) + ".");
        }
    }

    @Override
    public ModuleComponentRepository<ModuleComponentGraphResolveState> overrideDependencyVerification(ModuleComponentRepository<ModuleComponentGraphResolveState> original, String resolveContextName, ResolutionStrategyInternal resolutionStrategy) {
        return new DependencyVerifyingModuleComponentRepository(original, this, this.generatePgpInfo);
    }

    @Override
    public void buildFinished(GradleInternal gradle) {
        this.ensureOutputDirCreated();
        this.maybeReadExistingFile();
        boolean offline = gradle.getStartParameter().isOffline();
        BuildTreeDefinedKeys existingKeyring = new BuildTreeDefinedKeys(this.verificationFile.getParentFile(), this.verificationsBuilder.getKeyringFormat());
        SignatureVerificationService signatureVerificationService = this.signatureVerificationServiceFactory.create(existingKeyring, DefaultKeyServers.getOrDefaults(this.verificationsBuilder.getKeyServers()), !offline);
        if (!this.verificationsBuilder.isUseKeyServers() && !offline) {
            LOGGER.lifecycle("Will use key servers to download missing keys. If you really want to ignore key servers when generating the verification file, you can use the --offline flag in addition");
        }
        try {
            this.validateChecksums();
            this.resolveAllConfigurationsConcurrently((Gradle)gradle);
            this.computeChecksumsConcurrently(signatureVerificationService);
            this.writeEntriesSerially();
            this.serializeResult(signatureVerificationService, existingKeyring);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            signatureVerificationService.stop();
        }
    }

    public boolean ensureOutputDirCreated() {
        return this.verificationFile.getParentFile().mkdirs();
    }

    private void serializeResult(SignatureVerificationService signatureVerificationService, BuildTreeDefinedKeys existingKeyring) throws IOException {
        File out = this.mayBeDryRunFile(this.verificationFile);
        if (this.generatePgpInfo) {
            this.verificationsBuilder.setVerifySignatures(true);
        }
        DependencyVerifier verifier = this.verificationsBuilder.build();
        if (this.isWriteVerificationFile()) {
            DependencyVerificationsXmlWriter.serialize(verifier, new FileOutputStream(out));
        }
        if (this.isExportKeyring) {
            this.exportKeys(signatureVerificationService, verifier, existingKeyring);
        }
    }

    private File mayBeDryRunFile(File originalFile) {
        if (!this.isDryRun) {
            return originalFile;
        }
        return new File(originalFile.getParent(), Files.getNameWithoutExtension((String)originalFile.getName()) + ".dryrun." + Files.getFileExtension((String)originalFile.getName()));
    }

    private void exportKeys(SignatureVerificationService signatureVerificationService, DependencyVerifier verifier, BuildTreeDefinedKeys existingKeyring) throws IOException {
        HashSet keysToExport = Sets.newHashSet();
        verifier.getConfiguration().getTrustedKeys().stream().map(DependencyVerificationConfiguration.TrustedKey::getKeyId).forEach(keysToExport::add);
        verifier.getConfiguration().getIgnoredKeys().stream().map(IgnoredKey::getKeyId).forEach(keysToExport::add);
        verifier.getVerificationMetadata().stream().flatMap(md -> md.getArtifactVerifications().stream()).flatMap(avm -> Stream.concat(avm.getTrustedPgpKeys().stream(), avm.getIgnoredPgpKeys().stream().map(IgnoredKey::getKeyId))).forEach(keysToExport::add);
        this.exportKeyRingCollection(signatureVerificationService.getPublicKeyService(), existingKeyring, keysToExport, verifier.getConfiguration().getKeyringFormat());
    }

    private void maybeReadExistingFile() {
        if (this.verificationFile.exists()) {
            LOGGER.info("Found dependency verification metadata file, updating");
            try {
                DependencyVerificationsXmlReader.readFromXml(new FileInputStream(this.verificationFile), this.verificationsBuilder);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    private void writeEntriesSerially() {
        AtomicReference previousEntry = new AtomicReference();
        this.entriesToBeWritten.stream().sorted().filter(this::shouldWriteEntry).forEachOrdered(e -> this.registerEntryToBuilder((VerificationEntry)e, previousEntry));
        this.printWarnings();
    }

    private void printWarnings() {
        if (this.hasMissingKeys || this.hasFailedVerification) {
            StringBuilder sb = new StringBuilder("A verification file was generated but some problems were discovered:\n");
            if (this.hasMissingSignatures) {
                sb.append("   - some artifacts aren't signed or the signature couldn't be retrieved.");
                sb.append("\n");
            }
            if (this.hasMissingKeys) {
                sb.append("   - some keys couldn't be downloaded. They were automatically added as ignored keys but you should review if this is acceptable. Look for entries with the following comment: ");
                sb.append(KEY_NOT_DOWNLOADED);
                sb.append("\n");
            }
            if (this.hasFailedVerification) {
                sb.append("   - some signature verification failed. Checksums were generated for those artifacts but you MUST check if there's an actual problem. Look for entries with the following comment: ");
                sb.append(PGP_VERIFICATION_FAILED);
                sb.append("\n");
            }
            LOGGER.warn(sb.toString());
        }
    }

    private void registerEntryToBuilder(VerificationEntry entry, AtomicReference<PgpEntry> previousEntry) {
        PgpEntry pgpEntry = previousEntry.get();
        if (pgpEntry != null && !pgpEntry.id.equals(entry.id)) {
            pgpEntry = null;
            previousEntry.set(null);
        }
        if (entry instanceof ChecksumEntry) {
            ChecksumEntry checksum = (ChecksumEntry)entry;
            if (pgpEntry == null || entry.id.equals(pgpEntry.id) && pgpEntry.isRequiringChecksums()) {
                String origin = "Generated by Gradle";
                String reason = null;
                if (pgpEntry != null) {
                    if (pgpEntry.isFailed()) {
                        this.hasFailedVerification = true;
                        reason = "PGP signature verification failed!";
                    } else if (pgpEntry.hasSignatureFile()) {
                        this.hasMissingKeys = true;
                        reason = "A key couldn't be downloaded";
                    } else {
                        this.hasMissingSignatures = true;
                        reason = "Artifact is not signed";
                    }
                }
                this.verificationsBuilder.addChecksum(entry.id, checksum.getChecksumKind(), checksum.getChecksum(), origin, reason);
            }
        } else {
            PgpEntry pgp = (PgpEntry)entry;
            previousEntry.set(pgp);
            TreeSet failedKeys = Sets.newTreeSet(pgp.getFailed());
            for (String failedKey : failedKeys) {
                this.verificationsBuilder.addIgnoredKey(pgp.id, new IgnoredKey(failedKey, PGP_VERIFICATION_FAILED));
            }
            if (pgp.hasArtifactLevelKeys()) {
                for (String key : pgp.getArtifactLevelKeys()) {
                    if (failedKeys.contains(key)) continue;
                    this.verificationsBuilder.addTrustedKey(pgp.id, key);
                }
            }
        }
    }

    private boolean shouldWriteEntry(VerificationEntry entry) {
        if (entry instanceof ChecksumEntry) {
            return ((ChecksumEntry)entry).getChecksum() != null && !this.isTrustedArtifact(entry.id);
        }
        return !this.isTrustedArtifact(entry.id);
    }

    private void resolveAllConfigurationsConcurrently(Gradle gradle) {
        this.buildOperationExecutor.runAllWithAccessToProjectState(queue -> {
            Set allprojects = gradle.getRootProject().getAllprojects();
            for (final Project project : allprojects) {
                queue.add((BuildOperation)new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        WriteDependencyVerificationFile.resolveAllConfigurationsAndForceDownload(project);
                    }

                    public BuildOperationDescriptor.Builder description() {
                        String displayName = "Resolving configurations of " + project.getDisplayName();
                        return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName);
                    }
                });
            }
        });
    }

    private void computeChecksumsConcurrently(SignatureVerificationService signatureVerificationService) {
        Set collectedIgnoredKeys = this.generatePgpInfo ? Sets.newConcurrentHashSet() : null;
        this.buildOperationExecutor.runAll(queue -> {
            for (VerificationEntry entry : this.entriesToBeWritten) {
                if (this.shouldSkipVerification(entry.getArtifactKind())) continue;
                if (!entry.getFile().exists()) {
                    LOGGER.warn("Cannot compute checksum for " + entry.getFile() + " because it doesn't exist. It may indicate a corrupt or tampered cache.");
                    continue;
                }
                if (entry instanceof ChecksumEntry) {
                    this.queueChecksumVerification((BuildOperationQueue<RunnableBuildOperation>)queue, (ChecksumEntry)entry);
                    continue;
                }
                this.queueSignatureVerification((BuildOperationQueue<RunnableBuildOperation>)queue, signatureVerificationService, (PgpEntry)entry, collectedIgnoredKeys);
            }
        });
        if (this.generatePgpInfo) {
            this.postProcessPgpResults(collectedIgnoredKeys);
        }
    }

    private void postProcessPgpResults(Set<String> collectedIgnoredKeys) {
        for (String ignoredKey : collectedIgnoredKeys) {
            this.verificationsBuilder.addIgnoredKey(new IgnoredKey(ignoredKey, KEY_NOT_DOWNLOADED));
        }
        PgpKeyGrouper grouper = new PgpKeyGrouper(this.verificationsBuilder, this.entriesToBeWritten);
        grouper.performPgpKeyGrouping();
    }

    private void queueSignatureVerification(BuildOperationQueue<RunnableBuildOperation> queue, final SignatureVerificationService signatureVerificationService, final PgpEntry entry, final Set<String> ignoredKeys) {
        queue.add((BuildOperation)new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                File signature = (File)entry.getSignatureFile().create();
                if (signature != null) {
                    WriterSignatureVerificationResult builder = new WriterSignatureVerificationResult(ignoredKeys, entry);
                    signatureVerificationService.verify(entry.file, signature, Collections.emptySet(), Collections.emptySet(), builder);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Verifying dependency signature").progressDisplayName("Verifying signature of " + entry.id);
            }
        });
    }

    private void queueChecksumVerification(BuildOperationQueue<RunnableBuildOperation> queue, final ChecksumEntry entry) {
        queue.add((BuildOperation)new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                entry.setChecksum(WriteDependencyVerificationFile.this.createHash(entry.getFile(), entry.getChecksumKind()));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Computing checksums").progressDisplayName("Computing checksum of " + entry.id);
            }
        });
    }

    @Override
    public void onArtifact(ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier id, File mainFile, Factory<File> signatureFile, String repositoryName, String repositoryId) {
        for (String checksum : this.checksums) {
            if (PGP.equals(checksum)) {
                this.addPgp(id, kind, mainFile, signatureFile);
                continue;
            }
            this.addChecksum(id, kind, mainFile, ChecksumKind.valueOf(checksum));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPgp(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind kind, File mainFile, Factory<File> signatureFile) {
        PgpEntry entry = new PgpEntry(id, kind, mainFile, signatureFile);
        Set<VerificationEntry> set = this.entriesToBeWritten;
        synchronized (set) {
            this.entriesToBeWritten.add(entry);
        }
    }

    private boolean shouldSkipVerification(ArtifactVerificationOperation.ArtifactKind kind) {
        return kind == ArtifactVerificationOperation.ArtifactKind.METADATA && !this.verificationsBuilder.isVerifyMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChecksum(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind artifactKind, File file, ChecksumKind kind) {
        ChecksumEntry e = new ChecksumEntry(id, artifactKind, file, kind);
        Set<VerificationEntry> set = this.entriesToBeWritten;
        synchronized (set) {
            this.entriesToBeWritten.add(e);
        }
    }

    private boolean isTrustedArtifact(ModuleComponentArtifactIdentifier id) {
        return this.verificationsBuilder.getTrustedArtifacts().stream().anyMatch(artifact -> artifact.matches(id));
    }

    private String createHash(File file, ChecksumKind kind) {
        try {
            return this.checksumService.hash(file, kind.getAlgorithm()).toString();
        }
        catch (Exception e) {
            LOGGER.debug("Error while snapshotting " + file, (Throwable)e);
            return null;
        }
    }

    private static void resolveAllConfigurationsAndForceDownload(Project project) {
        ((ProjectInternal)project).getOwner().applyToMutableState(p -> p.getConfigurations().all(cnf -> {
            if (((DeprecatableConfiguration)cnf).canSafelyBeResolved()) {
                try {
                    WriteDependencyVerificationFile.resolveAndDownloadExternalFiles(cnf);
                }
                catch (Exception e) {
                    LOGGER.debug("Cannot resolve configuration {}: {}", (Object)cnf.getName(), (Object)e.getMessage());
                }
            }
        }));
    }

    private static void resolveAndDownloadExternalFiles(Configuration cnf) {
        cnf.getIncoming().artifactView(MODULE_COMPONENT_FILES).getFiles().getFiles();
    }

    private void exportKeyRingCollection(PublicKeyService publicKeyService, BuildTreeDefinedKeys existingKeyring, Set<String> publicKeys, @Nullable DependencyVerificationConfiguration.KeyringFormat keyringFormat) throws IOException {
        List<PGPPublicKeyRing> existingRings = this.loadExistingKeyRing(existingKeyring);
        PGPPublicKeyRingListBuilder builder = new PGPPublicKeyRingListBuilder();
        for (String publicKey : publicKeys) {
            if (publicKey.length() <= 16) {
                publicKeyService.findByLongId(new BigInteger(publicKey, 16).longValue(), (PublicKeyResultBuilder)builder);
                continue;
            }
            publicKeyService.findByFingerprint(Fingerprint.fromString((String)publicKey).getBytes(), (PublicKeyResultBuilder)builder);
        }
        Stream<PGPPublicKeyRing> keysSeenInVerifier = builder.build().stream().filter(keyring -> PGPUtils.getSize((PGPPublicKeyRing)keyring) != 0);
        Collection<PGPPublicKeyRing> allKeyRings = WriteDependencyVerificationFile.uniqueKeyRings(Stream.concat(keysSeenInVerifier, existingRings.stream()));
        File asciiArmoredFile = this.mayBeDryRunFile(existingKeyring.getAsciiKeyringsFile());
        File keyringFile = this.mayBeDryRunFile(existingKeyring.getBinaryKeyringsFile());
        if (keyringFormat == null) {
            this.writeAsciiArmoredKeyRingFile(asciiArmoredFile, allKeyRings);
            this.writeBinaryKeyringFile(keyringFile, allKeyRings);
            LOGGER.lifecycle("Exported {} keys to {} and {}", new Object[]{allKeyRings.size(), keyringFile, asciiArmoredFile});
        } else if (keyringFormat.equals((Object)DependencyVerificationConfiguration.KeyringFormat.ARMORED)) {
            this.writeAsciiArmoredKeyRingFile(asciiArmoredFile, allKeyRings);
            LOGGER.lifecycle("Exported {} keys to {}", new Object[]{allKeyRings.size(), asciiArmoredFile});
        } else if (keyringFormat.equals((Object)DependencyVerificationConfiguration.KeyringFormat.BINARY)) {
            this.writeBinaryKeyringFile(keyringFile, allKeyRings);
            LOGGER.lifecycle("Exported {} keys to {}", new Object[]{allKeyRings.size(), keyringFile});
        } else {
            throw new IllegalArgumentException("Unknown keyring format " + (Object)((Object)keyringFormat));
        }
    }

    private static Collection<PGPPublicKeyRing> uniqueKeyRings(Stream<PGPPublicKeyRing> keyRings) {
        TreeMap seenKeyIds = new TreeMap();
        keyRings.forEach(keyRing -> {
            Long keyId = keyRing.getPublicKey().getKeyID();
            PGPPublicKeyRing current = (PGPPublicKeyRing)seenKeyIds.get(keyId);
            if (current == null || PGPUtils.getSize((PGPPublicKeyRing)current) < PGPUtils.getSize((PGPPublicKeyRing)keyRing)) {
                seenKeyIds.put(keyId, keyRing);
            }
        });
        return seenKeyIds.values();
    }

    private void writeAsciiArmoredKeyRingFile(File ascii, Collection<PGPPublicKeyRing> allKeyRings) throws IOException {
        if (ascii.exists()) {
            ascii.delete();
        }
        boolean hasKey = false;
        for (PGPPublicKeyRing keyRing : allKeyRings) {
            try (FileOutputStream out = new FileOutputStream(ascii, true);){
                if (hasKey) {
                    ((OutputStream)out).write(10);
                }
                Iterator pks = keyRing.getPublicKeys();
                while (pks.hasNext()) {
                    boolean hasUid = false;
                    PGPPublicKey pk = (PGPPublicKey)pks.next();
                    String keyType = pk.isMasterKey() ? "pub" : "sub";
                    ((OutputStream)out).write((keyType + "    " + SecuritySupport.toLongIdHexString((long)pk.getKeyID()).toUpperCase() + "\n").getBytes(StandardCharsets.US_ASCII));
                    List userIDs = PGPUtils.getUserIDs((PGPPublicKey)pk);
                    for (String uid : userIDs) {
                        hasUid = true;
                        ((OutputStream)out).write(("uid    " + uid + "\n").getBytes(StandardCharsets.US_ASCII));
                    }
                    if (!hasUid) continue;
                    ((OutputStream)out).write(10);
                }
            }
            try (FileOutputStream fos = new FileOutputStream(ascii, true);
                 ArmoredOutputStream out = new ArmoredOutputStream((OutputStream)fos);){
                keyRing.encode((OutputStream)out, true);
            }
            hasKey = true;
        }
    }

    private void writeBinaryKeyringFile(File keyringFile, Collection<PGPPublicKeyRing> allKeyRings) throws IOException {
        try (FileOutputStream out = new FileOutputStream(keyringFile);){
            for (PGPPublicKeyRing keyRing : allKeyRings) {
                keyRing.encode((OutputStream)out, true);
            }
        }
    }

    private List<PGPPublicKeyRing> loadExistingKeyRing(BuildTreeDefinedKeys keyrings) throws IOException {
        List<PGPPublicKeyRing> existingRings;
        if (!this.isDryRun) {
            existingRings = keyrings.loadKeys();
            LOGGER.info("Existing keyring file contains {} keyrings", (Object)existingRings.size());
        } else {
            existingRings = Collections.emptyList();
        }
        return existingRings;
    }

    private static class PGPPublicKeyRingListBuilder
    implements PublicKeyResultBuilder {
        private final ImmutableList.Builder<PGPPublicKeyRing> builder = ImmutableList.builder();

        private PGPPublicKeyRingListBuilder() {
        }

        public void keyRing(PGPPublicKeyRing keyring) {
            this.builder.add((Object)keyring);
        }

        public void publicKey(PGPPublicKey publicKey) {
        }

        public List<PGPPublicKeyRing> build() {
            return this.builder.build();
        }
    }
}

