/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.logging;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jlibs.core.io.FileUtil;
import jlibs.core.lang.Ansi;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.util.CollectionUtil;
import jlibs.core.util.logging.PreciseFormatter;

public class AnsiFormatter
extends Formatter {
    private static final Map<Level, Ansi> map = new LinkedHashMap<Level, Ansi>();
    public static final Ansi SEVERE;
    public static final Ansi WARNING;
    public static final Ansi INFO;
    public static final Ansi CONFIG;
    public static final Ansi FINE;
    public static final Ansi FINER;
    public static final Ansi FINEST;
    private Formatter delegate;

    private static void load(URL url) throws IOException {
        Properties props = CollectionUtil.readProperties(url.openStream(), null);
        for (String name : props.stringPropertyNames()) {
            map.put(Level.parse(name), new Ansi(props.getProperty(name)));
        }
    }

    public AnsiFormatter(Formatter delegate) {
        this.delegate = delegate;
    }

    public AnsiFormatter() {
        this(new PreciseFormatter());
    }

    @Override
    public String format(LogRecord record) {
        return map.get(record.getLevel()).colorize(this.delegate.format(record));
    }

    static {
        try {
            AnsiFormatter.load(AnsiFormatter.class.getResource("ansiformatter.properties"));
        }
        catch (IOException ex) {
            throw new ImpossibleException(ex);
        }
        String file = System.getProperty("ansiformatter.default");
        try {
            if (file != null && new File(file).exists()) {
                AnsiFormatter.load(FileUtil.toURL(new File(file)));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        SEVERE = map.get(Level.SEVERE);
        WARNING = map.get(Level.WARNING);
        INFO = map.get(Level.INFO);
        CONFIG = map.get(Level.CONFIG);
        FINE = map.get(Level.FINE);
        FINER = map.get(Level.FINER);
        FINEST = map.get(Level.FINEST);
    }
}

