/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.List;
import java.util.ListIterator;
import org.apache.xbean.propertyeditor.AbstractCollectionConverter;

public final class ArrayConverter
extends AbstractCollectionConverter {
    public ArrayConverter(Class type, PropertyEditor editor) {
        super(type, editor);
        if (!type.isArray()) {
            throw new IllegalArgumentException("type is not an array " + type.getSimpleName());
        }
        if (type.getComponentType().isArray()) {
            throw new IllegalArgumentException("type is a multi-dimensional array " + type.getSimpleName());
        }
        if (editor == null) {
            throw new NullPointerException("editor is null");
        }
    }

    protected Object createCollection(List list2) {
        Object array = Array.newInstance(this.getType().getComponentType(), list2.size());
        ListIterator iterator = list2.listIterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            int index = iterator.previousIndex();
            Array.set(array, index, item);
        }
        return array;
    }
}

