/*
 * Decompiled with CFR 0.152.
 */
package mill.resolve;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import mill.api.Result$;
import mill.define.BaseModule;
import mill.define.Command;
import mill.define.Cross;
import mill.define.DynamicModule;
import mill.define.Module;
import mill.define.NamedTask;
import mill.define.Reflect$;
import mill.define.Segment;
import mill.define.Segments;
import mill.define.Segments$;
import mill.moduledefs.Scaladoc;
import mill.resolve.ResolveCore;
import mill.util.EitherOps$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Scaladoc(value="/**\n * Takes a single list of segments, without braces but including wildcards, and\n * resolves all possible modules, targets or commands that the segments could\n * resolve to.\n *\n * Returns only the [[Segments]] of the things it resolved, without reflecting\n * on the `java.lang.reflect.Member`s or instantiating the final tasks. Those\n * are left to downstream callers to do, with the except of instantiating\n * [[mill.define.Cross]] modules which is needed to identify their cross\n * values which is necessary for resolving tasks within them.\n *\n * Returns a [[Result]], either containing a [[Success]] containing the\n * [[Resolved]] set, [[NotFound]] if it couldn't find anything with some\n * metadata about what it was looking for, or [[Error]] if something blew up.\n */")
public final class ResolveCore$ {
    public static final ResolveCore$ MODULE$ = new ResolveCore$();

    public <T> Either<String, T> catchWrapException(Function0<T> t) {
        Either either;
        try {
            either = new Right(t.apply());
        }
        catch (InvocationTargetException e) {
            either = this.makeResultException(e.getCause(), new Exception());
        }
        catch (Exception e) {
            either = this.makeResultException(e, new Exception());
        }
        return either;
    }

    public Left<String, Nothing$> makeResultException(Throwable e, Exception base) {
        return Result$.MODULE$.makeResultException(e, base);
    }

    public String cyclicModuleErrorMsg(Segments segments) {
        return new StringBuilder(76).append("Cyclic module reference detected at ").append(segments.render()).append(", ").append("it's required to wrap it in ModuleRef.").toString();
    }

    public ResolveCore.Result resolve(BaseModule rootModule, List<Segment> remainingQuery, ResolveCore.Resolved current, Segments querySoFar, Set<Class<?>> seenModules, ResolveCore.Cache cache) {
        List<Segment> list2;
        block17: {
            Tuple2<Segment, ResolveCore.Resolved> tuple2;
            List tail;
            Segment head;
            block18: {
                Either<String, Seq<ResolveCore.Resolved>> resOrErr;
                Either<String, Seq<ResolveCore.Resolved>> either;
                block19: {
                    list2 = remainingQuery;
                    if (((Object)Nil$.MODULE$).equals(list2)) {
                        return new ResolveCore.Success(new $colon$colon<Nothing$>((Nothing$)((Object)current), Nil$.MODULE$));
                    }
                    if (!(list2 instanceof $colon$colon)) break block17;
                    $colon$colon $colon$colon = ($colon$colon)list2;
                    head = (Segment)$colon$colon.head();
                    tail = $colon$colon.next$access$1();
                    tuple2 = new Tuple2<Segment, ResolveCore.Resolved>(head, current);
                    if (tuple2 == null) break block18;
                    Segment segment = tuple2._1();
                    ResolveCore.Resolved m2 = tuple2._2();
                    if (!(segment instanceof Segment.Label)) break block18;
                    Segment.Label label = (Segment.Label)segment;
                    String singleLabel = label.value();
                    if (!(m2 instanceof ResolveCore.Resolved.Module)) break block18;
                    ResolveCore.Resolved.Module module = (ResolveCore.Resolved.Module)m2;
                    String string = singleLabel;
                    switch (string == null ? 0 : string.hashCode()) {
                        case 95: {
                            if (!"_".equals(string)) break;
                            BaseModule x$1 = rootModule;
                            Class<?> x$2 = module.cls();
                            None$ x$3 = None$.MODULE$;
                            Segments x$4 = current.segments();
                            ResolveCore.Cache x$5 = cache;
                            Seq<String> x$6 = this.resolveDirectChildren$default$5();
                            either = this.resolveDirectChildren(x$1, x$2, x$3, x$4, x$6, x$5);
                            break block19;
                        }
                        case 3040: {
                            if (!"__".equals(string)) break;
                            $colon$colon<Nothing$> self = new $colon$colon<Nothing$>((Nothing$)((Object)new ResolveCore.Resolved.Module(module.segments(), module.cls())), Nil$.MODULE$);
                            Either<String, Seq<ResolveCore.Resolved>> transitiveOrErr = this.resolveTransitiveChildren(rootModule, module.cls(), None$.MODULE$, current.segments(), Nil$.MODULE$, seenModules, cache);
                            either = transitiveOrErr.map((Function1<Seq, Seq> & Serializable)transitive -> (Seq)self.$plus$plus(transitive));
                            break block19;
                        }
                    }
                    if (string.startsWith("__:")) {
                        String[] typePattern = (String[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps(string.split(":")), 1);
                        $colon$colon<Nothing$> self = new $colon$colon<Nothing$>((Nothing$)((Object)new ResolveCore.Resolved.Module(module.segments(), module.cls())), Nil$.MODULE$);
                        Either<String, Seq<ResolveCore.Resolved>> transitiveOrErr = this.resolveTransitiveChildren(rootModule, module.cls(), None$.MODULE$, current.segments(), Predef$.MODULE$.copyArrayToImmutableIndexedSeq(typePattern), seenModules, cache);
                        either = transitiveOrErr.map((Function1<Seq, Seq> & Serializable)transitive -> (Seq)self.$plus$plus(transitive));
                    } else if (string.startsWith("_:")) {
                        String[] typePattern = (String[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps(string.split(":")), 1);
                        either = this.resolveDirectChildren(rootModule, module.cls(), None$.MODULE$, current.segments(), Predef$.MODULE$.copyArrayToImmutableIndexedSeq(typePattern), cache);
                    } else {
                        BaseModule x$7 = rootModule;
                        Class<?> x$8 = module.cls();
                        Some<String> x$9 = new Some<String>(singleLabel);
                        Segments x$10 = current.segments();
                        ResolveCore.Cache x$11 = cache;
                        Seq<String> x$12 = this.resolveDirectChildren$default$5();
                        either = this.resolveDirectChildren(x$7, x$8, x$9, x$10, x$12, x$11);
                    }
                }
                Either<String, Seq<ResolveCore.Resolved>> either2 = resOrErr = either;
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    String err = (String)left.value();
                    return new ResolveCore.Error(err);
                }
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    Seq res = (Seq)right.value();
                    return this.recurse$1((Seq)res.distinct(), seenModules, rootModule, tail, querySoFar, head, current, cache);
                }
                throw new MatchError(either2);
            }
            if (tuple2 != null) {
                Segment segment = tuple2._1();
                ResolveCore.Resolved m3 = tuple2._2();
                if (segment instanceof Segment.Cross) {
                    Segment.Cross cross = (Segment.Cross)segment;
                    Seq<String> cross2 = cross.value();
                    if (m3 instanceof ResolveCore.Resolved.Module) {
                        ResolveCore.Resolved.Module module = (ResolveCore.Resolved.Module)m3;
                        if (Cross.class.isAssignableFrom(module.cls())) {
                            Either either = this.instantiateModule(rootModule, current.segments(), cache).flatMap((Function1<Module, Either> & Serializable)x0$1 -> {
                                Module module = x0$1;
                                if (module instanceof Cross) {
                                    Cross cross = (Cross)module;
                                    return MODULE$.catchWrapException((Function0<Seq> & Serializable)() -> {
                                        Seq<String> seq = cross2;
                                        $colon$colon<Nothing$> $colon$colon = new $colon$colon<Nothing$>((Nothing$)((Object)"__"), Nil$.MODULE$);
                                        if (!(seq != null ? !seq.equals($colon$colon) : $colon$colon != null)) {
                                            return (Seq)cross.valuesToModules().toSeq().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ResolveCore$.$anonfun$resolve$8(check$ifrefutable$1))).map((Function1<Tuple2, Cross.Module> & Serializable)x$3 -> {
                                                Tuple2 tuple2 = x$3;
                                                if (tuple2 != null) {
                                                    Cross.Module v = (Cross.Module)tuple2._2();
                                                    return v;
                                                }
                                                throw new MatchError(tuple2);
                                            });
                                        }
                                        if (cross2.contains("_")) {
                                            return (Seq)cross.segmentsToModules().toList().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(ResolveCore$.$anonfun$resolve$10(check$ifrefutable$2))).withFilter((Function1<Tuple2, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(ResolveCore$.$anonfun$resolve$11(cross2, x$4))).withFilter((Function1<Tuple2, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ResolveCore$.$anonfun$resolve$12(cross2, x$5))).map((Function1<Tuple2, Cross.Module> & Serializable)x$6 -> {
                                                Tuple2 tuple2 = x$6;
                                                if (tuple2 != null) {
                                                    Cross.Module v = (Cross.Module)tuple2._2();
                                                    return v;
                                                }
                                                throw new MatchError(tuple2);
                                            });
                                        }
                                        Seq<String> crossOrDefault = cross2.isEmpty() ? cross.defaultCrossSegments() : cross2;
                                        return Option$.MODULE$.option2Iterable(cross.segmentsToModules().get(crossOrDefault.toList())).toSeq();
                                    });
                                }
                                throw new MatchError(module);
                            });
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                String err = (String)left.value();
                                return new ResolveCore.Error(err);
                            }
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                Seq searchModules = (Seq)right.value();
                                return this.recurse$1((Seq)searchModules.map((Function1<Cross.Module, ResolveCore.Resolved.Module> & Serializable)m -> new ResolveCore.Resolved.Module(m.millModuleSegments(), m.getClass())), seenModules, rootModule, tail, querySoFar, head, current, cache);
                            }
                            throw new MatchError(either);
                        }
                        return this.notFoundResult(rootModule, querySoFar, current, head, cache);
                    }
                }
            }
            return this.notFoundResult(rootModule, querySoFar, current, head, cache);
        }
        throw new MatchError(list2);
    }

    public Either<String, Module> instantiateModule(BaseModule rootModule, Segments segments, ResolveCore.Cache cache) {
        return (Either)cache.instantiatedModules().getOrElseUpdate(segments, (Function0<Either> & Serializable)() -> segments.value().foldLeft(new Right(rootModule), (Function2<Either, Segment, Either> & Serializable)(x0$1, x1$1) -> {
            Either either;
            Tuple2<Either, Segment> tuple2 = new Tuple2<Either, Segment>((Either)x0$1, (Segment)x1$1);
            if (tuple2 != null) {
                Either either2 = tuple2._1();
                Segment segment = tuple2._2();
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    Module current = (Module)right.value();
                    if (segment instanceof Segment.Label) {
                        String s;
                        Segment.Label label = (Segment.Label)segment;
                        String string = s = label.value();
                        String string2 = "_";
                        Predef$.MODULE$.assert(string == null ? string2 != null : !string.equals(string2), (Function0<Object>)(Function0<String> & Serializable)() -> s);
                        BaseModule x$1 = rootModule;
                        Segments x$2 = current.millModuleSegments();
                        Class<?> x$3 = current.getClass();
                        Some<String> x$4 = new Some<String>(s);
                        ResolveCore.Cache x$5 = cache;
                        Seq<String> x$6 = MODULE$.resolveDirectChildren0$default$5();
                        return MODULE$.resolveDirectChildren0(x$1, x$2, x$3, x$4, x$6, x$5).flatMap((Function1<Seq, Either> & Serializable)x0$2 -> {
                            Option option;
                            Tuple2 tuple2;
                            SeqOps seqOps;
                            Seq seq = x0$2;
                            if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple2 = (Tuple2)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null && (option = (Option)tuple2._2()) instanceof Some) {
                                Some some = (Some)option;
                                Function1 f = (Function1)some.value();
                                return (Either)f.apply(current);
                            }
                            throw scala.sys.package$.MODULE$.error(new StringBuilder(81).append("Unable to resolve single child ").append("rootModule: ").append(rootModule).append(", segments: ").append(segments.render()).append(",").append("current: ").append(current).append(", s: ").append(s).append(", unknown: ").append(seq).toString());
                        });
                    }
                }
            }
            if (tuple2 != null) {
                Either either3 = tuple2._1();
                Segment segment = tuple2._2();
                if (either3 instanceof Right) {
                    Right right = (Right)either3;
                    Module current = (Module)right.value();
                    if (segment instanceof Segment.Cross) {
                        Segment.Cross cross = (Segment.Cross)segment;
                        Seq<String> vs = cross.value();
                        Predef$.MODULE$.assert(!vs.contains("_"), (Function0<Object>)(Function0<Seq> & Serializable)() -> vs);
                        return MODULE$.catchWrapException((Function0<Module> & Serializable)() -> (Module)((Cross)current).segmentsToModules().apply(vs.toList()));
                    }
                }
            }
            if (tuple2 != null && (either = tuple2._1()) instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                return new Left(err);
            }
            throw new MatchError(tuple2);
        }));
    }

    public Either<String, Seq<ResolveCore.Resolved>> resolveTransitiveChildren(BaseModule rootModule, Class<?> cls, Option<String> nameOpt, Segments segments, Seq<String> typePattern, Set<Class<?>> seenModules, ResolveCore.Cache cache) {
        Seq<Nothing$> seq;
        if (seenModules.contains(cls)) {
            return new Left<String, Seq<ResolveCore.Resolved>>(this.cyclicModuleErrorMsg(segments));
        }
        Either<String, Seq<ResolveCore.Resolved>> errOrDirect = this.resolveDirectChildren(rootModule, cls, nameOpt, segments, typePattern, cache);
        Either<String, Seq<ResolveCore.Resolved>> directTraverse = this.resolveDirectChildren(rootModule, cls, nameOpt, segments, Nil$.MODULE$, cache);
        Either errOrModules = directTraverse.map((Function1<Seq, Seq> & Serializable)modules -> (Seq)modules.flatMap((Function1<ResolveCore.Resolved, Option> & Serializable)x0$1 -> {
            ResolveCore.Resolved resolved = x0$1;
            if (resolved instanceof ResolveCore.Resolved.Module) {
                ResolveCore.Resolved.Module module = (ResolveCore.Resolved.Module)resolved;
                return new Some<ResolveCore.Resolved.Module>(module);
            }
            return None$.MODULE$;
        }));
        Either either = errOrModules;
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq modules2 = (Seq)right.value();
            seq = (Seq)modules2.flatMap((Function1<ResolveCore.Resolved.Module, Some> & Serializable)m -> new Some<Either<String, Seq<ResolveCore.Resolved>>>(MODULE$.resolveTransitiveChildren(rootModule, m.cls(), nameOpt, m.segments(), typePattern, (Set)seenModules.$plus(cls), cache)));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            seq = new $colon$colon<Nothing$>((Nothing$)((Object)new Left(err)), Nil$.MODULE$);
        } else {
            throw new MatchError(either);
        }
        Seq<Nothing$> errOrIndirect0 = seq;
        Either errOrIndirect = EitherOps$.MODULE$.sequence(errOrIndirect0, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1<Seq, Seq> & Serializable)x$7 -> (Seq)x$7.flatten(Predef$.MODULE$.$conforms()));
        return errOrDirect.flatMap((Function1<Seq, Either> & Serializable)direct -> errOrIndirect.map((Function1<Seq, Seq> & Serializable)indirect -> (Seq)direct.$plus$plus(indirect)));
    }

    private Seq<Class<?>> resolveParents(Class<?> c2) {
        return (Seq)((IterableOps)new $colon$colon<Nothing$>((Nothing$)((Object)c2), Nil$.MODULE$).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(c2.getSuperclass())).toSeq().flatMap((Function1<Class, Seq> & Serializable)c -> MODULE$.resolveParents((Class<?>)c)))).$plus$plus(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps(c2.getInterfaces()), (Function1<Class, Seq> & Serializable)c -> MODULE$.resolveParents((Class<?>)c), ClassTag$.MODULE$.apply(Class.class))));
    }

    @Scaladoc(value="/**\n   * Check if the given class matches a given type selector as string\n   * @param cls\n   * @param typePattern\n   * @return\n   */")
    public boolean mill$resolve$ResolveCore$$classMatchesTypePred(Seq<String> typePattern, Class<?> cls) {
        return typePattern.forall((Function1<String, Object> & Serializable)pat -> BoxesRunTime.boxToBoolean(ResolveCore$.$anonfun$classMatchesTypePred$1(cls, pat)));
    }

    public Either<String, Seq<ResolveCore.Resolved>> resolveDirectChildren(BaseModule rootModule, Class<?> cls, Option<String> nameOpt, Segments segments, Seq<String> typePattern, ResolveCore.Cache cache) {
        Right crossesOrErr = Cross.class.isAssignableFrom(cls) && nameOpt.isEmpty() ? this.instantiateModule(rootModule, segments, cache).map((Function1<Module, List> & Serializable)x0$1 -> {
            Module module = x0$1;
            if (module instanceof Cross) {
                Cross cross = (Cross)module;
                return cross.items().map((Function1<Cross.Item, ResolveCore.Resolved.Module> & Serializable)item -> new ResolveCore.Resolved.Module(segments.$plus$plus(new Segment.Cross(item.crossSegments())), item.cls()));
            }
            return Nil$.MODULE$;
        }) : new Right(Nil$.MODULE$);
        return crossesOrErr.map((Function1<List, Tuple2> & Serializable)crosses -> {
            Object filteredCrosses = crosses.filter((Function1<ResolveCore.Resolved.Module, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(ResolveCore$.MODULE$.mill$resolve$ResolveCore$$classMatchesTypePred(typePattern, c.cls())));
            return new Tuple2<List, Object>((List)crosses, filteredCrosses);
        }).flatMap((Function1<Tuple2, Either> & Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                List filteredCrosses = (List)tuple2._2();
                return MODULE$.resolveDirectChildren0(rootModule, segments, cls, nameOpt, typePattern, cache).flatMap((Function1<Seq, Either> & Serializable)direct0 -> new Right(ResolveCore$.expandSegments$1(direct0, segments)).map((Function1<Seq, Seq> & Serializable)direct -> (Seq)direct.$plus$plus(filteredCrosses)));
            }
            throw new MatchError(tuple2);
        });
    }

    public Seq<String> resolveDirectChildren$default$5() {
        return Nil$.MODULE$;
    }

    public Either<String, Seq<Tuple2<ResolveCore.Resolved, Option<Function1<Module, Either<String, Module>>>>>> resolveDirectChildren0(BaseModule rootModule, Segments segments, Class<?> cls2, Option<String> nameOpt, Seq<String> typePattern, ResolveCore.Cache cache) {
        Either either;
        if (DynamicModule.class.isAssignableFrom(cls2)) {
            either = this.instantiateModule(rootModule, segments, cache).map((Function1<Module, Seq> & Serializable)x0$1 -> {
                Module module = x0$1;
                if (module instanceof DynamicModule) {
                    DynamicModule dynamicModule = (DynamicModule)module;
                    return (Seq)((IterableOps)((IterableOps)dynamicModule.millModuleDirectChildren().filter((Function1<Module, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(ResolveCore$.namePred$1(c.millModuleSegments().last().value(), nameOpt)))).filter((Function1<Module, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(ResolveCore$.MODULE$.mill$resolve$ResolveCore$$classMatchesTypePred(typePattern, c.getClass())))).map((Function1<Module, Tuple2> & Serializable)c -> new Tuple2<ResolveCore.Resolved.Module, Some<Function1<Module, Right> & Serializable>>(new ResolveCore.Resolved.Module(Segments$.MODULE$.labels(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{c.millModuleSegments().last().value()})), c.getClass()), new Some<Function1<Module, Right> & Serializable>((Function1<Module, Right> & Serializable)x -> new Right((Module)c))));
                }
                throw new MatchError(module);
            });
        } else {
            Tuple2[] reflectMemberObjects = (Tuple2[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps(Reflect$.MODULE$.reflectNestedObjects02(cls2, (Function1<String, Object> & Serializable)n -> BoxesRunTime.boxToBoolean(ResolveCore$.namePred$1(n, nameOpt)), (Function1<Class, Tuple2[]> & Serializable)cls -> cache.getMethods((Class<?>)cls), ClassTag$.MODULE$.apply(Module.class))), new Serializable(typePattern, cache){
                private static final long serialVersionUID = 0L;
                private final Seq typePattern$3;
                private final ResolveCore.Cache cache$5;

                public final <A1 extends Tuple3<String, Class<?>, Function1<Object, Module>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String name = A1._1();
                        Class<?> memberCls = A1._2();
                        Function1<Object, Module> getter2 = A1._3();
                        if (ResolveCore$.MODULE$.mill$resolve$ResolveCore$$classMatchesTypePred(this.typePattern$3, memberCls)) {
                            ResolveCore.Resolved.Module resolved = new ResolveCore.Resolved.Module(Segments$.MODULE$.labels(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.cache$5.decode(name)})), memberCls);
                            Some<Function1<Module, Either> & Serializable> getter22 = new Some<Function1<Module, Either> & Serializable>((Function1<Module, Either> & Serializable)mod -> ResolveCore$.MODULE$.catchWrapException((Function0<Module> & Serializable)() -> (Module)getter2.apply(mod)));
                            return (B1)new Tuple2<ResolveCore.Resolved.Module, Some<Function1<Module, Either> & Serializable>>(resolved, getter22);
                        }
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple3<String, Class<?>, Function1<Object, Module>> x1) {
                    Class<?> memberCls;
                    Tuple3<String, Class<?>, Function1<Object, Module>> tuple3 = x1;
                    return tuple3 != null && ResolveCore$.MODULE$.mill$resolve$ResolveCore$$classMatchesTypePred(this.typePattern$3, memberCls = tuple3._2());
                }
                {
                    this.typePattern$3 = typePattern$3;
                    this.cache$5 = cache$5;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.Function1 mill.define.Module ), $anonfun$applyOrElse$2(scala.Function1 mill.define.Module )}, serializedLambda);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Right right = new Right(Predef$.MODULE$.copyArrayToImmutableIndexedSeq(reflectMemberObjects));
            either = right;
        }
        Either modulesOrErr = either;
        Tuple2[] namedTasks = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Reflect$.MODULE$.reflect(cls2, NamedTask.class, (Function1<String, Object> & Serializable)n -> BoxesRunTime.boxToBoolean(ResolveCore$.namePred$1(n, nameOpt)), true, (Function1<Class, Tuple2[]> & Serializable)cls -> cache.getMethods((Class<?>)cls))), (Function1<Method, Tuple2> & Serializable)m -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ResolveCore.Resolved.NamedTask(Segments$.MODULE$.labels(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{cache.decode(m.getName())})))), None$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2[] commands = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Reflect$.MODULE$.reflect(cls2, Command.class, (Function1<String, Object> & Serializable)n -> BoxesRunTime.boxToBoolean(ResolveCore$.namePred$1(n, nameOpt)), false, (Function1<Class, Tuple2[]> & Serializable)cls -> cache.getMethods((Class<?>)cls))), (Function1<Method, String> & Serializable)m -> cache.decode(m.getName()), ClassTag$.MODULE$.apply(String.class))), (Function1<String, Tuple2> & Serializable)name -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ResolveCore.Resolved.Command(Segments$.MODULE$.labels(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})))), None$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
        return modulesOrErr.map((Function1<Seq, Seq> & Serializable)x$10 -> (Seq)((IterableOps)x$10.$plus$plus(Predef$.MODULE$.wrapRefArray((Object[])namedTasks))).$plus$plus(Predef$.MODULE$.wrapRefArray((Object[])commands)));
    }

    public Seq<String> resolveDirectChildren0$default$5() {
        return Nil$.MODULE$;
    }

    public ResolveCore.NotFound notFoundResult(BaseModule rootModule, Segments querySoFar, ResolveCore.Resolved current, Segment next, ResolveCore.Cache cache) {
        scala.collection.immutable.Iterable iterable;
        ResolveCore.Resolved resolved = current;
        if (resolved instanceof ResolveCore.Resolved.Module) {
            ResolveCore.Resolved.Module module = (ResolveCore.Resolved.Module)resolved;
            BaseModule x$1 = rootModule;
            Class<?> x$2 = module.cls();
            None$ x$3 = None$.MODULE$;
            Segments x$4 = current.segments();
            ResolveCore.Cache x$5 = cache;
            Seq<String> x$6 = this.resolveDirectChildren$default$5();
            iterable = (scala.collection.immutable.Iterable)((IterableOps)this.resolveDirectChildren(x$1, x$2, x$3, x$4, x$6, x$5).toOption().get()).map((Function1<ResolveCore.Resolved, Segment> & Serializable)x$11 -> (Segment)x$11.segments().value().last());
        } else {
            iterable = (scala.collection.immutable.Iterable)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        }
        scala.collection.immutable.Iterable possibleNexts = iterable;
        return new ResolveCore.NotFound(querySoFar, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResolveCore.Resolved[]{current})), next, possibleNexts.toSet());
    }

    private static final Set moduleClasses$1(Iterable resolved) {
        return ((IterableOnceOps)resolved.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends ResolveCore.Resolved, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ResolveCore.Resolved.Module) {
                    ResolveCore.Resolved.Module module = (ResolveCore.Resolved.Module)A1;
                    Class<?> cls = module.cls();
                    return (B1)cls;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(ResolveCore.Resolved x1) {
                ResolveCore.Resolved resolved = x1;
                return resolved instanceof ResolveCore.Resolved.Module;
            }
        })).toSet();
    }

    private final ResolveCore.Result recurse$1(Seq searchModules, Set seenModules$1, BaseModule rootModule$1, List tail$1, Segments querySoFar$1, Segment head$1, ResolveCore.Resolved current$1, ResolveCore.Cache cache$1) {
        Tuple2 tuple2 = ((IterableOps)searchModules.map((Function1<ResolveCore.Resolved, ResolveCore.Result> & Serializable)r -> {
            Set rClasses = ResolveCore$.moduleClasses$1((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResolveCore.Resolved[]{r})));
            if (seenModules$1.intersect(rClasses).nonEmpty()) {
                return new ResolveCore.Error(MODULE$.cyclicModuleErrorMsg(r.segments()));
            }
            return MODULE$.resolve(rootModule$1, tail$1, (ResolveCore.Resolved)r, querySoFar$1.$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)head$1), Nil$.MODULE$)), (Set)seenModules$1.$plus$plus(ResolveCore$.moduleClasses$1((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResolveCore.Resolved[]{current$1})))), cache$1);
        })).partitionMap((Function1<ResolveCore.Result, Either> & Serializable)x0$1 -> {
            ResolveCore.Result result2 = x0$1;
            if (result2 instanceof ResolveCore.Success) {
                ResolveCore.Success success = (ResolveCore.Success)result2;
                return new Right(success.value());
            }
            if (result2 instanceof ResolveCore.Failed) {
                ResolveCore.Failed failed = (ResolveCore.Failed)result2;
                return new Left(failed);
            }
            throw new MatchError(result2);
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq failures = (Seq)tuple2._1();
        Seq successesLists = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(failures, successesLists);
        Seq failures2 = tuple22._1();
        Seq successesLists2 = tuple22._2();
        Tuple2 tuple23 = failures2.partitionMap((Function1<ResolveCore.Failed, Either> & Serializable)x0$2 -> {
            ResolveCore.Failed failed = x0$2;
            if (failed instanceof ResolveCore.NotFound) {
                ResolveCore.NotFound notFound = (ResolveCore.NotFound)failed;
                return new Right(notFound);
            }
            if (failed instanceof ResolveCore.Error) {
                ResolveCore.Error error = (ResolveCore.Error)failed;
                return new Left(error.msg());
            }
            throw new MatchError(failed);
        });
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Seq errors = (Seq)tuple23._1();
        Seq notFounds = (Seq)tuple23._2();
        Tuple2<Seq, Seq> tuple24 = new Tuple2<Seq, Seq>(errors, notFounds);
        Seq errors2 = tuple24._1();
        Seq notFounds2 = tuple24._2();
        if (errors2.nonEmpty()) {
            return new ResolveCore.Error(errors2.mkString("\n"));
        }
        if (((IterableOnceOps)successesLists2.flatten(Predef$.MODULE$.$conforms())).nonEmpty()) {
            return new ResolveCore.Success((Seq)successesLists2.flatten(Predef$.MODULE$.$conforms()));
        }
        int n = notFounds2.size();
        switch (n) {
            case 1: {
                return (ResolveCore.Result)notFounds2.head();
            }
        }
        return this.notFoundResult(rootModule$1, querySoFar$1, current$1, head$1, cache$1);
    }

    public static final /* synthetic */ boolean $anonfun$resolve$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$resolve$10(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$resolve$11(Seq cross$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            List segments = (List)tuple2._1();
            return segments.length() == cross$1.length();
        }
        throw new MatchError(tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$resolve$13(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError(tuple2);
        String l = (String)tuple2._1();
        String r = (String)tuple2._2();
        String string = l;
        String string2 = r;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = r;
        String string4 = "_";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$resolve$12(Seq cross$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            List segments = (List)tuple2._1();
            return ((List)segments.zip((IterableOnce)cross$1)).forall((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(ResolveCore$.$anonfun$resolve$13(x0$2)));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$classMatchesTypePred$1(Class cls$3, String pat) {
        boolean negate = pat.startsWith("^") || pat.startsWith("!");
        String clsPat = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(pat), negate ? 1 : 0);
        Seq typeNames = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(clsPat.split("[.$]"))).reverse();
        Seq<Class<?>> parents = MODULE$.resolveParents(cls$3);
        Seq classNames = (Seq)parents.flatMap((Function1<Class, Seq> & Serializable)c -> (Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(new StringBuilder(7).append("_root_$").append(c.getName()).toString().split("[.$]"))).reverse()).inits().toSeq().filter((Function1<Seq, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(x$8.nonEmpty())));
        boolean isOfType = classNames.contains(typeNames);
        if (negate) {
            return !isOfType;
        }
        return isOfType;
    }

    private static final Seq expandSegments$1(Seq direct, Segments segments$2) {
        return (Seq)direct.map((Function1<Tuple2, Product> & Serializable)x0$1 -> {
            ResolveCore.Resolved resolved;
            ResolveCore.Resolved resolved2;
            ResolveCore.Resolved resolved3;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (resolved3 = (ResolveCore.Resolved)tuple2._1()) instanceof ResolveCore.Resolved.Module) {
                ResolveCore.Resolved.Module module = (ResolveCore.Resolved.Module)resolved3;
                Segments s = module.segments();
                Class<?> cls = module.cls();
                return new ResolveCore.Resolved.Module(segments$2.$plus$plus(s), cls);
            }
            if (tuple2 != null && (resolved2 = (ResolveCore.Resolved)tuple2._1()) instanceof ResolveCore.Resolved.NamedTask) {
                ResolveCore.Resolved.NamedTask namedTask = (ResolveCore.Resolved.NamedTask)resolved2;
                Segments s = namedTask.segments();
                return new ResolveCore.Resolved.NamedTask(segments$2.$plus$plus(s));
            }
            if (tuple2 != null && (resolved = (ResolveCore.Resolved)tuple2._1()) instanceof ResolveCore.Resolved.Command) {
                ResolveCore.Resolved.Command command = (ResolveCore.Resolved.Command)resolved;
                Segments s = command.segments();
                return new ResolveCore.Resolved.Command(segments$2.$plus$plus(s));
            }
            throw new MatchError(tuple2);
        });
    }

    private static final boolean namePred$1(String n, Option nameOpt$3) {
        return nameOpt$3.isEmpty() || nameOpt$3.contains(n);
    }

    private ResolveCore$() {
    }
}

