/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import java.io.IOException;
import java.io.InputStream;

final class SnappyInternalUtils {
    private SnappyInternalUtils() {
    }

    static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    static void checkPositionIndexes(int start, int end, int size2) {
        if (start < 0 || end < start || end > size2) {
            throw new IndexOutOfBoundsException(SnappyInternalUtils.badPositionIndexes(start, end, size2));
        }
    }

    static String badPositionIndexes(int start, int end, int size2) {
        if (start < 0 || start > size2) {
            return SnappyInternalUtils.badPositionIndex(start, size2, "start index");
        }
        if (end < 0 || end > size2) {
            return SnappyInternalUtils.badPositionIndex(end, size2, "end index");
        }
        return String.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    static String badPositionIndex(int index, int size2, String desc) {
        if (index < 0) {
            return String.format("%s (%s) must not be negative", desc, index);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        return String.format("%s (%s) must not be greater than size (%s)", desc, index, size2);
    }

    static int readBytes(InputStream source, byte[] dest, int offset, int length) throws IOException {
        int lastRead;
        SnappyInternalUtils.checkNotNull(source, "source is null", new Object[0]);
        SnappyInternalUtils.checkNotNull(dest, "dest is null", new Object[0]);
        int totalRead = lastRead = source.read(dest, offset, length);
        if (lastRead < length) {
            while (totalRead < length && lastRead != -1) {
                lastRead = source.read(dest, offset + totalRead, length - totalRead);
                if (lastRead == -1) continue;
                totalRead += lastRead;
            }
        }
        return totalRead;
    }

    static int skip(InputStream source, int skip) throws IOException {
        if (skip <= 0) {
            return 0;
        }
        int toSkip = skip - (int)source.skip(skip);
        boolean more = true;
        while (toSkip > 0 && more) {
            int read2 = source.read();
            if (read2 == -1) {
                more = false;
                continue;
            }
            --toSkip;
            toSkip = (int)((long)toSkip - source.skip(toSkip));
        }
        int skipped = skip - toSkip;
        return skipped;
    }
}

