/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraphvizServer {
    private static final Logger LOG = LoggerFactory.getLogger(GraphvizServer.class);
    private static final String ENGINE_PACKAGE = "guru.nidi.graphviz.engine";
    static final int DEFAULT_PORT = 10234;

    private GraphvizServer() {
    }

    public static void start(List<GraphvizEngine> engines) throws IOException {
        GraphvizServer.start(engines, 10234);
    }

    public static void start(List<GraphvizEngine> engines, int port) throws IOException {
        String executable = SystemUtils.executableNames("java").get(0);
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(System.getProperty("java.home") + "/bin/" + executable, "-cp", System.getProperty("java.class.path"), GraphvizServer.class.getName(), "-p", Integer.toString(port)));
        cmd.addAll(engines.stream().map(e -> e.getClass().getName()).collect(Collectors.toList()));
        new ProcessBuilder(cmd).inheritIO().start();
    }

    /*
     * Exception decompiling
     */
    public static void main(String ... args) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static GraphvizEngine engineFromString(String s) {
        try {
            Object o = Class.forName(s).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(o instanceof GraphvizEngine)) {
                throw new IllegalArgumentException(s + " does not implement GraphvizEngine.");
            }
            return (GraphvizEngine)o;
        }
        catch (ReflectiveOperationException e) {
            if (!s.startsWith(ENGINE_PACKAGE)) {
                return GraphvizServer.engineFromString("guru.nidi.graphviz.engine." + s);
            }
            throw new IllegalArgumentException("class " + s + " not found.");
        }
    }

    private static String render(String raw) {
        String src;
        Options options;
        int pos = raw.indexOf("@@@");
        if (pos < 0) {
            options = Options.create().format(Format.SVG_STANDALONE);
            src = raw;
        } else {
            options = Options.fromJson(raw.substring(0, pos));
            src = raw.substring(pos + 3);
        }
        return Graphviz.fromString(src).engine(options.engine).totalMemory(options.totalMemory).yInvert(options.yInvert).render(options.format).toString();
    }

    static class CmdOptions {
        final Map<String, String> opts = new HashMap<String, String>();
        final List<String> args = new ArrayList<String>();

        CmdOptions() {
        }

        static CmdOptions parse(String[] args) {
            CmdOptions options = new CmdOptions();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    String value;
                    int len = args[i].length();
                    if (len == 1) {
                        throw new IllegalArgumentException("Illegal option -");
                    }
                    String name = args[i].substring(1, 2);
                    if (len > 2) {
                        value = args[i].substring(2);
                    } else if (i == args.length - 1) {
                        value = "";
                    } else {
                        value = args[i + 1];
                        ++i;
                    }
                    options.opts.put(name, value);
                    continue;
                }
                options.args.add(args[i]);
            }
            return options;
        }
    }
}

