/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.StringReader;
import com.eed3si9n.jarjar.util.ClassPathEntry;
import com.eed3si9n.jarjar.util.ClassPathIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.objectweb.asm.ClassReader;

class StringDumper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String string, PrintWriter printWriter) throws IOException {
        DumpStringReader dumpStringReader = new DumpStringReader(printWriter);
        try (ClassPathIterator classPathIterator = new ClassPathIterator(string);){
            while (classPathIterator.hasNext()) {
                ClassPathEntry classPathEntry = classPathIterator.next();
                try (InputStream inputStream = classPathEntry.openStream();){
                    new ClassReader(inputStream).accept(dumpStringReader, 0);
                }
                printWriter.flush();
            }
        }
    }

    private static String escapeStringLiteral(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        block9: for (char c : string.toCharArray()) {
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private static class DumpStringReader
    extends StringReader {
        private final PrintWriter pw;
        private String className;

        public DumpStringReader(PrintWriter printWriter) {
            this.pw = printWriter;
        }

        @Override
        public void visitString(String string, String string2, int n) {
            if (string2.length() > 0) {
                if (!string.equals(this.className)) {
                    this.className = string;
                    this.pw.println(string.replace('/', '.'));
                }
                this.pw.print("\t");
                if (n >= 0) {
                    this.pw.print(n + ": ");
                }
                this.pw.print(StringDumper.escapeStringLiteral(string2));
                this.pw.println();
            }
        }
    }
}

