/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.Map;
import java.util.TreeSet;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class QualityToken
extends AbstractNonEmptyToken<Equipment>
implements CDOMPrimaryToken<Equipment> {
    @Override
    public String getTokenName() {
        return "QUALITY";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Equipment eq, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " expecting '|', format is: " + "QualityType|Quality value was: " + value, context);
        }
        if (pipeLoc != value.lastIndexOf("|")) {
            return new ParseResult.Fail(this.getTokenName() + " expecting only one '|', " + "format is: QualityType|Quality value was: " + value, context);
        }
        String key = value.substring(0, pipeLoc);
        if (key.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty type, " + "format is: QualityType|Quality value was: " + value, context);
        }
        String val = value.substring(pipeLoc + 1);
        if (val.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty value, " + "format is: QualityType|Quality value was: " + value, context);
        }
        context.getObjectContext().put(eq, MapKey.QUALITY, key, val);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Equipment eq) {
        MapChanges<String, String> changes = context.getObjectContext().getMapChanges(eq, MapKey.QUALITY);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Map<String, String> added = changes.getAdded();
        for (Map.Entry<String, String> me : added.entrySet()) {
            set.add(me.getKey() + "|" + me.getValue());
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

