/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.chooser;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.util.RandomUtil;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.util.ListFacade;
import pcgen.util.chooser.ChoiceHandler;
import pcgen.util.chooser.ChooserInterface;

public final class RandomChooser
implements ChooserInterface,
ChoiceHandler {
    private List theAvailableList = new ArrayList();
    private List theSelectedList = new ArrayList();
    private List theUniqueList = new ArrayList();
    private boolean theAllowDuplicatesFlag = false;
    private int selectionsPerUnitCost = 1;
    private int totalSelectionsAvailable = 1;
    private boolean pickAll = false;

    @Override
    public void setAllowsDups(boolean aBool) {
        this.theAllowDuplicatesFlag = aBool;
    }

    @Override
    public void setAvailableList(List availableList) {
        this.theAvailableList = new ArrayList(availableList);
    }

    @Override
    public void setCostColumnNumber(int costColumnNumber) {
    }

    @Override
    public void setMessageText(String argMessageText) {
    }

    @Override
    public void setNegativeAllowed(boolean argFlag) {
    }

    @Override
    public int getPool() {
        return this.totalSelectionsAvailable - this.theSelectedList.size();
    }

    @Override
    public void setPoolFlag(boolean poolFlag) {
    }

    @Override
    public void setSelectedList(List selectedList) {
        this.theSelectedList.addAll(selectedList);
    }

    @Override
    public ArrayList getSelectedList() {
        return new ArrayList(this.theSelectedList);
    }

    @Override
    public void setSelectedListTerminator(String aString) {
    }

    @Override
    public void setUniqueList(List uniqueList) {
        this.theUniqueList = uniqueList;
    }

    @Override
    public void setVisible(boolean b) {
        while (this.getEffectivePool() > 0 && this.theAvailableList.size() > 0) {
            this.selectAvailable();
        }
    }

    @Override
    public void setAvailableColumnNames(List<String> availableColumnNames) {
    }

    private void selectAvailable() {
        this.setMessageText(null);
        if (this.getEffectivePool() <= 0) {
            return;
        }
        Object addObj = this.theAvailableList.get(RandomUtil.getRandomInt(this.theAvailableList.size() - 1));
        if (this.theUniqueList.contains(addObj)) {
            return;
        }
        int count = this.theSelectedList.size();
        for (int i = 0; i < count; ++i) {
            Object anObj = this.theSelectedList.get(i);
            if (!addObj.equals(anObj) || this.theAllowDuplicatesFlag) continue;
            return;
        }
        this.theSelectedList.add(addObj);
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void show() {
    }

    @Override
    public void setChoicesPerUnit(int cost) {
        this.selectionsPerUnitCost = cost;
    }

    @Override
    public void setTotalChoicesAvail(int avail) {
        this.totalSelectionsAvailable = avail;
    }

    @Override
    public void setPickAll(boolean b) {
        this.pickAll = b;
    }

    @Override
    public boolean pickAll() {
        return this.pickAll;
    }

    public int getEffectivePool() {
        return this.selectionsPerUnitCost * this.totalSelectionsAvailable - this.theSelectedList.size();
    }

    @Override
    public boolean makeChoice(ChooserFacade chooserFacade) {
        while (chooserFacade.getRemainingSelections().getReference() > 0 && !chooserFacade.getAvailableList().isEmpty()) {
            ListFacade<InfoFacade> availableList = chooserFacade.getAvailableList();
            InfoFacade addObj = availableList.getElementAt(RandomUtil.getRandomInt(availableList.getSize() - 1));
            chooserFacade.addSelected(addObj);
        }
        if (chooserFacade.getRemainingSelections().getReference() == 0 || !chooserFacade.isRequireCompleteSelection()) {
            chooserFacade.commit();
            return true;
        }
        chooserFacade.rollback();
        return false;
    }
}

