/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.GameModeDisplay;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.CampaignInfoFactory;
import pcgen.facade.core.GameModeDisplayFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.LoadableFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.ReferenceFacade;
import pcgen.gui2.facade.Gui2CampaignInfoFactory;
import pcgen.persistence.PersistenceManager;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.system.PropertyContext;
import pcgen.util.Logging;

public class FacadeFactory {
    private static PropertyContext sourcesContext = PCGenSettings.getInstance().createChildContext("customSources");
    private static DefaultListFacade<SourceSelectionFacade> quickSources = null;
    private static DefaultListFacade<CampaignFacade> campaigns = null;
    private static DefaultListFacade<GameModeFacade> gamemodes = null;
    private static DefaultListFacade<GameModeDisplayFacade> gamemodedisplays = null;
    private static DefaultListFacade<SourceSelectionFacade> displayedSources = null;
    private static DefaultListFacade<SourceSelectionFacade> customSources;
    private static Map<String, CampaignFacade> campaignMap;
    private static Map<GameModeFacade, DefaultListFacade<CampaignFacade>> campaignListMap;
    private static CampaignInfoFactory campInfoFactory;

    static void initialize() {
        List<GameMode> modes = SystemCollections.getUnmodifiableGameModeList();
        List<GameModeDisplay> modeDisplays = SystemCollections.getUnmodifiableGameModeDisplayList();
        List<Campaign> camps = Globals.getCampaignList();
        gamemodes = new DefaultListFacade<GameMode>(modes);
        gamemodedisplays = new DefaultListFacade<GameModeDisplay>(modeDisplays);
        campaigns = new DefaultListFacade<Campaign>(camps);
        quickSources = new DefaultListFacade();
        displayedSources = new DefaultListFacade();
        customSources = new DefaultListFacade();
        campaignMap = new HashMap<String, CampaignFacade>();
        campaignListMap = new HashMap<GameModeFacade, DefaultListFacade<CampaignFacade>>();
        FacadeFactory.initCampaigns();
        FacadeFactory.initGameModes(modes);
        FacadeFactory.initCustomSourceSelections();
        FacadeFactory.initDisplayedSources();
    }

    public static void refresh() {
        List<GameMode> modes = SystemCollections.getUnmodifiableGameModeList();
        List<GameModeDisplay> modeDisplays = SystemCollections.getUnmodifiableGameModeDisplayList();
        List<Campaign> camps = Globals.getCampaignList();
        gamemodes.setContents(modes);
        gamemodedisplays.setContents(modeDisplays);
        campaigns.setContents(camps);
        quickSources.clearContents();
        displayedSources.clearContents();
        customSources.clearContents();
        campaignMap.clear();
        campaignListMap.clear();
        FacadeFactory.initCampaigns();
        FacadeFactory.initGameModes(modes);
        FacadeFactory.initCustomSourceSelections();
        FacadeFactory.initDisplayedSources();
    }

    private static void initCampaigns() {
        for (CampaignFacade campaign : campaigns) {
            campaignMap.put(campaign.getName(), campaign);
            ListFacade<GameModeFacade> gameModeList = campaign.getGameModes();
            for (GameModeFacade gameModeFacade : gameModeList) {
                DefaultListFacade<CampaignFacade> campaignList;
                if (!campaignListMap.containsKey(gameModeFacade)) {
                    campaignListMap.put(gameModeFacade, new DefaultListFacade());
                }
                if ((campaignList = campaignListMap.get(gameModeFacade)).containsElement(campaign)) {
                    String sourceUri = ((CDOMObject)((Object)campaign)).getSourceURI().toString();
                    Logging.errorPrint("Campaign " + sourceUri + " lists GAMEMODE:" + gameModeFacade + " multiple times.");
                    continue;
                }
                campaignList.addElement(campaign);
            }
            if (!campaign.showInMenu() || gameModeList.isEmpty()) continue;
            GameModeFacade game = gameModeList.getElementAt(0);
            DefaultListFacade<CampaignFacade> list = new DefaultListFacade<CampaignFacade>(Collections.singleton(campaign));
            quickSources.addElement(new BasicSourceSelectionFacade(campaign.getName(), list, game));
        }
    }

    private static void initGameModes(List<GameMode> modes) {
        for (GameMode mode : modes) {
            String title = mode.getDefaultSourceTitle();
            if (SettingsHandler.getGame().equals(mode) && title == null && !mode.getDefaultDataSetList().isEmpty()) {
                title = mode.getName();
            }
            if (title == null || "".equals(title)) continue;
            DefaultListFacade<CampaignFacade> qcamps = new DefaultListFacade<CampaignFacade>();
            List<String> sources = mode.getDefaultDataSetList();
            for (String string : sources) {
                Campaign camp = Globals.getCampaignKeyed(string);
                if (camp != null) {
                    qcamps.addElement(camp);
                    continue;
                }
                Logging.log(Logging.WARNING, "Unable to find source " + string + " used in default source " + title + " for game mode " + mode + ". " + title + " might not work correctly.");
            }
            if (qcamps.isEmpty()) {
                Logging.log(Logging.WARNING, "Unable to load default source '" + title + "'. All of its sources are missing.");
                continue;
            }
            quickSources.addElement(new BasicSourceSelectionFacade(mode.getDefaultSourceTitle(), qcamps, mode));
        }
    }

    private static void initDisplayedSources() {
        Object[] hiddenElements = PCGenSettings.getInstance().getStringArray("hiddenSources", ArrayUtils.EMPTY_STRING_ARRAY);
        for (int i = 0; i < quickSources.getSize(); ++i) {
            SourceSelectionFacade selection = quickSources.getElementAt(i);
            if (ArrayUtils.contains(hiddenElements, selection.toString())) continue;
            displayedSources.addElement(selection);
        }
    }

    private static void initCustomSourceSelections() {
        String[] keys = sourcesContext.getStringArray("selectionNames");
        if (keys == null) {
            return;
        }
        for (String name : keys) {
            PropertyContext context = sourcesContext.createChildContext(name);
            String modeName = context.getProperty("gamemode");
            GameMode mode = SystemCollections.getGameModeNamed(modeName);
            if (mode == null) {
                Logging.errorPrint("Unable to load quick source '" + name + "'. Game mode '" + modeName + "' is missing");
                continue;
            }
            String[] selectionArray = context.getStringArray("campaigns");
            ArrayList<CampaignFacade> sources = new ArrayList<CampaignFacade>();
            boolean error = false;
            for (String campaign : selectionArray) {
                CampaignFacade c = campaignMap.get(campaign);
                if (c != null) {
                    sources.add(c);
                    continue;
                }
                error = true;
                Logging.log(Logging.WARNING, "'" + campaign + "'" + " campaign not found, custom quick source '" + name + "' might not work correctly.");
            }
            if (sources.isEmpty()) {
                Logging.errorPrint("Unable to load quick source '" + name + "'. All of its sources are missing");
                continue;
            }
            CustomSourceSelectionFacade selection = new CustomSourceSelectionFacade(name);
            selection.setGameMode(mode);
            selection.setCampaigns(sources);
            if (error) {
                selection.setLoadingState(LoadableFacade.LoadingState.LOADED_WITH_ERRORS);
                selection.setErrorMessage("Some campaigns are missing");
            }
            customSources.addElement(selection);
            quickSources.addElement(selection);
        }
    }

    public static SourceSelectionFacade createCustomSourceSelection(String name) {
        CustomSourceSelectionFacade selection = new CustomSourceSelectionFacade(name);
        customSources.addElement(selection);
        quickSources.addElement(selection);
        displayedSources.addElement(selection);
        FacadeFactory.setCustomSourceSelectionArray();
        return selection;
    }

    public static void deleteCustomSourceSelection(SourceSelectionFacade source) {
        if (!(source instanceof CustomSourceSelectionFacade)) {
            throw new IllegalArgumentException();
        }
        customSources.removeElement(source);
        quickSources.removeElement(source);
        displayedSources.removeElement(source);
        PropertyContext context = sourcesContext.createChildContext(source.toString());
        context.removeProperty("gamemode");
        context.removeProperty("campaigns");
        FacadeFactory.setCustomSourceSelectionArray();
    }

    private static void setCustomSourceSelectionArray() {
        ArrayList<String> sources = new ArrayList<String>();
        for (SourceSelectionFacade csel : customSources) {
            sources.add(csel.toString());
        }
        sourcesContext.setStringArray("selectionNames", sources);
    }

    public static void setDisplayedSources(SourceSelectionFacade[] sources) {
        displayedSources.setContents(Arrays.asList(sources));
        ArrayList<String> hiddenElements = new ArrayList<String>();
        for (SourceSelectionFacade selection : quickSources) {
            if (ArrayUtils.contains(sources, selection)) continue;
            hiddenElements.add(selection.toString());
        }
        PCGenSettings.getInstance().setStringArray("hiddenSources", hiddenElements);
    }

    public static SourceSelectionFacade createSourceSelection(GameModeFacade gameMode, List<? extends CampaignFacade> campaignList) {
        return new BasicSourceSelectionFacade(null, new DefaultListFacade<CampaignFacade>(campaignList), gameMode);
    }

    public static SourceSelectionFacade createSourceSelection(GameModeFacade gameMode, List<? extends CampaignFacade> campaignList, String sourceTitle) {
        return new BasicSourceSelectionFacade(sourceTitle, new DefaultListFacade<CampaignFacade>(campaignList), gameMode);
    }

    public static ListFacade<SourceSelectionFacade> getDisplayedSourceSelections() {
        return displayedSources;
    }

    public static ListFacade<SourceSelectionFacade> getSourceSelections() {
        return quickSources;
    }

    public static ListFacade<SourceSelectionFacade> getCustomSourceSelections() {
        return customSources;
    }

    public static ListFacade<CampaignFacade> getCampaigns() {
        return campaigns;
    }

    public static ListFacade<GameModeFacade> getGameModes() {
        return gamemodes;
    }

    public static ListFacade<GameModeDisplayFacade> getGameModeDisplays() {
        return gamemodedisplays;
    }

    public static ListFacade<CampaignFacade> getSupportedCampaigns(GameModeFacade gameMode) {
        if (!campaignListMap.containsKey(gameMode)) {
            return ListFacades.emptyList();
        }
        return campaignListMap.get(gameMode);
    }

    public static CampaignInfoFactory getCampaignInfoFactory() {
        return campInfoFactory;
    }

    public static boolean passesPrereqs(List<CampaignFacade> campaigns) {
        PersistenceManager pman = PersistenceManager.getInstance();
        List<URI> oldList = pman.getChosenCampaignSourcefiles();
        ArrayList<URI> uris = new ArrayList<URI>();
        for (CampaignFacade campaignFacade : campaigns) {
            uris.add(((Campaign)campaignFacade).getSourceURI());
        }
        pman.setChosenCampaignSourcefiles(uris);
        for (CampaignFacade campaignFacade : campaigns) {
            Campaign camp = (Campaign)campaignFacade;
            if (camp.qualifies(null, camp)) continue;
            pman.setChosenCampaignSourcefiles(oldList);
            return false;
        }
        pman.setChosenCampaignSourcefiles(oldList);
        return true;
    }

    static {
        campaignListMap = null;
        campInfoFactory = new Gui2CampaignInfoFactory();
    }

    private static class CustomSourceSelectionFacade
    implements SourceSelectionFacade {
        private PropertyContext context;
        private String name;
        private LoadableFacade.LoadingState loadingState = LoadableFacade.LoadingState.LOADED;
        private String errorMessage = null;
        private DefaultListFacade<CampaignFacade> campaigns = new DefaultListFacade();
        private DefaultReferenceFacade<GameModeFacade> gameModeRef = new DefaultReferenceFacade();

        public CustomSourceSelectionFacade(String name) {
            this.name = name;
            this.context = sourcesContext.createChildContext(name);
        }

        @Override
        public boolean isModifiable() {
            return true;
        }

        @Override
        public void setCampaigns(List<CampaignFacade> campaign) {
            this.campaigns.setContents(campaign);
            ArrayList<String> camps = new ArrayList<String>();
            for (CampaignFacade camp : campaign) {
                camps.add(camp.getName());
            }
            this.context.setStringArray("campaigns", camps);
        }

        @Override
        public void setGameMode(GameModeFacade gameMode) {
            this.gameModeRef.setReference(gameMode);
            this.context.setProperty("gamemode", gameMode.getName());
        }

        public String toString() {
            return this.name;
        }

        @Override
        public LoadableFacade.LoadingState getLoadingState() {
            return this.loadingState;
        }

        @Override
        public String getLoadingErrorMessage() {
            return this.errorMessage;
        }

        public void setLoadingState(LoadableFacade.LoadingState loadingState) {
            this.loadingState = loadingState;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public ListFacade<CampaignFacade> getCampaigns() {
            return this.campaigns;
        }

        @Override
        public ReferenceFacade<GameModeFacade> getGameMode() {
            return this.gameModeRef;
        }
    }

    private static class BasicSourceSelectionFacade
    implements SourceSelectionFacade {
        private final ListFacade<CampaignFacade> campaignModel;
        private final DefaultReferenceFacade<GameModeFacade> gameModeRef;
        private final String name;

        public BasicSourceSelectionFacade(String name, ListFacade<CampaignFacade> campaignModel, GameModeFacade gameMode) {
            this.name = name;
            this.campaignModel = campaignModel;
            this.gameModeRef = new DefaultReferenceFacade<GameModeFacade>(gameMode);
        }

        @Override
        public void setCampaigns(List<CampaignFacade> campaign) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setGameMode(GameModeFacade gameMode) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public LoadableFacade.LoadingState getLoadingState() {
            return LoadableFacade.LoadingState.LOADED;
        }

        @Override
        public String getLoadingErrorMessage() {
            return null;
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            if (this.gameModeRef != null && this.gameModeRef.getReference() != null) {
                return LanguageBundle.getFormattedString("in_source_gamemode", this.gameModeRef.getReference().getDisplayName());
            }
            return "";
        }

        @Override
        public ListFacade<CampaignFacade> getCampaigns() {
            return this.campaignModel;
        }

        @Override
        public ReferenceFacade<GameModeFacade> getGameMode() {
            return this.gameModeRef;
        }
    }
}

