/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import pcgen.core.GameMode;
import pcgen.persistence.lst.GameModeLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public final class GameModeLoader {
    private GameModeLoader() {
    }

    public static void parseMiscGameInfoLine(GameMode gameMode, String aLine, URI source, int lineNum) {
        if (gameMode == null) {
            return;
        }
        int idxColon = aLine.indexOf(58);
        if (idxColon < 0) {
            return;
        }
        String key = aLine.substring(0, idxColon);
        String value = aLine.substring(idxColon + 1).trim();
        Map<String, LstToken> tokenMap = TokenStore.inst().getTokenMap(GameModeLstToken.class);
        GameModeLstToken token = (GameModeLstToken)tokenMap.get(key);
        if (token != null) {
            LstUtils.deprecationCheck(token, gameMode.getName(), source, value);
            if (!token.parse(gameMode, value.intern(), source)) {
                Logging.errorPrint("Error parsing misc. game info " + gameMode.getName() + '/' + source + ':' + Integer.toString(lineNum) + " \"" + aLine + "\"");
            }
        } else {
            Logging.errorPrint("Illegal misc. game info " + gameMode.getName() + '/' + source + ':' + Integer.toString(lineNum) + " \"" + aLine + "\"");
        }
    }
}

