/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.tabs.spells.SpellNodeDataView;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;

public class SpellTreeViewModel
implements TreeViewModel<SpellSupportFacade.SuperNode> {
    private final SpellNodeDataView dataView;
    private final ListFacade<? extends SpellSupportFacade.SuperNode> spellNodes;
    private final ListFacade<SpellTreeView> treeViews;
    private final String prefsKey;

    public SpellTreeViewModel(ListFacade<? extends SpellSupportFacade.SuperNode> spellNodes, boolean showcolumns, String prefsKey, InfoFactory infoFactory) {
        this.spellNodes = spellNodes;
        this.prefsKey = prefsKey;
        this.treeViews = new DefaultListFacade<SpellTreeView>(Arrays.asList(SpellTreeView.values()));
        this.dataView = new SpellNodeDataView(showcolumns, prefsKey, infoFactory);
    }

    @Override
    public ListFacade<? extends TreeView<SpellSupportFacade.SuperNode>> getTreeViews() {
        return this.treeViews;
    }

    @Override
    public int getDefaultTreeViewIndex() {
        return 0;
    }

    @Override
    public DataView<SpellSupportFacade.SuperNode> getDataView() {
        return this.dataView;
    }

    @Override
    public ListFacade<SpellSupportFacade.SuperNode> getDataModel() {
        return this.spellNodes;
    }

    private static enum SpellTreeView implements TreeView<SpellSupportFacade.SuperNode>
    {
        CLASS_LEVEL_SPELL("in_spellClassLevelSpell"),
        CLASS_LEVEL_SCHOOL_SPELL("in_spellClassLevelSchoolSpell");

        private String name;

        private SpellTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<SpellSupportFacade.SuperNode>> getPaths(SpellSupportFacade.SuperNode node) {
            TreeViewPath<SpellSupportFacade.SuperNode> path;
            if (node instanceof SpellSupportFacade.SpellNode) {
                SpellSupportFacade.SpellNode pobj = (SpellSupportFacade.SpellNode)node;
                LinkedList<String> pathList = new LinkedList<String>();
                switch (this) {
                    case CLASS_LEVEL_SPELL: {
                        Collections.addAll(pathList, pobj.getRootNode(), pobj.getSpellcastingClass(), pobj.getSpellLevel());
                        pathList.removeAll(Collections.singleton(null));
                        if (pobj.getSpell() == null) {
                            pathList.removeLast();
                        }
                        path = new TreeViewPath<SpellSupportFacade.SpellNode>(pobj, pathList.toArray());
                        break;
                    }
                    case CLASS_LEVEL_SCHOOL_SPELL: {
                        Collections.addAll(pathList, pobj.getRootNode(), pobj.getSpellcastingClass(), pobj.getSpellLevel());
                        if (pobj.getSpell() != null) {
                            pathList.add(pobj.getSpell().getSchool());
                        }
                        pathList.removeAll(Collections.singleton(null));
                        if (pobj.getSpell() == null) {
                            pathList.removeLast();
                        }
                        path = new TreeViewPath<SpellSupportFacade.SpellNode>(pobj, pathList.toArray());
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            } else {
                path = new TreeViewPath<SpellSupportFacade.SuperNode>(node);
            }
            return Arrays.asList(path);
        }
    }
}

