/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import javax.swing.JFormattedTextField;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;

public abstract class BigDecimalFieldHandler
implements PropertyChangeListener,
ReferenceListener<BigDecimal> {
    private JFormattedTextField field;
    private ReferenceFacade<BigDecimal> ref;

    public BigDecimalFieldHandler(JFormattedTextField field, ReferenceFacade<BigDecimal> ref) {
        this.field = field;
        this.ref = ref;
    }

    public JFormattedTextField getFormattedTextField() {
        return this.field;
    }

    public void install() {
        this.field.setValue(this.ref.getReference());
        this.field.addPropertyChangeListener(this);
        this.ref.addReferenceListener(this);
    }

    public void uninstall() {
        this.field.removePropertyChangeListener(this);
        this.ref.removeReferenceListener(this);
    }

    @Override
    public void referenceChanged(ReferenceEvent<BigDecimal> e) {
        BigDecimal newVal = e.getNewReference();
        BigDecimal oldVal = new BigDecimal(((Number)this.field.getValue()).doubleValue());
        if (oldVal.compareTo(newVal) != 0) {
            this.field.setValue(newVal);
        }
    }

    protected abstract void valueChanged(BigDecimal var1);

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.valueChanged(new BigDecimal(((Number)this.field.getValue()).doubleValue()));
    }
}

