/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.math.NumberUtils;
import pcgen.core.RollingMethods;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.table.IntegerEditor;

public class CharacterHPDialog
extends JDialog
implements ActionListener {
    private final CharacterFacade character;
    private final CharacterLevelsFacade levels;
    private final JLabel totalHp;
    private final HPTableModel tableModel;

    private CharacterHPDialog(Frame frame, CharacterFacade character) {
        super(frame, true);
        this.character = character;
        this.levels = character.getCharacterLevelsFacade();
        this.totalHp = new JLabel();
        this.tableModel = new HPTableModel();
        this.initComponents();
        this.pack();
    }

    public static void showHPDialog(Component parent, CharacterFacade character) {
        Frame frame = JOptionPane.getFrameForComponent(parent);
        CharacterHPDialog dialog = new CharacterHPDialog(frame, character);
        Utility.setDialogRelativeLocation(frame, dialog);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JTable table = new JTable(this.tableModel){

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 5) {
                    String hd = CharacterHPDialog.this.levels.getClassTaken((CharacterLevelFacade)CharacterHPDialog.this.levels.getElementAt(row)).getHD();
                    int max = NumberUtils.toInt(hd);
                    return new IntegerEditor(1, max);
                }
                return super.getCellEditor(row, column);
            }
        };
        table.setDefaultRenderer(JButton.class, new Renderer());
        table.setDefaultEditor(JButton.class, new Editor());
        table.setCellSelectionEnabled(false);
        table.setRowHeight(new IntegerEditor((int)1, (int)10).getPreferredSize().height);
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(table);
        pane.add((Component)scrollPane, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Total Hp:"));
        box.add(Box.createHorizontalStrut(3));
        final ReferenceListener<Integer> hpListener = new ReferenceListener<Integer>(){

            @Override
            public void referenceChanged(ReferenceEvent<Integer> e) {
                CharacterHPDialog.this.totalHp.setText(e.getNewReference().toString());
            }
        };
        ReferenceFacade<Integer> hpRef = this.character.getTotalHPRef();
        this.totalHp.setText(hpRef.getReference().toString());
        hpRef.addReferenceListener(hpListener);
        box.add(this.totalHp);
        box.add(Box.createHorizontalStrut(5));
        JButton button = new JButton("Reroll All");
        button.setActionCommand("Reroll");
        button.addActionListener(this);
        box.add(button);
        box.add(Box.createHorizontalGlue());
        button = new JButton("Close");
        button.setActionCommand("Close");
        button.addActionListener(this);
        box.add(button);
        pane.add((Component)box, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CharacterHPDialog.this.levels.removeHitPointListener(CharacterHPDialog.this.tableModel);
                CharacterHPDialog.this.character.getTotalHPRef().removeReferenceListener(hpListener);
            }
        });
        Utility.installEscapeCloseOperation(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Reroll")) {
            for (int l = 0; l < this.levels.getSize(); ++l) {
                CharacterLevelFacade level = (CharacterLevelFacade)this.levels.getElementAt(l);
                Integer i = Integer.valueOf(this.levels.getClassTaken(level).getHD());
                int rolled = RollingMethods.roll(i);
                this.levels.setHPRolled(level, rolled);
            }
            return;
        }
        this.dispose();
    }

    private class Editor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JButton button = new JButton();
        private int editingRow;

        public Editor() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setText("Reroll");
            this.button.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editingRow = row;
            return this.button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CharacterLevelFacade level = (CharacterLevelFacade)CharacterHPDialog.this.levels.getElementAt(this.editingRow);
            Integer i = Integer.valueOf(CharacterHPDialog.this.levels.getClassTaken(level).getHD());
            int rolled = RollingMethods.roll(i);
            CharacterHPDialog.this.levels.setHPRolled(level, rolled);
            this.cancelCellEditing();
        }
    }

    private class Renderer
    implements TableCellRenderer {
        private JButton button = new JButton();

        public Renderer() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setText("Reroll");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.button;
        }
    }

    private class HPTableModel
    extends AbstractTableModel
    implements CharacterLevelsFacade.HitPointListener {
        public HPTableModel() {
            CharacterHPDialog.this.levels.addHitPointListener(this);
        }

        @Override
        public int getRowCount() {
            return CharacterHPDialog.this.levels.getSize();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 3: 
                case 4: 
                case 5: {
                    return Integer.class;
                }
                case 6: {
                    return JButton.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Level";
                }
                case 1: {
                    return "Class";
                }
                case 2: {
                    return "Sides";
                }
                case 3: {
                    return "Total";
                }
                case 4: {
                    return "Adj";
                }
                case 5: {
                    return "Rolled";
                }
            }
            return "Reroll";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CharacterLevelFacade level = (CharacterLevelFacade)CharacterHPDialog.this.levels.getElementAt(rowIndex);
            ClassFacade c = CharacterHPDialog.this.levels.getClassTaken(level);
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return c;
                }
                case 2: {
                    return c.getHD();
                }
                case 3: {
                    return CharacterHPDialog.this.levels.getHPGained(level);
                }
                case 4: {
                    return CharacterHPDialog.this.levels.getHPGained(level) - CharacterHPDialog.this.levels.getHPRolled(level);
                }
                case 5: {
                    return CharacterHPDialog.this.levels.getHPRolled(level);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            CharacterLevelFacade level = (CharacterLevelFacade)CharacterHPDialog.this.levels.getElementAt(rowIndex);
            CharacterHPDialog.this.levels.setHPRolled(level, (Integer)aValue);
        }

        @Override
        public void hitPointsChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
            this.fireTableRowsUpdated(e.getBaseLevelIndex(), e.getBaseLevelIndex());
        }
    }
}

