/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;

public class PreStatParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"STAT", "STATEQ", "STATGT", "STATGTEQ", "STATLT", "STATLTEQ", "STATNEQ"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        try {
            prereq.setKind(null);
            String compType = kind.substring(4);
            if (compType.length() == 0) {
                compType = "gteq";
            }
            String[] tokens = formula.split(",|\\|");
            int currToken = 0;
            String aString = tokens[currToken++];
            try {
                prereq.setOperand(Integer.toString(Integer.parseInt(aString)));
            }
            catch (NumberFormatException e) {
                Logging.errorPrint((String)("Badly formed PRESTAT attribute: " + aString));
                prereq.setOperand("1");
            }
            while (currToken < tokens.length) {
                int idxEquals;
                if ((idxEquals = (aString = tokens[currToken++]).lastIndexOf(61)) < 3) {
                    throw new PersistenceLayerException("PRE" + this.kindsHandled()[0] + " formula '" + formula + "' is not valid.");
                }
                String stat = aString.substring(0, Math.min(3, idxEquals));
                Prerequisite statPrereq = new Prerequisite();
                statPrereq.setKind("stat");
                statPrereq.setKey(stat);
                statPrereq.setOperator(compType);
                statPrereq.setOperand(aString.substring(idxEquals + 1));
                prereq.addPrerequisite(statPrereq);
            }
            if (prereq.getPrerequisiteCount() == 1 && prereq.getOperator().equals((Object)PrerequisiteOperator.GTEQ) && prereq.getOperand().equals("1")) {
                prereq = (Prerequisite)prereq.getPrerequisites().get(0);
            }
            if (invertResult) {
                prereq.setOperator(prereq.getOperator().invert());
            }
        }
        catch (PrerequisiteException pe) {
            throw new PersistenceLayerException("Unable to parse the prerequisite :'" + kind + ":" + formula + "'. " + pe.getLocalizedMessage());
        }
        return prereq;
    }
}

