/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

class DefaultNestedBuild
extends AbstractBuildState
implements StandAloneNestedBuild {
    private final Path identityPath;
    private final BuildState owner;
    private final BuildIdentifier buildIdentifier;
    private final BuildDefinition buildDefinition;
    private final BuildTreeLifecycleController buildTreeLifecycleController;

    DefaultNestedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, BuildState owner, BuildTreeState buildTree) {
        super(buildTree, buildDefinition, owner);
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.owner = owner;
        CloseableServiceRegistry buildScopeServices = this.getBuildServices();
        try {
            ExceptionAnalyser exceptionAnalyser = (ExceptionAnalyser)buildScopeServices.get(ExceptionAnalyser.class);
            DefaultBuildTreeWorkExecutor workExecutor = new DefaultBuildTreeWorkExecutor();
            BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = (BuildTreeLifecycleControllerFactory)buildScopeServices.get(BuildTreeLifecycleControllerFactory.class);
            DoNothingBuildFinishExecutor finishExecutor = new DoNothingBuildFinishExecutor(exceptionAnalyser);
            this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createController(this.getBuildController(), (BuildTreeWorkExecutor)workExecutor, (BuildTreeFinishExecutor)finishExecutor);
        }
        catch (Throwable t) {
            CompositeStoppable.stoppable((Object[])new Object[0]).addFailure(t).add((Object)buildScopeServices).stop();
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public BuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return true;
    }

    public BuildState getOwner() {
        return this.owner;
    }

    public ExecutionResult<Void> finishBuild() {
        return this.getBuildController().finishBuild(null);
    }

    public <T> T run(Function<? super BuildTreeLifecycleController, T> buildAction) {
        return buildAction.apply((BuildTreeLifecycleController)this.buildTreeLifecycleController);
    }

    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
    }

    private static class DoNothingBuildFinishExecutor
    implements BuildTreeFinishExecutor {
        private final ExceptionAnalyser exceptionAnalyser;

        public DoNothingBuildFinishExecutor(ExceptionAnalyser exceptionAnalyser) {
            this.exceptionAnalyser = exceptionAnalyser;
        }

        public @Nullable RuntimeException finishBuildTree(List<Throwable> failures) {
            return this.exceptionAnalyser.transform(failures);
        }
    }
}

