/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.lower.MoveBodilessDeclarationsToSeparatePlaceKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00102\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013j\u0002`\u0015H\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u0010*\u00020\u00102\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013j\u0002`\u0015H\u0002J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00102\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013j\u0002`\u0015H\u0002J$\u0010\u0018\u001a\u00020\f*\u00020\u00192\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013j\u0002`\u0015H\u0002J4\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013j\u0002`\u0015*\u00020\u00102\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013j\u0002`\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "typesCaches", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector$ClassWithAppliedArguments;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lkotlin/collections/HashMap;", "collectSuperTypesTransitiveHierarchyFor", "type", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "collectSuperTypesTransitiveHierarchy", "typeSubstitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/backend/js/export/SubstitutionMap;", "findNearestExportedClass", "collectTransitiveHierarchy", "getSubstitution", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "calculateTypeSubstitutionMap", "ClassWithAppliedArguments", "backend.js"})
@SourceDebugExtension(value={"SMAP\nTransitiveExportCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransitiveExportCollector.kt\norg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n*L\n1#1,85:1\n382#2,7:86\n1374#3:93\n1460#3,5:94\n1193#3,2:103\n1267#3,4:105\n1#4:99\n1#4:101\n28#5:100\n29#5:102\n*S KotlinDebug\n*F\n+ 1 TransitiveExportCollector.kt\norg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector\n*L\n27#1:86,7\n36#1:93\n36#1:94,5\n78#1:103,2\n78#1:105,4\n74#1:101\n74#1:100\n74#1:102\n*E\n"})
public final class TransitiveExportCollector {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final HashMap<ClassWithAppliedArguments, Set<IrType>> typesCaches;

    public TransitiveExportCollector(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.typesCaches = new HashMap();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<IrType> collectSuperTypesTransitiveHierarchyFor(@NotNull IrSimpleType type) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type);
        if (irClassSymbol == null) {
            return SetsKt.emptySet();
        }
        IrClassSymbol classSymbol = irClassSymbol;
        Map map = this.typesCaches;
        ClassWithAppliedArguments key$iv = new ClassWithAppliedArguments(classSymbol, type.getArguments());
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set<IrType> answer$iv = this.collectSuperTypesTransitiveHierarchy(type, this.calculateTypeSubstitutionMap(type, MapsKt.emptyMap()));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Set)object;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrType> collectSuperTypesTransitiveHierarchy(IrSimpleType $this$collectSuperTypesTransitiveHierarchy, Map<IrTypeParameterSymbol, ? extends IrType> typeSubstitutionMap) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$collectSuperTypesTransitiveHierarchy);
        if (irClassSymbol == null) {
            return SetsKt.emptySet();
        }
        IrClassSymbol classifier = irClassSymbol;
        Iterable iterable = IrTypeUtilsKt.superTypes(classifier);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            Object object = it instanceof IrSimpleType ? (IrSimpleType)it : null;
            if (object == null || (object = this.collectTransitiveHierarchy((IrSimpleType)object, typeSubstitutionMap)) == null) {
                object = SetsKt.emptySet();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final IrSimpleType findNearestExportedClass(IrSimpleType $this$findNearestExportedClass, Map<IrTypeParameterSymbol, ? extends IrType> typeSubstitutionMap) {
        IrSimpleType irSimpleType;
        block3: {
            IrClassifierSymbol irClassifierSymbol = $this$findNearestExportedClass.getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                return null;
            }
            IrClassSymbol classifier = irClassSymbol;
            if (ExportModelGeneratorKt.isExported((IrDeclaration)classifier.getOwner(), this.context)) {
                IrType irType = IrTypeUtilsKt.substitute($this$findNearestExportedClass, typeSubstitutionMap);
                Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                return (IrSimpleType)irType;
            }
            for (IrType it : (Iterable)IrTypeUtilsKt.superTypes(classifier)) {
                boolean bl = false;
                IrSimpleType irSimpleType2 = it instanceof IrSimpleType ? (IrSimpleType)it : null;
                IrSimpleType irSimpleType3 = irSimpleType2 != null ? this.findNearestExportedClass(irSimpleType2, typeSubstitutionMap) : null;
                if (irSimpleType3 == null) continue;
                irSimpleType = irSimpleType3;
                break block3;
            }
            irSimpleType = null;
        }
        return irSimpleType;
    }

    private final Set<IrType> collectTransitiveHierarchy(IrSimpleType $this$collectTransitiveHierarchy, Map<IrTypeParameterSymbol, ? extends IrType> typeSubstitutionMap) {
        Set set;
        Object[] objectArray = $this$collectTransitiveHierarchy.getClassifier().getOwner();
        IrClass irClass = objectArray instanceof IrClass ? (IrClass)objectArray : null;
        if (irClass == null) {
            return SetsKt.emptySet();
        }
        IrClass owner = irClass;
        Map<IrTypeParameterSymbol, IrType> substitutionMap = this.calculateTypeSubstitutionMap($this$collectTransitiveHierarchy, typeSubstitutionMap);
        if (MoveBodilessDeclarationsToSeparatePlaceKt.isBuiltInClass(owner) || MoveBodilessDeclarationsToSeparatePlaceKt.isStdLibClass(owner)) {
            set = SetsKt.emptySet();
        } else if (ExportModelGeneratorKt.isExported(owner, this.context)) {
            set = SetsKt.setOf((Object)IrTypeUtilsKt.substitute($this$collectTransitiveHierarchy, substitutionMap));
        } else if (AnnotationUtilsKt.isJsImplicitExport(owner)) {
            IrSimpleType irSimpleType;
            objectArray = new IrType[2];
            objectArray[0] = IrTypeUtilsKt.substitute($this$collectTransitiveHierarchy, typeSubstitutionMap);
            IrSimpleType irSimpleType2 = irSimpleType = $this$collectTransitiveHierarchy;
            int n2 = 1;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            boolean bl2 = !IrUtilsKt.isInterface(owner);
            IrSimpleType irSimpleType3 = bl2 ? irSimpleType : null;
            objectArray2[n2] = irSimpleType3 != null ? this.findNearestExportedClass(irSimpleType3, substitutionMap) : null;
            set = SetsKt.setOfNotNull((Object[])objectArray);
        } else {
            set = this.collectSuperTypesTransitiveHierarchy($this$collectTransitiveHierarchy, substitutionMap);
        }
        return set;
    }

    private final IrType getSubstitution(IrTypeArgument $this$getSubstitution, Map<IrTypeParameterSymbol, ? extends IrType> typeSubstitutionMap) {
        IrType irType;
        IrTypeArgument irTypeArgument = $this$getSubstitution;
        if (irTypeArgument instanceof IrType) {
            irType = IrTypeUtilsKt.substitute((IrType)$this$getSubstitution, typeSubstitutionMap);
        } else if (irTypeArgument instanceof IrTypeProjection) {
            irType = IrTypeUtilsKt.substitute(((IrTypeProjection)$this$getSubstitution).getType(), typeSubstitutionMap);
        } else if (irTypeArgument instanceof IrStarProjection) {
            irType = this.context.getIrBuiltIns().getAnyNType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irType;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IrTypeParameterSymbol, IrType> calculateTypeSubstitutionMap(IrSimpleType $this$calculateTypeSubstitutionMap, Map<IrTypeParameterSymbol, ? extends IrType> typeSubstitutionMap) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$calculateTypeSubstitutionMap);
        if (irClassSymbol == null) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unexpected classifier for collecting transitive hierarchy";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$calculateTypeSubstitutionMap_u24lambda_u244 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$calculateTypeSubstitutionMap_u24lambda_u244.withIrEntry("classifier.owner", $this$calculateTypeSubstitutionMap.getClassifier().getOwner());
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        IrClassSymbol classifier = irClassSymbol;
        Iterable iterable = CollectionsKt.zip((Iterable)((IrClass)classifier.getOwner()).getTypeParameters(), (Iterable)$this$calculateTypeSubstitutionMap.getArguments());
        Map<IrTypeParameterSymbol, ? extends IrType> map = typeSubstitutionMap;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((IrTypeParameter)it.getFirst()).getSymbol(), (Object)this.getSubstitution((IrTypeArgument)it.getSecond(), typeSubstitutionMap));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.plus(map, (Map)destination$iv$iv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector$ClassWithAppliedArguments;", "", "classSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "appliedArguments", "", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Ljava/util/List;)V", "getClassSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getAppliedArguments", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    private static final class ClassWithAppliedArguments {
        @NotNull
        private final IrClassSymbol classSymbol;
        @NotNull
        private final List<IrTypeArgument> appliedArguments;

        public ClassWithAppliedArguments(@NotNull IrClassSymbol classSymbol, @NotNull List<? extends IrTypeArgument> appliedArguments) {
            Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
            Intrinsics.checkNotNullParameter(appliedArguments, (String)"appliedArguments");
            this.classSymbol = classSymbol;
            this.appliedArguments = appliedArguments;
        }

        @NotNull
        public final IrClassSymbol getClassSymbol() {
            return this.classSymbol;
        }

        @NotNull
        public final List<IrTypeArgument> getAppliedArguments() {
            return this.appliedArguments;
        }

        @NotNull
        public final IrClassSymbol component1() {
            return this.classSymbol;
        }

        @NotNull
        public final List<IrTypeArgument> component2() {
            return this.appliedArguments;
        }

        @NotNull
        public final ClassWithAppliedArguments copy(@NotNull IrClassSymbol classSymbol, @NotNull List<? extends IrTypeArgument> appliedArguments) {
            Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
            Intrinsics.checkNotNullParameter(appliedArguments, (String)"appliedArguments");
            return new ClassWithAppliedArguments(classSymbol, appliedArguments);
        }

        public static /* synthetic */ ClassWithAppliedArguments copy$default(ClassWithAppliedArguments classWithAppliedArguments, IrClassSymbol irClassSymbol, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irClassSymbol = classWithAppliedArguments.classSymbol;
            }
            if ((n2 & 2) != 0) {
                list = classWithAppliedArguments.appliedArguments;
            }
            return classWithAppliedArguments.copy(irClassSymbol, list);
        }

        @NotNull
        public String toString() {
            return "ClassWithAppliedArguments(classSymbol=" + this.classSymbol + ", appliedArguments=" + this.appliedArguments + ')';
        }

        public int hashCode() {
            int result2 = this.classSymbol.hashCode();
            result2 = result2 * 31 + ((Object)this.appliedArguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassWithAppliedArguments)) {
                return false;
            }
            ClassWithAppliedArguments classWithAppliedArguments = (ClassWithAppliedArguments)other;
            if (!Intrinsics.areEqual((Object)this.classSymbol, (Object)classWithAppliedArguments.classSymbol)) {
                return false;
            }
            return Intrinsics.areEqual(this.appliedArguments, classWithAppliedArguments.appliedArguments);
        }
    }
}

