/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class JGitUserInteraction
implements UserInteraction {
    private final CredentialsProvider provider;
    private final Map<Session, SessionListener> ongoing = new ConcurrentHashMap<Session, SessionListener>();

    public JGitUserInteraction(CredentialsProvider provider) {
        this.provider = provider;
    }

    public boolean isInteractionAllowed(ClientSession session) {
        return this.provider != null && this.provider.isInteractive();
    }

    public String[] interactive(ClientSession session, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        boolean hidden;
        ArrayList<Object> items = new ArrayList<Object>();
        int numberOfHiddenInputs = 0;
        int i2 = 0;
        while (i2 < prompt.length) {
            boolean bl = hidden = i2 < echo.length && !echo[i2];
            if (hidden) {
                ++numberOfHiddenInputs;
            }
            ++i2;
        }
        if (name != null && !name.isEmpty()) {
            items.add(new CredentialItem.InformationalMessage(name));
        }
        if (instruction != null && !instruction.isEmpty()) {
            items.add(new CredentialItem.InformationalMessage(instruction));
        }
        i2 = 0;
        while (i2 < prompt.length) {
            boolean bl = hidden = i2 < echo.length && !echo[i2];
            if (hidden && numberOfHiddenInputs == 1) {
                items.add(new CredentialItem.Password());
            } else {
                items.add(new CredentialItem.StringType(prompt[i2], hidden));
            }
            ++i2;
        }
        if (items.isEmpty()) {
            return prompt;
        }
        URIish uri = JGitUserInteraction.toURI(session.getUsername(), (InetSocketAddress)session.getConnectAddress());
        if (numberOfHiddenInputs > 0) {
            SessionListener listener = this.ongoing.get(session);
            if (listener != null) {
                this.provider.reset(uri);
            } else {
                listener = new SessionAuthMarker(this.ongoing);
                this.ongoing.put((Session)session, listener);
                session.addSessionListener(listener);
            }
        }
        if (this.provider.get(uri, items)) {
            return (String[])items.stream().map(i -> {
                if (i instanceof CredentialItem.Password) {
                    return new String(((CredentialItem.Password)i).getValue());
                }
                if (i instanceof CredentialItem.StringType) {
                    return ((CredentialItem.StringType)i).getValue();
                }
                return null;
            }).filter(s -> s != null).toArray(String[]::new);
        }
        throw new AuthenticationCanceledException();
    }

    public String resolveAuthPasswordAttempt(ClientSession session) throws Exception {
        String[] results = this.interactive(session, null, null, "", new String[]{SshdText.get().passwordPrompt}, new boolean[1]);
        return results == null || results.length == 0 ? null : results[0];
    }

    public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
        return null;
    }

    public static URIish toURI(String userName, InetSocketAddress remote) {
        String host = remote.getHostString();
        int port = remote.getPort();
        return new URIish().setScheme("ssh").setHost(host).setPort(port).setUser(userName);
    }

    private static class SessionAuthMarker
    implements SessionListener {
        private final Map<Session, SessionListener> registered;

        public SessionAuthMarker(Map<Session, SessionListener> registered) {
            this.registered = registered;
        }

        public void sessionEvent(Session session, SessionListener.Event event) {
            if (event == SessionListener.Event.Authenticated) {
                session.removeSessionListener((SessionListener)this);
                this.registered.remove(session, this);
            }
        }

        public void sessionClosed(Session session) {
            session.removeSessionListener((SessionListener)this);
            this.registered.remove(session, this);
        }
    }
}

