/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDSeparation
extends PDColorSpace {
    private static final Log log = LogFactory.getLog(PDSeparation.class);
    public static final String NAME = "Separation";

    public PDSeparation() {
        this.array = new COSArray();
        this.array.add(COSName.SEPARATION);
        this.array.add(COSName.getPDFName(""));
        this.array.add(COSNull.NULL);
        this.array.add(COSNull.NULL);
    }

    public PDSeparation(COSArray separation) {
        this.array = separation;
    }

    public COSBase getCOSObject() {
        return this.array;
    }

    public String getName() {
        return NAME;
    }

    public int getNumberOfComponents() throws IOException {
        return this.getAlternateColorSpace().getNumberOfComponents();
    }

    protected ColorSpace createColorSpace() throws IOException {
        try {
            PDColorSpace alt = this.getAlternateColorSpace();
            return alt.getJavaColorSpace();
        }
        catch (IOException ioexception) {
            log.error((Object)ioexception, (Throwable)ioexception);
            throw ioexception;
        }
        catch (Exception exception) {
            log.error((Object)exception, (Throwable)exception);
            throw new IOException("Failed to Create ColorSpace");
        }
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        log.info((Object)("About to create ColorModel for " + this.getAlternateColorSpace().toString()));
        return this.getAlternateColorSpace().createColorModel(bpc);
    }

    public String getColorantName() {
        COSName name = (COSName)this.array.getObject(1);
        return name.getName();
    }

    public void setColorantName(String name) {
        this.array.set(1, COSName.getPDFName(name));
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        COSBase alternate = this.array.getObject(2);
        PDColorSpace cs = PDColorSpaceFactory.createColorSpace(alternate);
        return cs;
    }

    public void setAlternateColorSpace(PDColorSpace cs) {
        COSBase space = null;
        if (cs != null) {
            space = cs.getCOSObject();
        }
        this.array.set(2, space);
    }

    public PDFunction getTintTransform() throws IOException {
        return PDFunction.create(this.array.getObject(3));
    }

    public void setTintTransform(PDFunction tint) {
        this.array.set(3, tint);
    }

    public COSArray calculateColorValues(COSBase tintValue) throws IOException {
        PDFunction tintTransform = this.getTintTransform();
        COSArray tint = new COSArray();
        tint.add(tintValue);
        return tintTransform.eval(tint);
    }
}

