/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRepositoryAccessor {
    private String installXmlUrl;
    private String baseUrl;
    private String installXmlString;
    private String packsInfo;
    private ArrayList<PackInfo> packs;
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String installFilename = "install.xml";
    private static final String packsinfoFilename = "packsinfo.xml";
    private static final int BUFFER_SIZE = 1000000;

    public WebRepositoryAccessor(String string) {
        this.installXmlUrl = string + "/" + installFilename;
        this.baseUrl = string;
    }

    public ArrayList<PackInfo> getOnlinePacks() {
        this.readConfig();
        this.packs = this.parsePacks();
        this.readPacksInfo();
        this.parsePacksInfo();
        return this.packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromURL(String string) {
        int n = 1000000;
        byte[] byArray = new byte[n];
        InputStream inputStream = null;
        try {
            int n2;
            WebAccessor webAccessor = new WebAccessor(null);
            inputStream = webAccessor.openInputStream(new URL(string));
            if (inputStream == null) {
                throw new RuntimeException("Unable to open network stream");
            }
            int n3 = n2 = inputStream.read(byArray);
            while (n2 > 0) {
                n2 = inputStream.read(byArray, n3, n - n3);
                n3 += n2;
            }
            String string2 = new String(byArray);
            return string2;
        }
        catch (Exception exception) {
            System.out.println(exception + " while trying to download " + string);
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readConfig() {
        this.installXmlString = this.stringFromURL(this.installXmlUrl);
    }

    private void readPacksInfo() {
        String string = this.baseUrl + "/" + packsinfoFilename;
        this.packsInfo = this.stringFromURL(string);
    }

    private ArrayList<PackInfo> parsePacks() {
        try {
            XMLParser xMLParser = new XMLParser();
            IXMLElement iXMLElement = xMLParser.parse(this.installXmlString);
            return this.loadPacksList(iXMLElement);
        }
        catch (Exception exception) {
            System.out.println("WARN: Unable to parse install.xml");
            return null;
        }
    }

    private void parsePacksInfo() {
        try {
            IXMLElement iXMLElement;
            XMLParser xMLParser = new XMLParser();
            IXMLElement iXMLElement2 = iXMLElement = xMLParser.parse(this.packsInfo);
            for (int i = 0; i < iXMLElement2.getChildrenCount(); ++i) {
                IXMLElement iXMLElement3 = iXMLElement2.getChildAtIndex(i);
                PackInfo packInfo = this.packs.get(i);
                Pack pack = packInfo.getPack();
                pack.nbytes = Long.parseLong(iXMLElement3.getAttribute("nbytes"));
            }
        }
        catch (Exception exception) {
            System.out.println("WARN: Unable to parse packsinfo.xml");
        }
    }

    public static String getCachedUrl(String string, String string2) throws Exception {
        int n = 1000000;
        byte[] byArray = new byte[n];
        try {
            WebAccessor webAccessor = new WebAccessor(null);
            InputStream inputStream = webAccessor.openInputStream(new URL(string));
            int n2 = inputStream.read(byArray);
            File file = new File(string2);
            file.mkdirs();
            File file2 = File.createTempFile("izpacktempfile", "jar", new File(string2));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            String string3 = "file:///" + file2.getAbsolutePath();
            while (n2 > 0) {
                fileOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            inputStream.close();
            fileOutputStream.close();
            return string3;
        }
        catch (SecurityException securityException) {
            System.out.println(securityException + " while trying to write temp file: " + string2);
            throw securityException;
        }
        catch (Exception exception) {
            System.out.println(exception + " while trying to download " + string);
            throw exception;
        }
    }

    protected ArrayList<PackInfo> loadPacksList(IXMLElement iXMLElement) throws CompilerException {
        ArrayList<PackInfo> arrayList = new ArrayList<PackInfo>();
        IXMLElement iXMLElement2 = this.requireChildNamed(iXMLElement, "packs");
        Vector<IXMLElement> vector = iXMLElement2.getChildrenNamed("pack");
        if (vector.isEmpty()) {
            this.parseError(iXMLElement2, "<packs> requires a <pack>");
        }
        for (IXMLElement iXMLElement3 : vector) {
            Object object;
            Object object2;
            Object object3;
            String string = this.requireAttribute(iXMLElement3, "name");
            String string2 = iXMLElement3.getAttribute("id");
            boolean bl = "true".equalsIgnoreCase(iXMLElement3.getAttribute("loose", "false"));
            String string3 = this.requireChildNamed(iXMLElement3, "description").getContent();
            boolean bl2 = this.requireYesNoAttribute(iXMLElement3, "required");
            String string4 = iXMLElement3.getAttribute("group");
            String string5 = iXMLElement3.getAttribute("installGroups");
            String string6 = iXMLElement3.getAttribute("excludeGroup");
            boolean bl3 = "yes".equalsIgnoreCase(iXMLElement3.getAttribute("uninstall", "yes"));
            String string7 = iXMLElement3.getAttribute("parent");
            if (bl2 && string6 != null) {
                this.parseError(iXMLElement3, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo packInfo = new PackInfo(string, string2, string3, bl2, bl, string6, bl3);
            packInfo.setOsConstraints(OsConstraint.getOsList(iXMLElement3));
            packInfo.setParent(string7);
            if (string6 == null) {
                packInfo.setPreselected(this.validateYesNoAttribute(iXMLElement3, "preselected", YES));
            } else {
                packInfo.setPreselected(this.validateYesNoAttribute(iXMLElement3, "preselected", NO));
            }
            if (string4 != null) {
                packInfo.setGroup(string4);
            }
            if (string5 != null) {
                Iterator<IXMLElement> iterator = new StringTokenizer(string5, ",");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    String string8 = ((StringTokenizer)((Object)iterator)).nextToken();
                    packInfo.addInstallGroup(string8);
                }
            }
            for (IXMLElement iXMLElement4 : iXMLElement3.getChildrenNamed("parsable")) {
                object3 = this.requireAttribute(iXMLElement4, "targetfile");
                object2 = iXMLElement4.getAttribute("type", "plain");
                object = iXMLElement4.getAttribute("encoding", null);
                Iterator<IXMLElement> iterator = OsConstraint.getOsList(iXMLElement4);
                packInfo.addParsable(new ParsableFile((String)object3, (String)object2, (String)object, (List<OsConstraint>)((Object)iterator)));
            }
            for (IXMLElement iXMLElement5 : iXMLElement3.getChildrenNamed("executable")) {
                object3 = new ExecutableFile();
                ((ExecutableFile)object3).path = this.requireAttribute(iXMLElement5, "targetfile");
                object2 = iXMLElement5.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).executionStage = 2;
                }
                object2 = iXMLElement5.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).type = 1;
                    ((ExecutableFile)object3).mainClass = iXMLElement5.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase((String)(object2 = iXMLElement5.getAttribute("failure", "ask")))) {
                    ((ExecutableFile)object3).onFailure = 0;
                } else if ("warn".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).onFailure = 1;
                }
                object2 = iXMLElement5.getAttribute("keep");
                ((ExecutableFile)object3).keepFile = "true".equalsIgnoreCase((String)object2);
                object = iXMLElement5.getFirstChildNamed("args");
                if (null != object) {
                    for (IXMLElement iXMLElement6 : object.getChildrenNamed("arg")) {
                        ((ExecutableFile)object3).argList.add(this.requireAttribute(iXMLElement6, "value"));
                    }
                }
                ((ExecutableFile)object3).osList = OsConstraint.getOsList(iXMLElement5);
                packInfo.addExecutable((ExecutableFile)object3);
            }
            for (IXMLElement iXMLElement7 : iXMLElement3.getChildrenNamed("updatecheck")) {
                object3 = iXMLElement7.getAttribute("casesensitive");
                object2 = new ArrayList();
                object = new ArrayList();
                for (IXMLElement iXMLElement8 : iXMLElement7.getChildrenNamed("include")) {
                    ((ArrayList)object2).add(this.requireAttribute(iXMLElement8, "name"));
                }
                for (IXMLElement iXMLElement9 : iXMLElement7.getChildrenNamed("exclude")) {
                    ((ArrayList)object).add(this.requireAttribute(iXMLElement9, "name"));
                }
                packInfo.addUpdateCheck(new UpdateCheck((ArrayList<String>)object2, (ArrayList<String>)object, (String)object3));
            }
            for (IXMLElement iXMLElement10 : iXMLElement3.getChildrenNamed("depends")) {
                object3 = this.requireAttribute(iXMLElement10, "packname");
                packInfo.addDependency((String)object3);
            }
            arrayList.add(packInfo);
        }
        return arrayList;
    }

    protected void parseError(String string) throws CompilerException {
        throw new CompilerException("install.xml:" + string);
    }

    protected void parseError(IXMLElement iXMLElement, String string) throws CompilerException {
        throw new CompilerException("install.xml:" + iXMLElement.getLineNr() + ": " + string);
    }

    protected void parseError(IXMLElement iXMLElement, String string, Throwable throwable) throws CompilerException {
        throw new CompilerException("install.xml:" + iXMLElement.getLineNr() + ": " + string, throwable);
    }

    protected void parseWarn(IXMLElement iXMLElement, String string) {
        System.out.println("install.xml:" + iXMLElement.getLineNr() + ": " + string);
    }

    protected IXMLElement requireChildNamed(IXMLElement iXMLElement, String string) throws CompilerException {
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(string);
        if (iXMLElement2 == null) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires child <" + string + ">");
        }
        return iXMLElement2;
    }

    protected URL requireURLContent(IXMLElement iXMLElement) throws CompilerException {
        URL uRL = null;
        try {
            uRL = new URL(this.requireContent(iXMLElement));
        }
        catch (MalformedURLException malformedURLException) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires valid URL", malformedURLException);
        }
        return uRL;
    }

    protected String requireContent(IXMLElement iXMLElement) throws CompilerException {
        String string = iXMLElement.getContent();
        if (string == null || string.length() == 0) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires content");
        }
        return string;
    }

    protected String requireAttribute(IXMLElement iXMLElement, String string) throws CompilerException {
        String string2 = iXMLElement.getAttribute(string);
        if (string2 == null) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires attribute '" + string + "'");
        }
        return string2;
    }

    protected int requireIntAttribute(IXMLElement iXMLElement, String string) throws CompilerException {
        String string2 = iXMLElement.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires attribute '" + string + "'");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.parseError(iXMLElement, "'" + string + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(IXMLElement iXMLElement, String string) throws CompilerException {
        String string2 = this.requireAttribute(iXMLElement, string);
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(IXMLElement iXMLElement, String string, boolean bl) {
        if (iXMLElement == null) {
            return bl;
        }
        String string2 = iXMLElement.getAttribute(string, bl ? "yes" : "no");
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseWarn(iXMLElement, "<" + iXMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no) if present");
        return bl;
    }
}

