/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,61:1\n35#2:62\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n*L\n49#1:62\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression2) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(context2, expression2)) {
            return;
        }
        Object object = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        if (object == null || (object = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object;
        FirOptInUsageBaseChecker $this$check_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        FirStatement firStatement = expression2;
        if (firStatement instanceof FirVariableAssignment) {
            Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = SetsKt.plus($this$check_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol<?>)resolvedSymbol, true, null), (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromTypeArguments(context2, CollectionsKt.emptyList()));
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, context2, reporter, experimentalities, ((FirVariableAssignment)expression2).getLValue(), null, 16, null);
        } else if (firStatement instanceof FirQualifiedAccessExpression) {
            ConeKotlinType coneKotlinType;
            FirExpression firExpression = ((FirQualifiedAccessExpression)expression2).getDispatchReceiver();
            ConeKotlinType dispatchReceiverType = firExpression != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType(firExpression)) != null ? TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneKotlinType) : null;
            Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = SetsKt.plus($this$check_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol<?>)resolvedSymbol, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromTypeArguments(context2, ((FirQualifiedAccessExpression)expression2).getTypeArguments()));
            KtSourceElement ktSourceElement2 = ((FirQualifiedAccessExpression)expression2).getSource();
            KtSourceElement source = ktSourceElement2 != null ? SourceHelpersKt.delegatedPropertySourceOrThis(context2, ktSourceElement2) : null;
            $this$check_u24lambda_u240.reportNotAcceptedExperimentalities(context2, reporter, (Collection<FirOptInUsageBaseChecker.Experimentality>)experimentalities, expression2, source);
        } else if (firStatement instanceof FirDelegatedConstructorCall && resolvedSymbol instanceof FirConstructorSymbol) {
            FirCallableSymbol $this$isFromEnumClass$iv = (FirCallableSymbol)resolvedSymbol;
            boolean $i$f$isFromEnumClass = false;
            Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$isFromEnumClass$iv.getRawStatus().isFromEnumClass() ? $this$check_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol<?>)resolvedSymbol, false, null) : $this$check_u24lambda_u240.loadExperimentalitiesFromConstructor(context2, (FirConstructorSymbol)resolvedSymbol);
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, context2, reporter, experimentalities, ((FirDelegatedConstructorCall)expression2).getCalleeReference(), null, 16, null);
        }
    }
}

