/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.util;

import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.components.JGCommandLink;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;

public final class JSDLUtils {
    private static final String NO_ASSOCIATED_PANE = "Can't find an associated pane, because the event source component is not contained in a styled pane.";
    private static ComponentListener disposeOnHideAdapter;

    private JSDLUtils() {
    }

    public static AbstractStyledPane<?> getPaneFor(EventObject evt) {
        for (Component p = (Component)evt.getSource(); p != null; p = p.getParent()) {
            Component child;
            if (p instanceof AbstractStyledPane) {
                return (AbstractStyledPane)p;
            }
            if (!(p instanceof JDialog)) continue;
            JDialog dialog = (JDialog)p;
            Container contentPane = dialog.getContentPane();
            if (contentPane instanceof AbstractStyledPane) {
                return (AbstractStyledPane)contentPane;
            }
            if (contentPane.getComponentCount() != 1 || !((child = contentPane.getComponent(0)) instanceof AbstractStyledPane)) continue;
            return (AbstractStyledPane)child;
        }
        return null;
    }

    public static void closePaneFor(EventObject evt) {
        AbstractStyledPane<?> pane = JSDLUtils.getPaneFor(evt);
        if (pane == null) {
            throw new IllegalArgumentException(NO_ASSOCIATED_PANE);
        }
        pane.close();
    }

    public static void setCommitValueFor(EventObject evt, Object commitValue) {
        AbstractStyledPane<?> pane = JSDLUtils.getPaneFor(evt);
        if (pane == null) {
            throw new IllegalArgumentException(NO_ASSOCIATED_PANE);
        }
        pane.setCommitValue(commitValue);
    }

    public static void disposeOnHide(Dialog dialog) {
        if (disposeOnHideAdapter == null) {
            disposeOnHideAdapter = new DisposeOnHideAdapter();
        }
        dialog.addComponentListener(disposeOnHideAdapter);
    }

    public static Window getWindowFor(EventObject evt) {
        if (evt == null) {
            return JSDLCommonSetup.getRootFrame();
        }
        return AncestorSupport.getWindowFor(evt);
    }

    public static Window getWindowFor(Component c) {
        if (c == null) {
            return JSDLCommonSetup.getRootFrame();
        }
        return AncestorSupport.getWindowFor(c);
    }

    public static void transferFocusToDefaultOwner(Container pane, List<JButton> commandButtons, JButton defaultButton) {
        Container rootAncestor = pane.getFocusCycleRootAncestor();
        Container comp = pane;
        while (!(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled())) {
            comp = rootAncestor;
            rootAncestor = comp.getFocusCycleRootAncestor();
        }
        if (rootAncestor != null) {
            boolean singleCommand;
            Component defaultFocusOwner = FocusTraversalUtils.getDefaultNonStaticTextFocusOwner(rootAncestor, pane);
            if (defaultFocusOwner == null) {
                pane.requestFocusInWindow();
                return;
            }
            List<JButton> nonCommandLinkCommandButtons = JSDLUtils.filterCommandLinks(commandButtons);
            boolean defaultOwnerIsCommand = nonCommandLinkCommandButtons.contains(defaultFocusOwner);
            if (!defaultOwnerIsCommand) {
                defaultFocusOwner.requestFocusInWindow();
                return;
            }
            boolean bl = singleCommand = nonCommandLinkCommandButtons.size() == 1;
            if (singleCommand) {
                if (JSDLCommonSetup.isOptimizedForScreenReader()) {
                    defaultFocusOwner.requestFocusInWindow();
                } else {
                    pane.requestFocusInWindow();
                }
                return;
            }
            if (defaultButton != null) {
                defaultButton.requestFocusInWindow();
                return;
            }
            defaultFocusOwner.requestFocusInWindow();
        }
    }

    private static List<JButton> filterCommandLinks(List<JButton> commandButtons) {
        return commandButtons.stream().filter(button -> !(button instanceof JGCommandLink)).collect(Collectors.toList());
    }

    private static final class DisposeOnHideAdapter
    extends ComponentAdapter {
        private DisposeOnHideAdapter() {
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
            ((Dialog)evt.getSource()).dispose();
        }
    }
}

