/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.util;

import com.jgoodies.common.base.Preconditions;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public final class ComponentUtils {
    private ComponentUtils() {
    }

    public static void clearFocusTraversalKeys(JComponent c) {
        c.setFocusTraversalKeys(1, null);
        c.setFocusTraversalKeys(0, null);
    }

    public static void registerKeyboardAction(JComponent component, Action action) {
        ComponentUtils.registerKeyboardAction(component, action, 0);
    }

    public static void registerKeyboardAction(JComponent component, Action action, int condition) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        ComponentUtils.registerKeyboardAction(component, action, keyStroke, condition);
    }

    public static void registerKeyboardAction(JComponent component, Action action, KeyStroke keyStroke) {
        ComponentUtils.registerKeyboardAction(component, action, keyStroke, 0);
    }

    public static void registerKeyboardAction(JComponent component, Action action, KeyStroke keyStroke, int condition) {
        if (keyStroke != null) {
            Action command = action;
            component.getInputMap(condition).put(keyStroke, command);
            component.getActionMap().put(command, action);
        }
    }

    public static void registerEnterAction(JComponent component, Action action) {
        ComponentUtils.registerKeyboardAction(component, action, KeyStroke.getKeyStroke(10, 0));
    }

    public static void registerEnterAction(Action action, JComponent ... components) {
        Preconditions.checkNotNull(components, "The %s must not be null.", "components");
        for (JComponent c : components) {
            ComponentUtils.registerEnterAction(c, action);
        }
    }

    public static void unregisterKeyboardAction(JComponent component, Action action) {
        ComponentUtils.unregisterKeyboardAction(component, action, 0);
    }

    public static void unregisterKeyboardAction(JComponent component, Action action, int condition) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        ComponentUtils.unregisterKeyboardAction(component, action, keyStroke, condition);
    }

    public static void unregisterKeyboardAction(JComponent component, Action action, KeyStroke keyStroke) {
        ComponentUtils.unregisterKeyboardAction(component, action, keyStroke, 0);
    }

    public static void unregisterKeyboardAction(JComponent component, Action action, KeyStroke keyStroke, int condition) {
        if (keyStroke != null) {
            Action command = action;
            component.getInputMap(condition).remove(keyStroke);
            component.getActionMap().remove(command);
        }
    }

    public static void setHorizontalAlignment(int alignment, JTextField ... fields) {
        Preconditions.checkNotNull(fields, "The %s must not be null.", "text field array");
        for (JTextField textField : fields) {
            textField.setHorizontalAlignment(alignment);
        }
    }
}

