/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.renderer;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.swing.ScreenScaling;
import java.awt.Component;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class JGDefaultListCellRenderer<V>
implements ListCellRenderer<V> {
    private final DefaultListCellRenderer delegate = JGDefaultListCellRenderer.createDelegate();
    private final RenderContext<V> context = new RenderContext(this);
    private final BiConsumer<V, RenderContext<V>> valueSetter;

    public JGDefaultListCellRenderer() {
        this(JGDefaultListCellRenderer.createDefaultValueSetter());
    }

    public JGDefaultListCellRenderer(Function<V, String> displayStringFunction) {
        this((V value, RenderContext<V> context) -> context.setText((String)displayStringFunction.apply(value), new Object[0]));
    }

    public JGDefaultListCellRenderer(BiConsumer<V, RenderContext<V>> valueSetter) {
        this.valueSetter = Preconditions.checkNotNull(valueSetter, "The %s must not be null.", "value setter");
    }

    private static DefaultListCellRenderer createDelegate() {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        renderer.setIconTextGap(ScreenScaling.toPhysical(renderer.getIconTextGap()));
        return renderer;
    }

    private static <V> BiConsumer<V, RenderContext<V>> createDefaultValueSetter() {
        return (value, context) -> {
            if (value instanceof Icon) {
                context.setIcon((Icon)value);
                context.setText("", new Object[0]);
            } else {
                context.setIcon(null);
                context.setText(value.toString(), new Object[0]);
            }
        };
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends V> list, V value, int index, boolean isSelected, boolean cellHasFocus) {
        this.delegate.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
        if (value != null) {
            this.setValue(value);
        }
        return this.delegate;
    }

    protected void setValue(V value) {
        this.valueSetter.accept(value, this.context);
    }

    protected final void setIcon(Icon icon) {
        this.delegate.setIcon(icon);
    }

    protected final void setText(String text, Object ... args) {
        this.delegate.setText(Strings.get(text, args));
    }

    protected final void setToolTipText(String text, Object ... args) {
        this.delegate.setToolTipText(Strings.get(text, args));
    }

    protected final void setHorizontalAlignment(int alignment) {
        this.delegate.setHorizontalAlignment(alignment);
    }

    public static final class RenderContext<E> {
        private final JGDefaultListCellRenderer<E> renderer;

        RenderContext(JGDefaultListCellRenderer<E> renderer) {
            this.renderer = renderer;
        }

        public void setIcon(Icon icon) {
            this.renderer.setIcon(icon);
        }

        public void setText(String text, Object ... args) {
            this.renderer.setText(text, args);
        }

        public void setToolTipText(String text, Object ... args) {
            this.renderer.setToolTipText(text, args);
        }

        public void setHorizontalAlignment(int alignment) {
            this.renderer.setHorizontalAlignment(alignment);
        }
    }
}

