/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics;

import com.jgoodies.app.gui.basics.icon.SymbolIconResourceConverter;
import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.jsdl.util.HTMLUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.framework.setup.AbstractUISetup;
import com.jgoodies.looks.Options;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class AppUISetup
extends AbstractUISetup<AppUISetup> {
    private final JLabel label = JGComponentFactory.getCurrent().createLabel("Phantom");

    @Override
    protected void setupLookAndFeel() throws UnsupportedLookAndFeelException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        super.setupLookAndFeel();
        UIManager.put("ToolTip.hideAccelerator", Boolean.FALSE);
    }

    @Override
    protected void setupExtras() {
        Class<?> clazz2;
        super.setupExtras();
        this.setupFluentAndDesignResources();
        try {
            clazz2 = Class.forName("com.jgoodies.app.gui.resources.WindowsFluentResources");
            clazz2.getMethod("install", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable clazz2) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("com.jgoodies.app.gui.resources.WindowsDesignResources");
            clazz2.getMethod("install", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SymbolIconResourceConverter.register();
        AppUISetup.setupExpansionControl();
        HTMLUtils.addRuleToSharedStyleSheet("ol { margin-left: 20px; }");
    }

    private void setupFluentAndDesignResources() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JLabel label = factory.createLabel("Phantom");
        Font labelFont = label.getFont();
        Font headerLabelFont = factory.createHeaderLabel("Phantom").getFont();
        Font titleLargeFont = null;
        Font titleFont = null;
        Font subtitleFont = null;
        Font bodyLargeFont = null;
        Font bodyStrongFont = null;
        Font bodyFont = null;
        Font captionFont = null;
        Font bodyClassicFont = null;
        Font captionClassicFont = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            titleLargeFont = ScreenScaling.physicalFont("Segoe UI Semibold", 0, 40);
            titleFont = ScreenScaling.physicalFont("Segoe UI Semibold", 0, 28);
            subtitleFont = ScreenScaling.physicalFont("Segoe UI", 0, 20);
            bodyLargeFont = ScreenScaling.physicalFont("Segoe UI", 0, 18);
            bodyStrongFont = ScreenScaling.physicalFont("Segoe UI Semibold", 0, 14);
            bodyFont = ScreenScaling.physicalFont("Segoe UI", 0, 14);
            bodyClassicFont = captionFont = ScreenScaling.physicalFont("Segoe UI", 0, 12);
            captionClassicFont = ScreenScaling.physicalFont("Segoe UI", 0, 10);
        } else {
            titleLargeFont = this.scaledFont(0, 40.0f);
            titleFont = this.scaledFont(0, 28.0f);
            subtitleFont = this.scaledFont(0, 20.0f);
            bodyLargeFont = this.scaledFont(0, 18.0f);
            bodyStrongFont = this.scaledFont(1, 14.0f);
            bodyFont = this.scaledFont(0, 14.0f);
            bodyClassicFont = captionFont = this.scaledFont(0, 12.0f);
            captionClassicFont = this.scaledFont(0, 10.0f);
        }
        Color mainInstructionForeground = UIManager.getColor("AbstractStyledPane.header.foreground");
        if (mainInstructionForeground == null) {
            mainInstructionForeground = UIManager.getColor("Label.header.foreground");
        }
        UIManager.put("jgoodies-fluent.titleLarge.font", titleLargeFont);
        UIManager.put("jgoodies-fluent.title.font", titleFont);
        UIManager.put("jgoodies-fluent.subtitle.font", subtitleFont);
        UIManager.put("jgoodies-fluent.bodyLarge.font", bodyLargeFont);
        UIManager.put("jgoodies-fluent.bodyStrong.font", bodyStrongFont);
        UIManager.put("jgoodies-fluent.body.font", bodyFont);
        UIManager.put("jgoodies-fluent.caption.font", captionFont);
        UIManager.put("jgoodies-design.InitialPage.instruction.foreground", Color.BLACK);
        UIManager.put("jgoodies-design.ListReport.header.background", new Color(250, 250, 250));
        UIManager.put("jgoodies-design.ListReport.headerContent.font", bodyFont);
        boolean large = Options.isLargerBodyTextEnabled();
        UIManager.put("jgoodies-design.ListItem.primary.font.small", large ? bodyStrongFont : captionFont);
        UIManager.put("jgoodies-design.ListItem.primary.foreground.small", Color.BLACK);
        UIManager.put("jgoodies-design.ListItem.secondary.font.small", large ? bodyFont : captionFont);
        UIManager.put("jgoodies-design.ListItem.secondary.foreground.small", large ? Color.BLACK : new Color(96, 96, 96));
        UIManager.put("jgoodies-design.ListItem.primary.font.medium", bodyStrongFont);
        UIManager.put("jgoodies-design.ListItem.primary.foreground.medium", Color.BLACK);
        UIManager.put("jgoodies-design.ListItem.secondary.font.medium", bodyFont);
        UIManager.put("jgoodies-design.ListItem.secondary.foreground.medium", Color.BLACK);
        UIManager.put("jgoodies-design.ObjectHeader.title.font.small", bodyStrongFont);
        UIManager.put("jgoodies-design.ObjectHeader.subtitle.font.small", captionFont);
        UIManager.put("jgoodies-design.ObjectHeader.overline.font.small", captionClassicFont);
        UIManager.put("jgoodies-design.ObjectHeader.title.font.medium", bodyLargeFont);
        UIManager.put("jgoodies-design.ObjectHeader.subtitle.font.medium", bodyFont);
        UIManager.put("jgoodies-design.ObjectHeader.overline.font.medium", captionFont);
    }

    private static void setupExpansionControl() {
        UIManager.put("CollapsedControl.icon", WindowsIcon.CHEVRON_DOWN_MED.toIcon(14, Color.BLACK));
        UIManager.put("CollapsedControl.rolloverIcon", null);
        UIManager.put("CollapsedControl.pressedIcon", null);
        UIManager.put("ExpandedControl.icon", WindowsIcon.CHEVRON_UP_MED.toIcon(14, Color.BLACK));
        UIManager.put("ExpandedControl.rolloverIcon", null);
        UIManager.put("ExpandedControl.pressedIcon", null);
    }

    private Font scaledFont(int style, float size) {
        return this.label.getFont().deriveFont(style, ScreenScaling.toPhysical(size));
    }
}

