/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.domain.address;

import com.jgoodies.app.domain.address.BaseAddress;
import com.jgoodies.app.domain.address.Country;
import com.jgoodies.common.base.Strings;
import java.util.Objects;

public final class LabeledAddress
extends BaseAddress<Country.BaseCountry> {
    public static final String PROPERTY_LABEL = "label";
    private String label = "";

    public LabeledAddress() {
        this.setCountry(new Country.Builder().build());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newValue) {
        this.label = newValue;
        this.firePropertyChange(PROPERTY_LABEL, this.label, this.label);
    }

    public boolean isEmpty() {
        return Strings.isBlank(this.getLine1()) && Strings.isBlank(this.getLine2()) && Strings.isBlank(this.getStreetline1()) && Strings.isBlank(this.getStreetline2()) && Strings.isBlank(this.getZipCode()) && Strings.isBlank(this.getCity()) && Strings.isBlank(this.getArea()) && (((Country.BaseCountry)this.getCountry()).isDefault() || ((Country.BaseCountry)this.getCountry()).isEmpty());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + Objects.hash(this.label);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabeledAddress other = (LabeledAddress)obj;
        return Objects.equals(this.label, other.label);
    }

    public static final class Builder
    extends BaseAddress.AbstractBuilder<Country.BaseCountry, LabeledAddress, Builder> {
        public Builder() {
            super(new LabeledAddress());
        }

        public static Builder of(LabeledAddress original) {
            return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().label(original.getLabel()).line1(original.getLine1(), new Object[0])).line2(original.getLine2(), new Object[0])).streetline1(original.getStreetline1(), new Object[0])).streetline2(original.getStreetline2(), new Object[0])).zip(original.getZipCode())).city(original.getCity())).area(original.getArea())).country(original.getCountry());
        }

        public Builder label(String value) {
            ((LabeledAddress)this.target).setLabel(value);
            return this;
        }
    }
}

