/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPostfixExpression;
import net.sourceforge.pmd.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public class NameOccurrence {
    private SimpleNode location;
    private String image;
    private NameOccurrence qualifiedName;
    private boolean isMethodOrConstructorInvocation;
    private int argumentCount;

    public NameOccurrence(SimpleNode location, String image) {
        this.location = location;
        this.image = image;
    }

    public void setIsMethodOrConstructorInvocation() {
        this.isMethodOrConstructorInvocation = true;
    }

    public void setArgumentCount(int count) {
        this.argumentCount = count;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public boolean isMethodOrConstructorInvocation() {
        return this.isMethodOrConstructorInvocation;
    }

    public void setNameWhichThisQualifies(NameOccurrence qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public NameOccurrence getNameForWhichThisIsAQualifier() {
        return this.qualifiedName;
    }

    public boolean isPartOfQualifiedName() {
        return this.qualifiedName != null;
    }

    public SimpleNode getLocation() {
        return this.location;
    }

    public boolean isOnRightHandSide() {
        SimpleNode node = (SimpleNode)this.location.jjtGetParent().jjtGetParent().jjtGetParent();
        return node instanceof ASTExpression && node.jjtGetNumChildren() == 3;
    }

    public boolean isOnLeftHandSide() {
        SimpleNode primaryExpression;
        if (this.location.jjtGetParent() instanceof ASTPrimaryExpression) {
            primaryExpression = (SimpleNode)this.location.jjtGetParent().jjtGetParent();
        } else if (this.location.jjtGetParent().jjtGetParent() instanceof ASTPrimaryExpression) {
            primaryExpression = (SimpleNode)this.location.jjtGetParent().jjtGetParent().jjtGetParent();
        } else {
            throw new RuntimeException("Found a NameOccurrence that didn't have an ASTPrimary Expression as parent or grandparent.  Parent = " + this.location.jjtGetParent() + " and grandparent = " + this.location.jjtGetParent().jjtGetParent());
        }
        if (this.isStandAlonePostfix(primaryExpression)) {
            return true;
        }
        if (primaryExpression.jjtGetNumChildren() <= 1) {
            return false;
        }
        if (!(primaryExpression.jjtGetChild(1) instanceof ASTAssignmentOperator)) {
            return false;
        }
        if (this.isPartOfQualifiedName()) {
            return false;
        }
        return !this.isCompoundAssignment(primaryExpression);
    }

    private boolean isCompoundAssignment(SimpleNode primaryExpression) {
        return ((ASTAssignmentOperator)primaryExpression.jjtGetChild(1)).isCompound();
    }

    private boolean isStandAlonePostfix(SimpleNode primaryExpression) {
        if (!(primaryExpression instanceof ASTPostfixExpression) || !(primaryExpression.jjtGetParent() instanceof ASTStatementExpression)) {
            return false;
        }
        ASTPrimaryPrefix pf = (ASTPrimaryPrefix)((ASTPrimaryExpression)primaryExpression.jjtGetChild(0)).jjtGetChild(0);
        if (pf.usesThisModifier()) {
            return true;
        }
        return this.thirdChildHasDottedName(primaryExpression);
    }

    private boolean thirdChildHasDottedName(SimpleNode primaryExpression) {
        Node thirdChild = primaryExpression.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0);
        return thirdChild instanceof ASTName && ((ASTName)thirdChild).getImage().indexOf(46) == -1;
    }

    public boolean isSelfAssignment() {
        Node gp;
        Node l = this.location;
        while (true) {
            ASTAssignmentOperator op;
            ASTStatementExpression exp;
            Node p;
            Node node;
            if ((node = (gp = (p = l.jjtGetParent()).jjtGetParent()).jjtGetParent()) instanceof ASTPreDecrementExpression || node instanceof ASTPreIncrementExpression || node instanceof ASTPostfixExpression) {
                return true;
            }
            if (node instanceof ASTStatementExpression && (exp = (ASTStatementExpression)node).jjtGetNumChildren() >= 2 && exp.jjtGetChild(1) instanceof ASTAssignmentOperator && (op = (ASTAssignmentOperator)exp.jjtGetChild(1)).isCompound()) {
                return true;
            }
            if (!(p instanceof ASTPrimaryPrefix) || p.jjtGetNumChildren() != 1 || !(gp instanceof ASTPrimaryExpression) || gp.jjtGetNumChildren() != 1 || !(node instanceof ASTExpression) || node.jjtGetNumChildren() != 1 || !(node.jjtGetParent() instanceof ASTPrimaryPrefix) || node.jjtGetParent().jjtGetNumChildren() != 1) break;
            l = node;
        }
        return gp instanceof ASTPreDecrementExpression || gp instanceof ASTPreIncrementExpression || gp instanceof ASTPostfixExpression;
    }

    public boolean isThisOrSuper() {
        return this.image.equals("this") || this.image.equals("super");
    }

    public boolean equals(Object o) {
        NameOccurrence n = (NameOccurrence)o;
        return n.getImage().equals(this.getImage());
    }

    public int hashCode() {
        return this.getImage().hashCode();
    }

    public String getImage() {
        return this.image;
    }

    public String toString() {
        return this.getImage() + ":" + this.location.getBeginLine() + ":" + this.location.getClass() + (this.isMethodOrConstructorInvocation() ? "(method call)" : "");
    }
}

