/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.diagram.ui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Action;
import org.argouml.ui.ArgoJMenu;
import org.argouml.ui.targetmanager.TargetManager;
import org.argouml.uml.diagram.static_structure.ui.FigPackage;
import org.dbuml.argo.uml.diagram.ui.DBFigure;
import org.dbuml.argo.uml.ui.ActionGenerateSource;
import org.dbuml.argo.uml.ui.ActionImportTablesFromCatalog;
import org.dbuml.argo.uml.ui.ActionImportViews;
import org.dbuml.argo.uml.ui.ActionUpdateCatalog;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.tigris.gef.graph.GraphModel;

public class FigSchema
extends FigPackage
implements DBFigure {
    private static Color filler = Color.YELLOW;

    public FigSchema(Object node, int x, int y) {
        super(node, x, y);
        this.setFillColor(filler);
    }

    public FigSchema(Object node) {
        super(node, 0, 0);
        this.setFillColor(filler);
    }

    public FigSchema(GraphModel gm, Object node) {
        super(gm, node);
        this.setFillColor(filler);
    }

    public Vector getAdditionalPopUpActions() {
        Vector<Object> popUpActions = new Vector<Object>();
        Object model = TargetManager.getInstance().getModelTarget();
        Database database = DBModelFacade.getInstance().getOwningDatabase(this.getOwner());
        if (database != null && DBModelFacade.getInstance().getOwningSchema(model) != null) {
            if (database.isConnected()) {
                ArgoJMenu importMenu = new ArgoJMenu(Translator.getInstance().localize("IMPORT_FROM_CATALOG"));
                importMenu.add((Action)((Object)ActionImportTablesFromCatalog.SINGLETON));
                importMenu.add((Action)((Object)ActionImportViews.SINGLETON));
                popUpActions.addElement(importMenu);
                popUpActions.addElement((Object)ActionUpdateCatalog.SINGLETON);
            }
            popUpActions.addElement((Object)ActionGenerateSource.SINGLETON);
        }
        return popUpActions;
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        popUpActions.addAll(this.getAdditionalPopUpActions());
        return popUpActions;
    }

    public String placeString() {
        return "new " + this.getDBFigName();
    }

    public String getTipString(MouseEvent me) {
        return this.getDBFigName() + ": " + this.getName();
    }

    public String getDBFigName() {
        return "Schema";
    }
}

