/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

public class Substring
implements CharSequence {
    private final String base;
    private final int beginIndex;
    private final int endIndex;

    public static CharSequence of(String base, int beginIndex, int endIndex) {
        return new Substring(base, beginIndex, endIndex);
    }

    private Substring(String base, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException("beginIndex must be at least 0");
        }
        if (endIndex < 0) {
            throw new StringIndexOutOfBoundsException("endIndex must be at least 0");
        }
        if (endIndex < beginIndex) {
            throw new StringIndexOutOfBoundsException("endIndex must not be less than beginIndex");
        }
        if (endIndex > base.length()) {
            throw new StringIndexOutOfBoundsException("endIndex must not be greater than length");
        }
        this.base = base;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    @Override
    public int length() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || this.beginIndex + index >= this.endIndex) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + index);
        }
        return this.base.charAt(index + this.beginIndex);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || this.beginIndex + start > this.endIndex) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || this.beginIndex + end > this.endIndex) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + end);
        }
        return new Substring(this.base, this.beginIndex + start, this.beginIndex + end);
    }

    @Override
    public String toString() {
        return this.base.substring(this.beginIndex, this.endIndex);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }
}

