/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.Machine;
import jrm.profile.data.Samples;

public final class MachineListRenderer {
    private static final ImageIcon folder_closed_green = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/folder_closed_green.png"));
    private static final ImageIcon folder_closed_orange = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/folder_closed_orange.png"));
    private static final ImageIcon folder_closed_red = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/folder_closed_red.png"));
    private static final ImageIcon folder_closed_gray = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/folder_closed_gray.png"));
    public static String[] columns = new String[]{Messages.getString("MachineListRenderer.Status"), Messages.getString("MachineListRenderer.Name"), Messages.getString("MachineListRenderer.Description"), Messages.getString("MachineListRenderer.Have"), Messages.getString("MachineListRenderer.CloneOf"), Messages.getString("MachineListRenderer.RomOf"), Messages.getString("MachineListRenderer.SampleOf"), Messages.getString("MachineListRenderer.Selected")};
    public static Class<?>[] columnsTypes = new Class[]{Object.class, Object.class, String.class, String.class, Object.class, Object.class, String.class, Boolean.class};
    public static int[] columnsWidths = new int[]{-20, 40, 200, -45, 40, 40, 40, -20};
    public static TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Machine) {
                super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
                switch (((Machine)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){
        ImageIcon application_osx_terminal = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/icons/application_osx_terminal.png"));
        ImageIcon computer = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/icons/computer.png"));
        ImageIcon wrench = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/icons/wrench.png"));
        ImageIcon joystick = new ImageIcon(MachineListRenderer.class.getResource("/jrm/resources/icons/joystick.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Machine) {
                super.getTableCellRendererComponent(table, ((Machine)value).getBaseName(), isSelected, hasFocus, row, column);
                if (((Machine)value).isbios) {
                    this.setIcon(this.application_osx_terminal);
                } else if (((Machine)value).isdevice) {
                    this.setIcon(this.computer);
                } else if (((Machine)value).ismechanical) {
                    this.setIcon(this.wrench);
                } else {
                    this.setIcon(this.joystick);
                }
                this.setText(((Machine)value).getBaseName());
                return this;
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(this.getText());
            return this;
        }
    }, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(0);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Machine) {
                super.getTableCellRendererComponent(table, ((Machine)value).getBaseName(), isSelected, hasFocus, row, column);
                switch (((Machine)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            if (value != null) {
                this.setIcon(folder_closed_gray);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Machine) {
                super.getTableCellRendererComponent(table, ((Machine)value).getBaseName(), isSelected, hasFocus, row, column);
                switch (((Machine)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            if (value != null) {
                this.setIcon(folder_closed_gray);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Samples) {
                super.getTableCellRendererComponent(table, ((Samples)value).getBaseName(), isSelected, hasFocus, row, column);
                switch (((Samples)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            if (value != null) {
                this.setIcon(folder_closed_gray);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, null};

    private MachineListRenderer() {
    }
}

