/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Function;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.rundeck.client.api.AuthorizationFailed;
import org.rundeck.client.api.RequestFailed;
import org.rundeck.client.api.model.ErrorDetail;
import org.rundeck.client.api.model.ErrorResponse;
import org.rundeck.client.util.ServiceClient;
import org.rundeck.client.util.Xml;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Client<T>
implements ServiceClient<T> {
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json");
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType MEDIA_TYPE_XML = MediaType.parse("application/xml");
    public static final String APPLICATION_ZIP = "application/zip";
    public static final MediaType MEDIA_TYPE_ZIP = MediaType.parse("application/zip");
    public static final String APPLICATION_PGP_KEYS = "application/pgp-keys";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_X_RUNDECK_PWORD_MIME_TYPE = "application/x-rundeck-data-password";
    public static final MediaType MEDIA_TYPE_GPG_KEYS = MediaType.parse("application/pgp-keys");
    public static final MediaType MEDIA_TYPE_OCTET_STREAM = MediaType.parse("application/octet-stream");
    public static final MediaType MEDIA_TYPE_X_RUNDECK_PASSWORD = MediaType.parse("application/x-rundeck-data-password");
    public static final String APPLICATION_YAML = "application/yaml";
    public static final MediaType MEDIA_TYPE_YAML = MediaType.parse("application/yaml");
    public static final MediaType MEDIA_TYPE_TEXT_YAML = MediaType.parse("text/yaml");
    public static final MediaType MEDIA_TYPE_TEXT_XML = MediaType.parse("text/xml");
    public static final String API_ERROR_API_VERSION_UNSUPPORTED = "api.error.api-version.unsupported";
    private T service;
    private Retrofit retrofit;
    private final int apiVersion;
    private final String appBaseUrl;
    private final String apiBaseUrl;
    private final boolean allowVersionDowngrade;
    private final Logger logger;
    private final Closeable closer;

    public Client(T service, Retrofit retrofit, String appBaseUrl, String apiBaseUrl, int apiVersion, boolean allowVersionDowngrade, Logger logger) {
        this.service = service;
        this.retrofit = retrofit;
        this.appBaseUrl = appBaseUrl;
        this.apiBaseUrl = apiBaseUrl;
        this.apiVersion = apiVersion;
        this.allowVersionDowngrade = allowVersionDowngrade;
        this.logger = logger;
        this.closer = () -> {};
    }

    public Client(T service, Retrofit retrofit, Closeable closer, String appBaseUrl, String apiBaseUrl, int apiVersion, boolean allowVersionDowngrade, Logger logger) {
        this.service = service;
        this.retrofit = retrofit;
        this.appBaseUrl = appBaseUrl;
        this.apiBaseUrl = apiBaseUrl;
        this.apiVersion = apiVersion;
        this.allowVersionDowngrade = allowVersionDowngrade;
        this.logger = logger;
        this.closer = closer;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    public <R> R checkError(Call<R> execute2) throws IOException {
        Response<R> response = execute2.execute();
        return this.checkError(response);
    }

    @Override
    public <R> ServiceClient.WithErrorResponse<R> checkErrorResponse(Call<R> execute2) throws IOException {
        Response<R> response = execute2.execute();
        return this.checkErrorResponse(response);
    }

    @Override
    public <R> R checkErrorDowngradable(Call<R> execute2) throws IOException, UnsupportedVersionDowngrade {
        Response<R> response = execute2.execute();
        return this.checkErrorDowngradable(response);
    }

    public <R> ServiceClient.WithErrorResponse<R> checkErrorResponseDowngradable(Call<R> execute2) throws IOException, UnsupportedVersionDowngrade {
        Response<R> response = execute2.execute();
        return this.checkErrorResponseDowngradable(response);
    }

    @Override
    public String getAppBaseUrl() {
        return this.appBaseUrl;
    }

    @Override
    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    @Override
    public <R> R checkError(Response<R> response) throws IOException {
        if (!response.isSuccessful()) {
            this.handleError(response, this.readError(response));
        }
        return response.body();
    }

    @Override
    public <R> R checkError(ServiceClient.WithErrorResponse<R> response) throws IOException {
        if (!response.getResponse().isSuccessful()) {
            this.handleError(response.getResponse(), this.readError(response.getErrorBody()));
        }
        return response.getResponse().body();
    }

    @Override
    public <R> ServiceClient.WithErrorResponse<R> checkErrorResponse(Response<R> response) throws IOException {
        if (!response.isSuccessful()) {
            this.handleErrorResponse(response, this.readError(response));
        }
        return this.withErrorResponse(response, null);
    }

    @Override
    public <R> R checkErrorDowngradable(Response<R> response) throws IOException, UnsupportedVersionDowngrade {
        if (!response.isSuccessful()) {
            ErrorDetail error = this.readError(response);
            this.checkUnsupportedVersion(response, error);
            this.handleError(response, error);
        }
        return response.body();
    }

    public <R> ServiceClient.WithErrorResponse<R> checkErrorResponseDowngradable(Response<R> response) throws IOException, UnsupportedVersionDowngrade {
        if (!response.isSuccessful()) {
            ServiceClient.RepeatableResponse repeatResponse = this.repeatResponse(response);
            ErrorDetail error = this.readError(repeatResponse);
            this.checkUnsupportedVersion(response, error);
            return this.withErrorResponse(response, repeatResponse);
        }
        return this.withErrorResponse(response, null);
    }

    private <R> ServiceClient.WithErrorResponse<R> withErrorResponse(final Response<R> response, final ServiceClient.RepeatableResponse errorBody) {
        return new ServiceClient.WithErrorResponse<R>(){

            @Override
            public Response<R> getResponse() {
                return response;
            }

            @Override
            public ServiceClient.RepeatableResponse getErrorBody() throws IOException {
                return errorBody;
            }
        };
    }

    private <R> void handleError(Response<R> response, ErrorDetail error) {
        this.reportApiError(error);
        throw this.makeErrorThrowable(response, error);
    }

    private <R> void handleErrorResponse(Response<R> response, ErrorDetail error) {
        this.reportApiError(error);
        throw this.makeErrorThrowable(response, error);
    }

    private <R> RequestFailed makeErrorThrowable(Response<R> response, ErrorDetail error) {
        if (response.code() == 401 || response.code() == 403) {
            return new AuthorizationFailed(String.format("Authorization failed: %d %s", response.code(), response.message()), response.code(), response.message());
        }
        if (response.code() == 409) {
            return new RequestFailed(String.format("Could not create resource: %d %s", response.code(), response.message()), response.code(), response.message());
        }
        if (response.code() == 404) {
            return new RequestFailed(String.format("Could not find resource: %d %s", response.code(), response.message()), response.code(), response.message());
        }
        return new RequestFailed(String.format("Request failed: %d %s", response.code(), response.message()), response.code(), response.message());
    }

    public <R> void checkUnsupportedVersion(Response<R> response, ErrorDetail error) throws UnsupportedVersionDowngrade {
        if (null != error && this.allowVersionDowngrade && this.isUnsupportedVersionError(error) && this.isDowngradableError(error)) {
            throw new UnsupportedVersionDowngrade(error.getErrorMessage(), this.makeErrorThrowable(response, error), this.getApiVersion(), error.getApiVersion());
        }
    }

    @Override
    public void reportApiError(ErrorDetail error) {
        if (null != error) {
            this.logger.error(String.format("Error: %s", error));
            if (this.isUnsupportedVersionError(error)) {
                this.logger.warning(String.format("Note: You requested an API endpoint using an unsupported version.\nYou can set a specific version by using a Rundeck URL in the format:\n  export RD_URL=%sapi/%s", this.getAppBaseUrl(), error.getApiVersion()));
                if (this.isDowngradableError(error)) {
                    this.logger.warning("You can enable auto-downgrading to a supported version: \n  export RD_API_DOWNGRADE=true");
                }
            }
        }
    }

    private boolean isDowngradableError(ErrorDetail error) {
        return error.getApiVersion() < this.getApiVersion();
    }

    private boolean isUnsupportedVersionError(ErrorDetail error) {
        return error.getErrorCode() != null && error.getErrorCode().startsWith(API_ERROR_API_VERSION_UNSUPPORTED);
    }

    ErrorDetail readError(Response<?> execute2) throws IOException {
        return this.readError(this.repeatResponse(execute2));
    }

    ErrorDetail readError(ServiceClient.RepeatableResponse repeatResponse) throws IOException {
        if (ServiceClient.hasAnyMediaType(repeatResponse.contentType(), MEDIA_TYPE_JSON)) {
            Converter errorConverter = this.getRetrofit().responseBodyConverter((Type)((Object)ErrorResponse.class), new Annotation[0]);
            return (ErrorDetail)errorConverter.convert(repeatResponse.repeatBody());
        }
        if (ServiceClient.hasAnyMediaType(repeatResponse.contentType(), MEDIA_TYPE_TEXT_XML, MEDIA_TYPE_XML)) {
            Annotation[] annotationsByType = ErrorResponse.class.getAnnotationsByType(Xml.class);
            Converter errorConverter = this.getRetrofit().responseBodyConverter((Type)((Object)ErrorResponse.class), annotationsByType);
            return (ErrorDetail)errorConverter.convert(repeatResponse.repeatBody());
        }
        return null;
    }

    private ServiceClient.RepeatableResponse repeatResponse(Response<?> execute2) {
        ResponseBody responseBody = execute2.errorBody();
        return new RepeatResponse(responseBody);
    }

    @Override
    public <X> X readError(Response<?> execute2, Class<X> errorType, MediaType ... mediaTypes) throws IOException {
        return this.readError(this.repeatResponse(execute2), errorType, mediaTypes);
    }

    @Override
    public <X> X readError(ServiceClient.RepeatableResponse response, Class<X> errorType, MediaType ... mediaTypes) throws IOException {
        ResponseBody responseBody = response.repeatBody();
        if (ServiceClient.hasAnyMediaType(responseBody.contentType(), mediaTypes)) {
            Converter errorConverter = this.getRetrofit().responseBodyConverter(errorType, new Annotation[0]);
            return (X)errorConverter.convert(responseBody);
        }
        return null;
    }

    @Override
    public <U> U apiCall(Function<T, Call<U>> func) throws IOException {
        return this.checkError(func.apply(this.getService()));
    }

    @Override
    public <U> ServiceClient.WithErrorResponse<U> apiWithErrorResponse(Function<T, Call<U>> func) throws IOException {
        return this.checkErrorResponse(func.apply(this.getService()));
    }

    @Override
    public <U> U apiCallDowngradable(Function<T, Call<U>> func) throws IOException, UnsupportedVersionDowngrade {
        return this.checkErrorDowngradable(func.apply(this.getService()));
    }

    @Override
    public <U> ServiceClient.WithErrorResponse<U> apiWithErrorResponseDowngradable(Function<T, Call<U>> func) throws IOException, UnsupportedVersionDowngrade {
        return this.checkErrorResponseDowngradable(func.apply(this.getService()));
    }

    @Override
    public T getService() {
        return this.service;
    }

    public void setService(T service) {
        this.service = service;
    }

    @Override
    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    public void setRetrofit(Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    static class RepeatResponse
    implements ServiceClient.RepeatableResponse {
        final ResponseBody responseBody;
        byte[] bufferedBody;

        public RepeatResponse(ResponseBody responseBody) {
            this.responseBody = responseBody;
        }

        @Override
        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        @Override
        public ResponseBody repeatBody() throws IOException {
            if (null != this.bufferedBody) {
                return ResponseBody.create(this.bufferedBody, this.responseBody.contentType());
            }
            this.bufferedBody = this.responseBody.bytes();
            return ResponseBody.create(this.bufferedBody, this.responseBody.contentType());
        }
    }

    public static final class UnsupportedVersionDowngrade
    extends Exception {
        private final int requestedVersion;
        private final int latestVersion;
        private final RequestFailed requestFailed;

        public UnsupportedVersionDowngrade(String message, RequestFailed cause, int requestedVersion, int latestVersion) {
            super(message, cause);
            this.requestFailed = cause;
            this.requestedVersion = requestedVersion;
            this.latestVersion = latestVersion;
        }

        public int getSupportedVersion() {
            return this.latestVersion;
        }

        public int getRequestedVersion() {
            return this.requestedVersion;
        }

        public RequestFailed getRequestFailed() {
            return this.requestFailed;
        }
    }

    public static interface Logger {
        public void output(String var1);

        public void warning(String var1);

        public void error(String var1);
    }
}

