/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.PrologImplementationPeer;
import com.declarativa.interprolog.PrologOperatorsContext;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.Recognizer;
import java.io.File;
import java.util.Properties;

public class SWIPeer
extends PrologImplementationPeer {
    public SWIPeer(AbstractPrologEngine abstractPrologEngine) {
        super(abstractPrologEngine);
        this.operators = new PrologOperatorsContext(PrologOperatorsContext.standardSWIOperators);
        this.systemName = "SWI Prolog";
    }

    public String getBinDirectoryProperty(Properties properties) {
        return properties.getProperty("SWI_BIN_DIRECTORY");
    }

    public String executablePath(String string) {
        if (AbstractPrologEngine.isWindowsOS()) {
            return String.valueOf(string) + File.separator + "plcon";
        }
        if (AbstractPrologEngine.isMacOS()) {
            return String.valueOf(string) + File.separator + "swipl";
        }
        return String.valueOf(string) + File.separator + "pl";
    }

    public String fetchPrologNumericVersion() {
        Object[] objectArray = this.engine.deterministicGoal("current_prolog_flag(version,V), Major is floor(V/10000), VV is V-Major*10000, Minor is floor(VV/100), Patch is VV mod 100, concat_atom([Major,'.',Minor,'.',Patch],Version)", "[string(Version)]");
        return (String)objectArray[0];
    }

    public String[] alternativePrologExtensions(String string) {
        if (string.indexOf(46) != -1) {
            throw new IPException("Bad use of alternativePrologExtensions");
        }
        return new String[]{String.valueOf(string) + ".pl"};
    }

    public String prologBinToBaseDirectory(String string) {
        int n = (string = string.trim()).lastIndexOf(String.valueOf(File.separator) + "bin" + File.separator);
        if (n == -1) {
            throw new IPException("Can not determine base directory from " + string);
        }
        if ((string = string.substring(0, n)).endsWith(File.separator)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Recognizer makePromptRecognizer() {
        return new Recognizer(PrologImplementationPeer.REGULAR_PROMPT);
    }

    public Recognizer makeBreakRecognizer() {
        return new Recognizer(" " + PrologImplementationPeer.REGULAR_PROMPT);
    }

    public String interprologFilename() {
        return "swi/interprolog";
    }

    public String visualizationFilename() {
        return "visualization.P";
    }

    public String unescapedFilePath(String string) {
        if (File.separatorChar != '\\' || string.indexOf(File.separator) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == File.separatorChar) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isInterrupt(Object object) {
        return object.toString().equals("interprolog_interrupt");
    }
}

