/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.CapitalMissileWeapon;
import megamek.common.weapons.KillerWhaleHandler;
import megamek.common.weapons.SantaAnnaHandler;
import megamek.common.weapons.TeleMissileHandler;
import megamek.server.Server;

public class KillerWhaleWeapon
extends CapitalMissileWeapon {
    private static final long serialVersionUID = 8756042527483383101L;

    public KillerWhaleWeapon() {
        this.techLevel = 1;
        this.name = "Killer Whale";
        this.setInternalName(this.name);
        this.addLookupName("KillerWhale");
        this.heat = 20;
        this.damage = 4;
        this.ammoType = 57;
        this.shortRange = 7;
        this.mediumRange = 14;
        this.longRange = 21;
        this.extremeRange = 28;
        this.tonnage = 150.0f;
        this.bv = 769.0;
        this.cost = 150000.0;
        this.shortAV = 4.0;
        this.medAV = 4.0;
        this.longAV = 4.0;
        this.extAV = 4.0;
        this.maxRange = 4;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.hasFlag(512L)) {
            return new SantaAnnaHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.hasFlag(1024L)) {
            return new TeleMissileHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new KillerWhaleHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

