/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.Transporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BattleArmorHandles
implements Transporter {
    private static final long serialVersionUID = -7149931565043762975L;
    protected Entity troopers = null;
    private static final int[] EXTERIOR_LOCATIONS_FRONT = new int[]{2, 3};
    private static final int[] EXTERIOR_LOCATIONS_REAR = new int[]{1, 2, 3};
    private static final String NO_VACANCY_STRING = "A squad is loaded";
    private static final String HAVE_VACANCY_STRING = "One battle armor squad";

    protected int[] getExteriorLocs(boolean bl) {
        if (bl) {
            return EXTERIOR_LOCATIONS_REAR;
        }
        return EXTERIOR_LOCATIONS_FRONT;
    }

    protected String getBoardingEquipment() {
        return "BA-Boarding Claw";
    }

    protected String getVacancyString(boolean bl) {
        if (bl) {
            return NO_VACANCY_STRING;
        }
        return HAVE_VACANCY_STRING;
    }

    @Override
    public final boolean canLoad(Entity entity) {
        boolean bl = true;
        if (!(entity instanceof BattleArmor)) {
            bl = false;
        } else if (null != this.troopers) {
            bl = false;
        } else {
            Iterator<Mounted> iterator = entity.getMisc().iterator();
            bl = false;
            while (!bl && iterator.hasNext()) {
                Mounted mounted = iterator.next();
                EquipmentType equipmentType = mounted.getType();
                bl = equipmentType.getInternalName().equals(this.getBoardingEquipment()) && (!equipmentType.hasModes() || mounted.curMode().equals("On"));
            }
        }
        return bl;
    }

    @Override
    public final void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " onto this OmniMech.");
        }
        this.troopers = entity;
    }

    @Override
    public final Vector<Entity> getLoadedUnits() {
        Vector<Entity> vector = new Vector<Entity>(1);
        if (null != this.troopers) {
            vector.addElement(this.troopers);
        }
        return vector;
    }

    @Override
    public final boolean unload(Entity entity) {
        if (this.troopers == null || !this.troopers.equals(entity)) {
            return false;
        }
        this.troopers = null;
        return true;
    }

    @Override
    public final String getUnusedString() {
        return this.getVacancyString(null != this.troopers);
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        boolean bl2 = false;
        if (null != this.troopers) {
            int n2 = 0;
            switch (n) {
                case 1: {
                    n2 = bl ? 5 : 6;
                    break;
                }
                case 3: {
                    n2 = bl ? 4 : 2;
                    break;
                }
                case 2: {
                    int n3 = n2 = bl ? 3 : 1;
                }
            }
            if (this.troopers.locations() > n2 && this.troopers.getInternal(n2) > 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public final Entity getExteriorUnitAt(int n, boolean bl) {
        if (null != this.troopers) {
            int[] nArray = this.getExteriorLocs(bl);
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return this.troopers;
            }
        }
        return null;
    }

    @Override
    public final List<Entity> getExternalUnits() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(1);
        arrayList.add(this.troopers);
        return arrayList;
    }

    @Override
    public int getCargoMpReduction() {
        return 0;
    }
}

