/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import megamek.client.Client;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.PlayerListDialog;
import megamek.client.ui.Messages;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GameTurnChangeEvent;

public class ChatterBox
implements KeyListener {
    private static final int MAX_HISTORY = 10;
    public Client client;
    public String[] chatBuffer;
    public Panel chatPanel;
    private TextArea chatArea;
    private List playerList;
    private TextField inputField;
    private Button butDone;
    private LinkedList<String> history;
    private int historyBookmark = -1;

    public ChatterBox(ClientGUI clientGUI) {
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(new GameListenerAdapter(){

            public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
                ChatterBox.this.chatArea.append("\n" + gamePlayerChatEvent.getMessage());
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
                ChatterBox.this.moveToEnd();
            }

            public void gamePlayerChange(GamePlayerChangeEvent gamePlayerChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }
        });
        this.history = new LinkedList();
        this.chatArea = new TextArea(" \n", GUIPreferences.getInstance().getInt("AdvancedChatboxSize"), 40, 1);
        this.chatArea.setEditable(false);
        this.playerList = new List(GUIPreferences.getInstance().getInt("AdvancedChatboxSize"));
        this.inputField = new TextField();
        this.inputField.addKeyListener(this);
        this.butDone = new Button(Messages.getString("ChatterBox.ImDone"));
        this.butDone.setEnabled(false);
        this.chatPanel = new Panel(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)this.chatArea, "Center");
        panel.add((Component)this.playerList, "West");
        panel.add((Component)this.inputField, "South");
        this.chatPanel.add((Component)panel, "Center");
        this.chatPanel.add((Component)this.butDone, "East");
    }

    public void moveToEnd() {
        if (this.chatArea.isShowing()) {
            int n = this.chatArea.getText().length() - 1;
            this.chatArea.select(n, n);
            this.chatArea.setCaretPosition(n);
        }
    }

    public Component getComponent() {
        return this.chatPanel;
    }

    public void systemMessage(String string) {
        this.chatArea.append("\nMegaMek: " + string);
        this.moveToEnd();
    }

    public void setDoneButton(Button button) {
        this.chatPanel.remove(this.butDone);
        this.butDone = button;
        this.chatPanel.add((Component)this.butDone, "East");
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.history.addFirst(this.inputField.getText());
            this.historyBookmark = -1;
            if (!this.inputField.getText().startsWith("#")) {
                this.client.sendChat(this.inputField.getText());
            } else {
                this.systemMessage(this.client.runCommand(this.inputField.getText()));
            }
            this.inputField.setText("");
            if (this.history.size() > 10) {
                this.history.removeLast();
            }
        } else if (keyEvent.getKeyCode() == 38) {
            ++this.historyBookmark;
            this.fetchHistory();
        } else if (keyEvent.getKeyCode() == 40) {
            --this.historyBookmark;
            this.fetchHistory();
        }
        this.moveToEnd();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void fetchHistory() {
        try {
            this.inputField.setText(this.history.get(this.historyBookmark));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.inputField.setText("");
            this.historyBookmark = -1;
        }
    }
}

