/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.dexmaker.dx.rop.code;

import org.droidparts.dexmaker.dx.rop.code.Insn;
import org.droidparts.dexmaker.dx.rop.code.RegisterSpec;
import org.droidparts.dexmaker.dx.rop.code.RegisterSpecList;
import org.droidparts.dexmaker.dx.rop.code.Rop;
import org.droidparts.dexmaker.dx.rop.code.SourcePosition;
import org.droidparts.dexmaker.dx.rop.type.StdTypeList;
import org.droidparts.dexmaker.dx.rop.type.Type;
import org.droidparts.dexmaker.dx.rop.type.TypeList;
import org.droidparts.dexmaker.dx.util.IntList;

public final class SwitchInsn
extends Insn {
    private final IntList cases;

    public SwitchInsn(Rop opcode, SourcePosition position, RegisterSpec result, RegisterSpecList sources, IntList cases) {
        super(opcode, position, result, sources);
        if (opcode.getBranchingness() != 5) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (cases == null) {
            throw new NullPointerException("cases == null");
        }
        this.cases = cases;
    }

    @Override
    public String getInlineString() {
        return this.cases.toString();
    }

    @Override
    public TypeList getCatches() {
        return StdTypeList.EMPTY;
    }

    @Override
    public void accept(Insn.Visitor visitor) {
        visitor.visitSwitchInsn(this);
    }

    @Override
    public Insn withAddedCatch(Type type) {
        throw new UnsupportedOperationException("unsupported");
    }

    @Override
    public Insn withRegisterOffset(int delta) {
        return new SwitchInsn(this.getOpcode(), this.getPosition(), this.getResult().withOffset(delta), this.getSources().withOffset(delta), this.cases);
    }

    @Override
    public boolean contentEquals(Insn b) {
        return false;
    }

    @Override
    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new SwitchInsn(this.getOpcode(), this.getPosition(), result, sources, this.cases);
    }

    public IntList getCases() {
        return this.cases;
    }
}

