/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import groovy.lang.GString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.provider.Provider;
import org.gradle.util.CollectionUtils;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProvider<C>
implements CollectionPropertyInternal<T, C> {
    private static final EmptyCollection EMPTY_COLLECTION = new EmptyCollection();
    private static final NoValueCollector NO_VALUE_COLLECTOR = new NoValueCollector();
    private static final StringValueCollector STRING_VALUE_COLLECTOR = new StringValueCollector();
    private static final IdentityValueCollector IDENTITY_VALUE_COLLECTOR = new IdentityValueCollector();
    private final Class<? extends Collection> collectionType;
    private final Class elementType;
    private final ValueCollector<T> valueCollector;
    private Collector<T> value = EMPTY_COLLECTION;
    private List<Collector<T>> collectors = new LinkedList<Collector<T>>();

    AbstractCollectionProperty(Class<? extends Collection> collectionType, Class<T> elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.valueCollector = elementType == String.class ? STRING_VALUE_COLLECTOR : IDENTITY_VALUE_COLLECTOR;
    }

    protected abstract C fromValue(Collection<T> var1);

    public void add(T element) {
        Preconditions.checkNotNull(element, (Object)String.format("Cannot add a null element to a property of type %s.", this.collectionType.getSimpleName()));
        this.collectors.add(new SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        this.collectors.add(new ElementFromProvider<T>(providerOfElement));
    }

    public void addAll(T ... elements) {
        this.collectors.add(new ElementsFromArray<T>(elements));
    }

    public void addAll(Iterable<? extends T> elements) {
        this.collectors.add(new ElementsFromCollection<T>(elements));
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        this.collectors.add(new ElementsFromCollectionProvider(provider));
    }

    @Override
    @Nullable
    public Class<C> getType() {
        return null;
    }

    @Override
    public boolean isPresent() {
        if (!this.value.present()) {
            return false;
        }
        for (Collector<T> collector : this.collectors) {
            if (collector.present()) continue;
            return false;
        }
        return true;
    }

    @Override
    public C get() {
        ArrayList values = new ArrayList(1 + this.collectors.size());
        this.value.collectInto(this.valueCollector, values);
        for (Collector<T> collector : this.collectors) {
            collector.collectInto(this.valueCollector, values);
        }
        return this.fromValue(values);
    }

    @Nullable
    public C getOrNull() {
        ArrayList values = new ArrayList(1 + this.collectors.size());
        if (!this.value.maybeCollectInto(this.valueCollector, values)) {
            return null;
        }
        for (Collector<T> collector : this.collectors) {
            if (collector.maybeCollectInto(this.valueCollector, values)) continue;
            return null;
        }
        return this.fromValue(values);
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)object);
        }
    }

    public void set(@Nullable Iterable<? extends T> elements) {
        this.collectors.clear();
        this.value = elements == null ? NO_VALUE_COLLECTOR : new ElementsFromCollection<T>(elements);
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        this.collectors.clear();
        this.value = new ElementsFromCollectionProvider(provider);
    }

    @Override
    public String toString() {
        String valueState = this.value == EMPTY_COLLECTION ? "empty" : (this.value == NO_VALUE_COLLECTOR ? "undefined" : "defined");
        return String.format("%s(%s, %s)", this.collectionType.getSimpleName().toLowerCase(), this.elementType, valueState);
    }

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super C> transformer) {
        return new TransformBackedProvider<S, C>(transformer, this);
    }

    private static class NoValueCollector
    implements Collector<Object> {
        private NoValueCollector() {
        }

        @Override
        public boolean present() {
            return false;
        }

        @Override
        public void collectInto(ValueCollector<Object> collector, Collection<Object> dest) {
            throw new IllegalStateException("No value has been specified for this provider.");
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<Object> collector, Collection<Object> dest) {
            return false;
        }
    }

    private static class ElementsFromCollection<T>
    implements Collector<T> {
        private final Iterable<? extends T> value;

        ElementsFromCollection(Iterable<? extends T> value) {
            this.value = value;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(ValueCollector<T> collector, Collection<T> dest) {
            collector.addAll(this.value, dest);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            this.collectInto(collector, dest);
            return true;
        }
    }

    private static class ElementsFromArray<T>
    implements Collector<T> {
        private final T[] value;

        ElementsFromArray(T[] value) {
            this.value = value;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(ValueCollector<T> collector, Collection<T> dest) {
            for (T t : this.value) {
                collector.add(t, dest);
            }
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            this.collectInto(collector, dest);
            return true;
        }
    }

    private static class ElementsFromCollectionProvider<T>
    implements Collector<T> {
        private final Provider<? extends Iterable<? extends T>> providerOfElements;

        ElementsFromCollectionProvider(Provider<? extends Iterable<? extends T>> providerOfElements) {
            this.providerOfElements = providerOfElements;
        }

        @Override
        public boolean present() {
            return this.providerOfElements.isPresent();
        }

        @Override
        public void collectInto(ValueCollector<T> collector, Collection<T> dest) {
            Iterable value = (Iterable)this.providerOfElements.get();
            collector.addAll(value, dest);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            Iterable value = (Iterable)this.providerOfElements.getOrNull();
            if (value == null) {
                return false;
            }
            collector.addAll(value, dest);
            return true;
        }
    }

    private static class ElementFromProvider<T>
    implements Collector<T> {
        private final Provider<? extends T> providerOfElement;

        ElementFromProvider(Provider<? extends T> providerOfElement) {
            this.providerOfElement = providerOfElement;
        }

        @Override
        public boolean present() {
            return this.providerOfElement.isPresent();
        }

        @Override
        public void collectInto(ValueCollector<T> collector, Collection<T> dest) {
            Object value = this.providerOfElement.get();
            collector.add(value, dest);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            Object value = this.providerOfElement.getOrNull();
            if (value == null) {
                return false;
            }
            collector.add(value, dest);
            return true;
        }
    }

    private static class SingleElement<T>
    implements Collector<T> {
        private final T element;

        SingleElement(T element) {
            this.element = element;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(ValueCollector<T> collector, Collection<T> dest) {
            collector.add(this.element, dest);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            this.collectInto(collector, dest);
            return true;
        }
    }

    private static class EmptyCollection
    implements Collector<Object> {
        private EmptyCollection() {
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(ValueCollector<Object> collector, Collection<Object> dest) {
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<Object> collector, Collection<Object> dest) {
            return true;
        }
    }

    private static class StringValueCollector
    implements ValueCollector<Object> {
        private StringValueCollector() {
        }

        @Override
        public void add(Object value, Collection<Object> dest) {
            if (value instanceof GString) {
                dest.add(value.toString());
            } else {
                dest.add(value);
            }
        }

        @Override
        public void addAll(Iterable<?> values, Collection<Object> dest) {
            for (Object value : values) {
                this.add(value, dest);
            }
        }
    }

    private static class IdentityValueCollector
    implements ValueCollector<Object> {
        private IdentityValueCollector() {
        }

        @Override
        public void add(Object value, Collection<Object> dest) {
            dest.add(value);
        }

        @Override
        public void addAll(Iterable<?> values, Collection<Object> dest) {
            CollectionUtils.addAll(dest, values);
        }
    }

    private static interface Collector<T> {
        public boolean present();

        public void collectInto(ValueCollector<T> var1, Collection<T> var2);

        public boolean maybeCollectInto(ValueCollector<T> var1, Collection<T> var2);
    }

    private static interface ValueCollector<T> {
        public void add(T var1, Collection<T> var2);

        public void addAll(Iterable<? extends T> var1, Collection<T> var2);
    }
}

