/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sonatype.aether.RepositoryCache;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.SessionData;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.collection.DependencyManager;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.collection.DependencyTraverser;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultSessionData;
import org.sonatype.aether.util.graph.manager.NoopDependencyManager;
import org.sonatype.aether.util.graph.selector.StaticDependencySelector;
import org.sonatype.aether.util.graph.transformer.NoopDependencyGraphTransformer;
import org.sonatype.aether.util.graph.traverser.StaticDependencyTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositorySystemSession
implements RepositorySystemSession {
    private static final DependencyTraverser TRAVERSER = new StaticDependencyTraverser(true);
    private static final DependencyManager MANAGER = NoopDependencyManager.INSTANCE;
    private static final DependencySelector SELECTOR = new StaticDependencySelector(true);
    private static final DependencyGraphTransformer TRANSFORMER = NoopDependencyGraphTransformer.INSTANCE;
    private boolean offline;
    private boolean transferErrorCachingEnabled;
    private boolean notFoundCachingEnabled;
    private boolean ignoreMissingArtifactDescriptor;
    private boolean ignoreInvalidArtifactDescriptor;
    private String checksumPolicy;
    private String updatePolicy;
    private LocalRepositoryManager localRepositoryManager;
    private WorkspaceReader workspaceReader;
    private RepositoryListener repositoryListener;
    private TransferListener transferListener;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> userProperties = new HashMap<String, String>();
    private Map<String, Object> configProperties = new HashMap<String, Object>();
    private MirrorSelector mirrorSelector = NullMirrorSelector.INSTANCE;
    private ProxySelector proxySelector = NullProxySelector.INSTANCE;
    private AuthenticationSelector authenticationSelector = NullAuthenticationSelector.INSTANCE;
    private ArtifactTypeRegistry artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
    private DependencyTraverser dependencyTraverser = TRAVERSER;
    private DependencyManager dependencyManager = MANAGER;
    private DependencySelector dependencySelector = SELECTOR;
    private DependencyGraphTransformer dependencyGraphTransformer = TRANSFORMER;
    private SessionData data = new DefaultSessionData();
    private RepositoryCache cache;

    public DefaultRepositorySystemSession() {
    }

    public DefaultRepositorySystemSession(RepositorySystemSession session) {
        this.setOffline(session.isOffline());
        this.setTransferErrorCachingEnabled(session.isTransferErrorCachingEnabled());
        this.setNotFoundCachingEnabled(session.isNotFoundCachingEnabled());
        this.setIgnoreInvalidArtifactDescriptor(session.isIgnoreInvalidArtifactDescriptor());
        this.setIgnoreMissingArtifactDescriptor(session.isIgnoreMissingArtifactDescriptor());
        this.setChecksumPolicy(session.getChecksumPolicy());
        this.setUpdatePolicy(session.getUpdatePolicy());
        this.setLocalRepositoryManager(session.getLocalRepositoryManager());
        this.setWorkspaceReader(session.getWorkspaceReader());
        this.setRepositoryListener(session.getRepositoryListener());
        this.setTransferListener(session.getTransferListener());
        this.setSystemProperties(session.getSystemProperties());
        this.setUserProperties(session.getUserProperties());
        this.setConfigProperties(session.getConfigProperties());
        this.setMirrorSelector(session.getMirrorSelector());
        this.setProxySelector(session.getProxySelector());
        this.setAuthenticationSelector(session.getAuthenticationSelector());
        this.setArtifactTypeRegistry(session.getArtifactTypeRegistry());
        this.setDependencyTraverser(session.getDependencyTraverser());
        this.setDependencyManager(session.getDependencyManager());
        this.setDependencySelector(session.getDependencySelector());
        this.setDependencyGraphTransformer(session.getDependencyGraphTransformer());
        this.setData(session.getData());
        this.setCache(session.getCache());
    }

    public boolean isOffline() {
        return this.offline;
    }

    public DefaultRepositorySystemSession setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public boolean isTransferErrorCachingEnabled() {
        return this.transferErrorCachingEnabled;
    }

    public DefaultRepositorySystemSession setTransferErrorCachingEnabled(boolean transferErrorCachingEnabled) {
        this.transferErrorCachingEnabled = transferErrorCachingEnabled;
        return this;
    }

    public boolean isNotFoundCachingEnabled() {
        return this.notFoundCachingEnabled;
    }

    public DefaultRepositorySystemSession setNotFoundCachingEnabled(boolean notFoundCachingEnabled) {
        this.notFoundCachingEnabled = notFoundCachingEnabled;
        return this;
    }

    public boolean isIgnoreMissingArtifactDescriptor() {
        return this.ignoreMissingArtifactDescriptor;
    }

    public DefaultRepositorySystemSession setIgnoreMissingArtifactDescriptor(boolean ignoreMissingArtifactDescriptor) {
        this.ignoreMissingArtifactDescriptor = ignoreMissingArtifactDescriptor;
        return this;
    }

    public boolean isIgnoreInvalidArtifactDescriptor() {
        return this.ignoreInvalidArtifactDescriptor;
    }

    public DefaultRepositorySystemSession setIgnoreInvalidArtifactDescriptor(boolean ignoreInvalidArtifactDescriptor) {
        this.ignoreInvalidArtifactDescriptor = ignoreInvalidArtifactDescriptor;
        return this;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public DefaultRepositorySystemSession setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
        return this;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public DefaultRepositorySystemSession setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
        return this;
    }

    public LocalRepository getLocalRepository() {
        LocalRepositoryManager lrm = this.getLocalRepositoryManager();
        return lrm != null ? lrm.getRepository() : null;
    }

    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public DefaultRepositorySystemSession setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.localRepositoryManager = localRepositoryManager;
        return this;
    }

    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public DefaultRepositorySystemSession setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.workspaceReader = workspaceReader;
        return this;
    }

    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public DefaultRepositorySystemSession setRepositoryListener(RepositoryListener repositoryListener) {
        this.repositoryListener = repositoryListener;
        return this;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public DefaultRepositorySystemSession setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    private <T> Map<String, T> toSafeMap(Map<?, ?> table, Class<T> valueType) {
        HashMap<String, T> map;
        if (table == null || table.isEmpty()) {
            map = new HashMap<String, T>();
        } else {
            map = new LinkedHashMap();
            for (Object key : table.keySet()) {
                Object value;
                if (!(key instanceof String) || !valueType.isInstance(value = table.get(key))) continue;
                map.put(key.toString(), valueType.cast(value));
            }
        }
        return map;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public DefaultRepositorySystemSession setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties == null ? new HashMap<String, String>() : systemProperties;
        return this;
    }

    public DefaultRepositorySystemSession setSystemProps(Hashtable<?, ?> systemProperties) {
        this.systemProperties = this.toSafeMap(systemProperties, String.class);
        return this;
    }

    public DefaultRepositorySystemSession setSystemProperty(String key, String value) {
        if (value != null) {
            this.systemProperties.put(key, value);
        } else {
            this.systemProperties.remove(key);
        }
        return this;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public DefaultRepositorySystemSession setUserProperties(Map<String, String> userProperties) {
        this.userProperties = userProperties == null ? new HashMap<String, String>() : userProperties;
        return this;
    }

    public DefaultRepositorySystemSession setUserProps(Map<?, ?> userProperties) {
        this.userProperties = this.toSafeMap(userProperties, String.class);
        return this;
    }

    public DefaultRepositorySystemSession setUserProperty(String key, String value) {
        if (value != null) {
            this.userProperties.put(key, value);
        } else {
            this.userProperties.remove(key);
        }
        return this;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public DefaultRepositorySystemSession setConfigProperties(Map<String, Object> configProperties) {
        this.configProperties = configProperties == null ? new HashMap<String, Object>() : configProperties;
        return this;
    }

    public DefaultRepositorySystemSession setConfigProps(Map<?, ?> configProperties) {
        this.configProperties = this.toSafeMap(configProperties, Object.class);
        return this;
    }

    public DefaultRepositorySystemSession setConfigProperty(String key, Object value) {
        if (value != null) {
            this.configProperties.put(key, value);
        } else {
            this.configProperties.remove(key);
        }
        return this;
    }

    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public DefaultRepositorySystemSession setMirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        if (this.mirrorSelector == null) {
            this.mirrorSelector = NullMirrorSelector.INSTANCE;
        }
        return this;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public DefaultRepositorySystemSession setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        if (this.proxySelector == null) {
            this.proxySelector = NullProxySelector.INSTANCE;
        }
        return this;
    }

    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public DefaultRepositorySystemSession setAuthenticationSelector(AuthenticationSelector authenticationSelector) {
        this.authenticationSelector = authenticationSelector;
        if (this.authenticationSelector == null) {
            this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        }
        return this;
    }

    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public DefaultRepositorySystemSession setArtifactTypeRegistry(ArtifactTypeRegistry artifactTypeRegistry) {
        this.artifactTypeRegistry = artifactTypeRegistry;
        if (this.artifactTypeRegistry == null) {
            this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        }
        return this;
    }

    public DependencyTraverser getDependencyTraverser() {
        return this.dependencyTraverser;
    }

    public DefaultRepositorySystemSession setDependencyTraverser(DependencyTraverser dependencyTraverser) {
        this.dependencyTraverser = dependencyTraverser;
        if (this.dependencyTraverser == null) {
            this.dependencyTraverser = TRAVERSER;
        }
        return this;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public DefaultRepositorySystemSession setDependencyManager(DependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
        if (this.dependencyManager == null) {
            this.dependencyManager = MANAGER;
        }
        return this;
    }

    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public DefaultRepositorySystemSession setDependencySelector(DependencySelector dependencySelector) {
        this.dependencySelector = dependencySelector;
        if (this.dependencySelector == null) {
            this.dependencySelector = SELECTOR;
        }
        return this;
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public DefaultRepositorySystemSession setDependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        if (this.dependencyGraphTransformer == null) {
            this.dependencyGraphTransformer = TRANSFORMER;
        }
        return this;
    }

    public SessionData getData() {
        return this.data;
    }

    public DefaultRepositorySystemSession setData(SessionData data) {
        this.data = data;
        if (this.data == null) {
            this.data = new DefaultSessionData();
        }
        return this;
    }

    public RepositoryCache getCache() {
        return this.cache;
    }

    public DefaultRepositorySystemSession setCache(RepositoryCache cache) {
        this.cache = cache;
        return this;
    }

    static class NullArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        public static final ArtifactTypeRegistry INSTANCE = new NullArtifactTypeRegistry();

        NullArtifactTypeRegistry() {
        }

        public ArtifactType get(String typeId) {
            return null;
        }
    }

    static class NullAuthenticationSelector
    implements AuthenticationSelector {
        public static final AuthenticationSelector INSTANCE = new NullAuthenticationSelector();

        NullAuthenticationSelector() {
        }

        public Authentication getAuthentication(RemoteRepository repository) {
            return repository.getAuthentication();
        }
    }

    static class NullMirrorSelector
    implements MirrorSelector {
        public static final MirrorSelector INSTANCE = new NullMirrorSelector();

        NullMirrorSelector() {
        }

        public RemoteRepository getMirror(RemoteRepository repository) {
            return null;
        }
    }

    static class NullProxySelector
    implements ProxySelector {
        public static final ProxySelector INSTANCE = new NullProxySelector();

        NullProxySelector() {
        }

        public Proxy getProxy(RemoteRepository repository) {
            return repository.getProxy();
        }
    }
}

